/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.libraries.artifacts;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.lecousin.framework.application.Version;
import net.lecousin.framework.application.VersionSpecification;
import net.lecousin.framework.application.libraries.artifacts.LibrariesRepository;
import net.lecousin.framework.application.libraries.artifacts.LibraryDescriptorLoader;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.util.Pair;

public interface LibraryDescriptor {
    public LibraryDescriptorLoader getLoader();

    public String getGroupId();

    public String getArtifactId();

    public Version getVersion();

    default public String getVersionString() {
        return this.getVersion().toString();
    }

    public URI getDirectory();

    public boolean hasClasses();

    public AsyncSupplier<File, NoException> getClasses();

    public List<Dependency> getDependencies();

    public List<LibrariesRepository> getDependenciesAdditionalRepositories();

    public static interface Dependency {
        public String getGroupId();

        public String getArtifactId();

        public VersionSpecification getVersionSpecification();

        public String getClassifier();

        public boolean isOptional();

        public URI getKnownLocation();

        public List<Pair<String, String>> getExcludedDependencies();

        public static class From
        implements Dependency {
            private LibraryDescriptor lib;

            public From(LibraryDescriptor lib) {
                this.lib = lib;
            }

            @Override
            public String getGroupId() {
                return this.lib.getGroupId();
            }

            @Override
            public String getArtifactId() {
                return this.lib.getArtifactId();
            }

            @Override
            public VersionSpecification getVersionSpecification() {
                return new VersionSpecification.SingleVersion(this.lib.getVersion());
            }

            @Override
            public String getClassifier() {
                return null;
            }

            @Override
            public boolean isOptional() {
                return false;
            }

            @Override
            public URI getKnownLocation() {
                return this.lib.getDirectory();
            }

            @Override
            public List<Pair<String, String>> getExcludedDependencies() {
                return new ArrayList<Pair<String, String>>(0);
            }
        }
    }
}

