/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.libraries.classloader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.ApplicationClassLoader;
import net.lecousin.framework.application.libraries.classloader.AbstractClassLoader;
import net.lecousin.framework.application.libraries.classloader.DirectoryClassLoader;
import net.lecousin.framework.application.libraries.classloader.ZipClassLoader;
import net.lecousin.framework.collections.CompoundCollection;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOAsInputStream;
import net.lecousin.framework.io.IOFromInputStream;
import net.lecousin.framework.io.provider.FileIOProvider;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.io.provider.IOProviderFromPathUsingClassloader;

public class AppClassLoader
implements ApplicationClassLoader {
    private Application app;
    private ArrayList<AbstractClassLoader> libs = new ArrayList();
    private IOProviderFromPathUsingClassloader coreIOProvider;

    public AppClassLoader(Application app) {
        this.app = app;
        this.coreIOProvider = new IOProviderFromPathUsingClassloader(AppClassLoader.class.getClassLoader());
    }

    @Override
    public Application getApplication() {
        return this.app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractClassLoader add(File location, Collection<String> exportedJars) {
        AbstractClassLoader cl = location.isDirectory() ? new DirectoryClassLoader(this, location) : new ZipClassLoader(this, new FileIOProvider(location));
        if (exportedJars != null) {
            for (String jar : exportedJars) {
                cl.addSubLoader(new ZipClassLoader(this, new InnerJARProvider(cl, jar)));
            }
        }
        ArrayList<AbstractClassLoader> arrayList = this.libs;
        synchronized (arrayList) {
            this.libs.add(cl);
        }
        return cl;
    }

    public Class<?> loadClassFrom(String name, AbstractClassLoader first) throws ClassNotFoundException {
        try {
            return AppClassLoader.class.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            AbstractClassLoader cl;
            int i2;
            Class<?> c = null;
            for (i2 = 0; i2 < this.libs.size(); ++i2) {
                cl = this.libs.get(i2);
                c = cl.isLoaded(name);
                if (c == null) continue;
                return c;
            }
            if (first != null) {
                try {
                    c = first.loadClassInLibrary(name);
                    if (c != null) {
                        return c;
                    }
                }
                catch (FileNotFoundException i2) {
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(e.getMessage());
                }
            }
            for (i2 = 0; i2 < this.libs.size(); ++i2) {
                cl = this.libs.get(i2);
                if (cl == first) continue;
                try {
                    c = cl.loadClassInLibrary(name);
                    if (c == null) continue;
                    return c;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    continue;
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(e.getMessage());
                }
            }
            StringBuilder msg = new StringBuilder(512);
            msg.append("Class not found: ").append(name);
            msg.append("\r\nFrom class loader: ").append(first);
            msg.append("\r\nlibraries currently registered:");
            for (int i3 = 0; i3 < this.libs.size(); ++i3) {
                msg.append("\r\n - ").append(this.libs.get(i3).toString());
            }
            throw new ClassNotFoundException(msg.toString());
        }
    }

    public IO.Readable getResourceIO(String name, Task.Priority priority) {
        if (name.isEmpty()) {
            return null;
        }
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        IO.Readable io = null;
        for (int i = 0; i < this.libs.size(); ++i) {
            AbstractClassLoader cl = this.libs.get(i);
            try {
                io = cl.open(name, priority);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (io == null) continue;
            return io;
        }
        InputStream in = AppClassLoader.class.getClassLoader().getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        return new IOFromInputStream(in, name, Threading.getUnmanagedTaskManager(), priority);
    }

    public URL getResourceURL(String name) {
        if (name.isEmpty()) {
            return null;
        }
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        for (int i = 0; i < this.libs.size(); ++i) {
            AbstractClassLoader cl = this.libs.get(i);
            URL url = cl.loadResourceURL(name);
            if (url == null) continue;
            return url;
        }
        return AppClassLoader.class.getClassLoader().getResource(name);
    }

    public InputStream getResourceAsStreamFrom(String name, AbstractClassLoader first) {
        if (name.isEmpty()) {
            return null;
        }
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        IO.Readable io = null;
        if (first != null) {
            try {
                io = first.open(name, Task.Priority.RATHER_IMPORTANT);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (io == null) {
            for (int i = 0; i < this.libs.size(); ++i) {
                AbstractClassLoader cl = this.libs.get(i);
                if (cl == first) continue;
                try {
                    io = cl.open(name, Task.Priority.RATHER_IMPORTANT);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (io != null) break;
            }
        }
        if (io != null) {
            return IOAsInputStream.get(io, true);
        }
        return AppClassLoader.class.getClassLoader().getResourceAsStream(name);
    }

    public URL getResourceFrom(String name, AbstractClassLoader first) {
        if (name.isEmpty()) {
            return null;
        }
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        URL url = null;
        if (first != null) {
            url = first.getResourceURL(name);
        }
        if (url == null) {
            AbstractClassLoader cl;
            for (int i = 0; i < this.libs.size() && ((cl = this.libs.get(i)) == first || (url = cl.getResourceURL(name)) == null); ++i) {
            }
        }
        if (url == null) {
            url = AppClassLoader.class.getClassLoader().getResource(name);
        }
        return url;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        if (name.isEmpty()) {
            return null;
        }
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        CompoundCollection<URL> list = new CompoundCollection<URL>();
        for (int i = 0; i < this.libs.size(); ++i) {
            AbstractClassLoader cl = this.libs.get(i);
            Iterable<URL> urls = cl.getResourcesURL(name);
            if (urls == null) continue;
            list.add(urls);
        }
        list.add(AppClassLoader.class.getClassLoader().getResources(name));
        return list.enumeration();
    }

    @Override
    public IOProvider.Readable getIOProvider(String name) {
        return this.getIOProviderFrom(name, null);
    }

    public IOProvider.Readable getIOProviderFrom(String name, AbstractClassLoader first) {
        if (name.isEmpty()) {
            return null;
        }
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        IOProvider.Readable provider = null;
        if (first != null) {
            provider = first.get(name);
        }
        if (provider == null) {
            AbstractClassLoader cl;
            for (int i = 0; i < this.libs.size() && ((cl = this.libs.get(i)) == first || (provider = cl.get(name)) == null); ++i) {
            }
        }
        if (provider != null) {
            return provider;
        }
        return this.coreIOProvider.get(name);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loadClassFrom(className, null);
    }

    @Override
    public URL getResource(String filename) {
        return this.getResourceFrom(filename, null);
    }

    public void scanLibraries(String rootPackage, boolean includeSubPackages, Predicate<String> packageFilter, Predicate<String> classFilter, Consumer<Class<?>> classScanner) {
        for (AbstractClassLoader cl : this.libs) {
            cl.scan(rootPackage, includeSubPackages, packageFilter, classFilter, classScanner);
        }
    }

    private static class InnerJARProvider
    implements IOProvider.Readable {
        private AbstractClassLoader parent;
        private String jar;

        public InnerJARProvider(AbstractClassLoader parent, String jar) {
            this.parent = parent;
            this.jar = jar;
        }

        @Override
        public String getDescription() {
            return this.parent.getDescription() + "/" + this.jar;
        }

        @Override
        public IO.Readable provideIOReadable(Task.Priority priority) throws IOException {
            return this.parent.loadResourceAsIO(this.jar, priority);
        }
    }
}

