/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.libraries.classpath;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.ApplicationClassLoader;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.io.provider.IOProviderFromPathUsingClassloader;

public class DefaultApplicationClassLoader
extends URLClassLoader
implements ApplicationClassLoader {
    private Application app;
    private IOProviderFromPathUsingClassloader ioProvider;

    public DefaultApplicationClassLoader(Application app, File[] additionalClassPath) {
        super(DefaultApplicationClassLoader.getURLs(additionalClassPath), DefaultApplicationClassLoader.class.getClassLoader());
        this.app = app;
        this.ioProvider = new IOProviderFromPathUsingClassloader(this);
    }

    @Override
    public Application getApplication() {
        return this.app;
    }

    @Override
    public IOProvider.Readable getIOProvider(String filename) {
        return this.ioProvider.get(filename);
    }

    private static URL[] getURLs(File[] files) {
        if (files == null) {
            return new URL[0];
        }
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            try {
                urls[i] = files[i].toURI().toURL();
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return urls;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

