/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.libraries.classpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.ApplicationClassLoader;
import net.lecousin.framework.application.libraries.LibrariesManager;
import net.lecousin.framework.application.libraries.LibraryManagementException;
import net.lecousin.framework.application.libraries.classpath.DefaultApplicationClassLoader;
import net.lecousin.framework.application.libraries.classpath.LoadLibraryExtensionPointsFile;
import net.lecousin.framework.application.libraries.classpath.LoadLibraryPluginsFile;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOFromInputStream;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.plugins.CustomExtensionPoint;
import net.lecousin.framework.plugins.ExtensionPoints;

public class DefaultLibrariesManager
implements LibrariesManager {
    private Application app;
    private DefaultApplicationClassLoader acl;
    private Async<LibraryManagementException> started = new Async();
    private File[] additionalClassPath;
    private ArrayList<File> classPath;

    public DefaultLibrariesManager(File[] additionalClassPath) {
        this.additionalClassPath = additionalClassPath;
    }

    public DefaultLibrariesManager() {
        this(null);
    }

    @Override
    public DefaultApplicationClassLoader start(Application app) {
        this.app = app;
        this.acl = new DefaultApplicationClassLoader(app, this.additionalClassPath);
        Task.cpu("Start DefaultLibrariesManager", Task.Priority.IMPORTANT, new Start()).start();
        return this.acl;
    }

    private static BufferedReadableCharacterStream loadNextFile(Enumeration<URL> urls, Async<Exception> sp) {
        InputStream input;
        if (!urls.hasMoreElements()) {
            sp.unblock();
            return null;
        }
        URL url = urls.nextElement();
        try {
            input = url.openStream();
        }
        catch (IOException e) {
            sp.error(e);
            return null;
        }
        IOFromInputStream io = new IOFromInputStream(input, url.toString(), Threading.getUnmanagedTaskManager(), Task.Priority.IMPORTANT);
        return new BufferedReadableCharacterStream((IO.Readable)io, StandardCharsets.UTF_8, 256, 32);
    }

    @Override
    public IAsync<LibraryManagementException> onLibrariesLoaded() {
        return this.started;
    }

    @Override
    public IO.Readable getResource(String path, Task.Priority priority) {
        InputStream in;
        URL url = this.acl.getResource(path);
        if (url == null) {
            this.app.getDefaultLogger().info("Resource not found: " + path);
            return null;
        }
        try {
            in = url.openStream();
        }
        catch (Exception e) {
            this.app.getDefaultLogger().error("Unable to open resource " + path, e);
            return null;
        }
        TaskManager tm = null;
        if ("file".equals(url.getProtocol())) {
            tm = Threading.getDrivesManager().getTaskManager(url.getFile());
        }
        if (tm == null) {
            tm = Threading.getUnmanagedTaskManager();
        }
        return new IOFromInputStream(in, path, tm, priority);
    }

    @Override
    public List<File> getLibrariesLocations() {
        return this.classPath;
    }

    @Override
    public void scanLibraries(String rootPackage, boolean includeSubPackages, Predicate<String> packageFilter, Predicate<String> classFilter, Consumer<Class<?>> classScanner) {
        List<File> files = this.getLibrariesLocations();
        for (File f : files) {
            if (f.isDirectory()) {
                DefaultLibrariesManager.scanDirectoryLibrary(this.app.getClassLoader(), f, rootPackage, includeSubPackages, packageFilter, classFilter, classScanner);
                continue;
            }
            DefaultLibrariesManager.scanJarLibrary(this.app.getClassLoader(), f, rootPackage, includeSubPackages, packageFilter, classFilter, classScanner);
        }
    }

    public static void scanDirectoryLibrary(ApplicationClassLoader classLoader, File dir, String rootPackage, boolean includeSubPackages, Predicate<String> packageFilter, Predicate<String> classFilter, Consumer<Class<?>> classScanner) {
        String pkgPath = rootPackage.replace('.', '/');
        File rootDir = new File(dir, pkgPath);
        if (!rootDir.exists()) {
            return;
        }
        DefaultLibrariesManager.scanClasses(classLoader, rootDir, rootPackage, includeSubPackages, packageFilter, classFilter, classScanner);
    }

    private static void scanClasses(ApplicationClassLoader classLoader, File dir, String pkgName, boolean includeSubPackages, Predicate<String> packageFilter, Predicate<String> classFilter, Consumer<Class<?>> classScanner) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        boolean filtered = packageFilter != null && !packageFilter.test(pkgName);
        for (File f : files) {
            if (f.isDirectory()) {
                if (!includeSubPackages) continue;
                DefaultLibrariesManager.scanClasses(classLoader, f, pkgName + '.' + f.getName(), true, packageFilter, classFilter, classScanner);
                continue;
            }
            if (filtered || !f.getName().endsWith(".class")) continue;
            String name = pkgName + '.' + f.getName().substring(0, f.getName().length() - 6);
            if (classFilter != null && !classFilter.test(name)) continue;
            try {
                Class<?> cl = classLoader.loadClass(name);
                classScanner.accept(cl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void scanJarLibrary(ApplicationClassLoader classLoader, File file, String rootPackage, boolean includeSubPackages, Predicate<String> packageFilter, Predicate<String> classFilter, Consumer<Class<?>> classScanner) {
        try (ZipFile jar = new ZipFile(file);){
            DefaultLibrariesManager.scanJarLibrary(classLoader, jar, rootPackage, includeSubPackages, packageFilter, classFilter, classScanner);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void scanJarLibrary(ApplicationClassLoader classLoader, ZipFile jar, String rootPackage, boolean includeSubPackages, Predicate<String> packageFilter, Predicate<String> classFilter, Consumer<Class<?>> classScanner) {
        String pkgPath = rootPackage.length() > 0 ? rootPackage.replace('.', '/') + '/' : "";
        Enumeration<? extends ZipEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            String pkg;
            String name;
            ZipEntry f = entries.nextElement();
            if (f.isDirectory() || !(name = f.getName()).startsWith(pkgPath) || !name.endsWith(".class")) continue;
            name = name.substring(0, name.length() - 6);
            int i = (name = name.replace('/', '.')).lastIndexOf(46);
            String string = pkg = i > 0 ? name.substring(0, i) : "";
            if (!includeSubPackages && !pkg.equals(rootPackage) || packageFilter != null && !packageFilter.test(pkg) || classFilter != null && !classFilter.test(name)) continue;
            try {
                Class<?> cl = classLoader.loadClass(name);
                classScanner.accept(cl);
            }
            catch (Exception exception) {}
        }
    }

    static /* synthetic */ File[] access$402(DefaultLibrariesManager x0, File[] x1) {
        x0.additionalClassPath = x1;
        return x1;
    }

    private class CustomExtensionPointLoader
    implements Executable<Void, Exception> {
        private CustomExtensionPoint ep;
        private String filePath;

        public CustomExtensionPointLoader(CustomExtensionPoint ep, String filePath) {
            this.ep = ep;
            this.filePath = filePath;
        }

        @Override
        public Void execute(Task<Void, Exception> taskContext) throws Exception {
            DefaultLibrariesManager.this.app.getDefaultLogger().info("Loading plugin files for custom extension point " + this.ep.getClass().getName() + ": " + this.filePath);
            Enumeration<URL> urls = DefaultLibrariesManager.this.acl.getResources(this.filePath);
            while (urls.hasMoreElements()) {
                if (taskContext.isCancelling()) {
                    throw taskContext.getCancelEvent();
                }
                URL url = urls.nextElement();
                DefaultLibrariesManager.this.app.getDefaultLogger().info(" - Plugin file found: " + url.toString());
                InputStream input = url.openStream();
                IOFromInputStream io = new IOFromInputStream(input, url.toString(), Threading.getUnmanagedTaskManager(), Task.Priority.IMPORTANT);
                this.ep.loadPluginConfiguration(io, DefaultLibrariesManager.this.acl, new IAsync[0]).blockThrow(0L);
            }
            return null;
        }
    }

    private class Start2
    implements Executable<Void, NoException> {
        private LinkedList<IAsync<Exception>> tasks;

        private Start2(LinkedList<IAsync<Exception>> tasks) {
            this.tasks = tasks;
        }

        @Override
        public Void execute(Task<Void, NoException> taskContext) {
            for (CustomExtensionPoint custom : ExtensionPoints.getCustomExtensionPoints()) {
                String path = custom.getPluginConfigurationFilePath();
                if (path == null) continue;
                Task<Void, Exception> loader = Task.cpu("Loading libraries' file " + path + " for extension point " + custom.getClass().getName(), Task.Priority.NORMAL, new CustomExtensionPointLoader(custom, path));
                this.tasks.getLast().thenStart(loader, false);
                this.tasks.add(loader.getOutput());
            }
            Async plugins = new Async();
            this.tasks.getLast().thenStart("Load plugins from libraries", Task.Priority.NORMAL, () -> this.loadPlugins(plugins), false);
            this.tasks.add(plugins);
            this.tasks.getLast().thenStart("Finalize libraries loading", Task.Priority.NORMAL, t -> {
                ExtensionPoints.allPluginsLoaded();
                DefaultLibrariesManager.this.started.unblock();
                return null;
            }, false);
            JoinPoint.from(this.tasks).onDone(() -> {}, error -> DefaultLibrariesManager.this.started.error(new LibraryManagementException("Error loading librairies", (Throwable)error)), cancel -> DefaultLibrariesManager.this.started.cancel((CancelException)cancel));
            return null;
        }

        private void loadPlugins(Async<Exception> sp) {
            Enumeration<URL> urls;
            try {
                urls = DefaultLibrariesManager.this.acl.getResources("META-INF/net.lecousin/plugins");
            }
            catch (IOException e) {
                sp.error(e);
                return;
            }
            this.loadPlugins(urls, sp);
        }

        private void loadPlugins(Enumeration<URL> urls, Async<Exception> sp) {
            BufferedReadableCharacterStream stream = DefaultLibrariesManager.loadNextFile(urls, sp);
            if (stream == null) {
                return;
            }
            LoadLibraryPluginsFile load = new LoadLibraryPluginsFile(stream, DefaultLibrariesManager.this.acl);
            load.start().onDone(() -> this.loadPlugins(urls, sp), sp);
            stream.closeAfter(sp);
        }
    }

    private class Start
    implements Executable<Void, NoException> {
        private Start() {
        }

        @Override
        public Void execute(Task<Void, NoException> taskContext) {
            String cp = System.getProperty("java.class.path");
            DefaultLibrariesManager.this.app.getDefaultLogger().info("Starting DefaultLibrariesManager with classpath = " + cp);
            URL[] addcp = DefaultLibrariesManager.this.acl.getURLs();
            for (int i = 0; i < addcp.length; ++i) {
                DefaultLibrariesManager.this.app.getDefaultLogger().info(" - additional library: " + addcp[i].toString());
            }
            String[] paths = cp.split(System.getProperty("path.separator"));
            DefaultLibrariesManager.this.classPath = new ArrayList(paths.length);
            for (String path : paths) {
                File f;
                if ((path = path.trim()).isEmpty() || !(f = new File(path)).exists()) continue;
                DefaultLibrariesManager.this.classPath.add(f);
            }
            if (DefaultLibrariesManager.this.additionalClassPath != null) {
                Collections.addAll(DefaultLibrariesManager.this.classPath, DefaultLibrariesManager.this.additionalClassPath);
            }
            DefaultLibrariesManager.this.classPath.trimToSize();
            DefaultLibrariesManager.access$402(DefaultLibrariesManager.this, null);
            Async<Exception> sp = this.loadExtensionPoints();
            LinkedList<Async<Exception>> tasks = new LinkedList<Async<Exception>>();
            tasks.add(sp);
            sp.thenStart(Task.cpu("Start DefaultLibrariesManager - step 2", Task.Priority.IMPORTANT, new Start2(tasks)), true);
            return null;
        }

        private Async<Exception> loadExtensionPoints() {
            Enumeration<URL> urls;
            Async<Exception> sp = new Async<Exception>();
            try {
                urls = DefaultLibrariesManager.this.acl.getResources("META-INF/net.lecousin/extensionpoints");
            }
            catch (IOException e) {
                sp.error(e);
                return sp;
            }
            this.loadExtensionPoints(urls, sp);
            return sp;
        }

        private void loadExtensionPoints(Enumeration<URL> urls, Async<Exception> sp) {
            BufferedReadableCharacterStream stream = DefaultLibrariesManager.loadNextFile(urls, sp);
            if (stream == null) {
                return;
            }
            LoadLibraryExtensionPointsFile load = new LoadLibraryExtensionPointsFile(stream, DefaultLibrariesManager.this.acl);
            load.start().onDone(() -> this.loadExtensionPoints(urls, sp), sp);
            stream.closeAfter(sp);
        }
    }
}

