/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<T>
implements Iterator<T> {
    private T[] array;
    private int max;
    private int cursor = 0;

    public ArrayIterator(T[] array, int max) {
        this.array = array;
        this.max = max;
    }

    public ArrayIterator(T[] array) {
        this.array = array;
        this.max = array.length;
    }

    @Override
    public boolean hasNext() {
        return this.max > this.cursor;
    }

    @Override
    public T next() {
        if (this.cursor >= this.max) {
            throw new NoSuchElementException();
        }
        return this.array[this.cursor++];
    }

    public static class Generic
    implements Iterator {
        private Object array;
        private int pos = 0;

        public Generic(Object array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.pos < Array.getLength(this.array);
        }

        public Object next() {
            if (this.array == null || this.pos >= Array.getLength(this.array)) {
                throw new NoSuchElementException();
            }
            return Array.get(this.array, this.pos++);
        }
    }
}

