/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.collections.ArrayIterator;
import net.lecousin.framework.util.ObjectUtil;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static <T> boolean contains(T[] array, T value) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(char[] array, char value) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(byte[] array, byte value) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(short[] array, short value) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] array, int value) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(long[] array, long value) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public static <T> int indexOf(T element, T[] array) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (!array[i].equals(element)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte element, byte[] array) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short element, short[] array) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int element, int[] array) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long element, long[] array) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char element, char[] array) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOfInstance(T element, T[] array) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static <T> boolean equals(T[] a1, T[] a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (ObjectUtil.equalsOrNull(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(T[] a1, int off1, T[] a2, int off2, int len) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (ObjectUtil.equalsOrNull(a1[off1 + i], a2[off2 + i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] a1, byte[] a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] a1, int off1, byte[] a2, int off2, int len) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a1[i + off1] == a2[i + off2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] a1, short[] a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] a1, int off1, short[] a2, int off2, int len) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a1[i + off1] == a2[i + off2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] a1, int[] a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] a1, int off1, int[] a2, int off2, int len) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a1[i + off1] == a2[i + off2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(long[] a1, long[] a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(long[] a1, int off1, long[] a2, int off2, int len) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a1[i + off1] == a2[i + off2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] a1, char[] a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] a1, int off1, char[] a2, int off2, int len) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a1[i + off1] == a2[i + off2]) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] createGenericArray(Class<T[]> clazz, int size) {
        return (Object[])Array.newInstance(clazz.getComponentType(), size);
    }

    public static <T> T[] createGenericArray(Class<T[]> clazz, Object[] content) {
        T[] array = ArrayUtil.createGenericArray(clazz, content.length);
        for (int i = 0; i < content.length; ++i) {
            array[i] = content[i];
        }
        return array;
    }

    public static <T> T[] createGenericArrayOf(int size, Class<T> type) {
        return (Object[])Array.newInstance(type, size);
    }

    public static <T> List<T> intersectionIdentity(T[] a1, T[] a2) {
        LinkedList<T> result = new LinkedList<T>();
        block0: for (T e1 : a1) {
            for (T e2 : a2) {
                if (e1 != e2) continue;
                result.add(e1);
                continue block0;
            }
        }
        return result;
    }

    public static <T> T[] concatenate(T[] a, T[] b) {
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        T[] array = ArrayUtil.createGenericArray(a.getClass(), a.length + b.length);
        System.arraycopy(a, 0, array, 0, a.length);
        System.arraycopy(b, 0, array, a.length, b.length);
        return array;
    }

    public static byte[] merge(List<byte[]> arrays) {
        if (arrays.isEmpty()) {
            return new byte[0];
        }
        if (arrays.size() == 1) {
            return arrays.get(0);
        }
        int size = 0;
        for (byte[] b : arrays) {
            size += b.length;
        }
        byte[] a = new byte[size];
        size = 0;
        for (byte[] b : arrays) {
            System.arraycopy(b, 0, a, size, b.length);
            size += b.length;
        }
        return a;
    }

    public static int compare(byte[] b1, byte[] b2) {
        if (b1.length < b2.length) {
            int c = ArrayUtil.compare(b1, 0, b2, 0, b1.length);
            if (c != 0) {
                return c;
            }
            return -1;
        }
        if (b1.length == b2.length) {
            return ArrayUtil.compare(b1, 0, b2, 0, b1.length);
        }
        int c = ArrayUtil.compare(b1, 0, b2, 0, b2.length);
        if (c != 0) {
            return c;
        }
        return 1;
    }

    public static int compare(byte[] b1, int off1, byte[] b2, int off2, int len) {
        for (int i = 0; i < len; ++i) {
            if (b1[i + off1] < b2[i + off2]) {
                return -1;
            }
            if (b1[i + off1] <= b2[i + off2]) continue;
            return 1;
        }
        return 0;
    }

    public static <T> T[] add(T[] a, T elem) {
        T[] na = Arrays.copyOf(a, a.length + 1);
        na[a.length] = elem;
        return na;
    }

    public static <T> T[] add(T[] a, T elem, int pos) {
        T[] na = ArrayUtil.createGenericArray(a.getClass(), a.length + 1);
        if (pos > 0) {
            System.arraycopy(a, 0, na, 0, pos);
        }
        na[pos] = elem;
        if (pos < a.length) {
            System.arraycopy(a, pos, na, pos + 1, a.length - pos);
        }
        return na;
    }

    public static <T> T[] add(T[] a, Collection<T> toAdd) {
        T[] na = Arrays.copyOf(a, a.length + toAdd.size());
        int i = a.length;
        for (T elem : toAdd) {
            na[i++] = elem;
        }
        return na;
    }

    public static <T> T[] remove(T[] a, T elem) {
        if (a.length == 0) {
            return a;
        }
        T[] na = ArrayUtil.createGenericArray(a.getClass(), a.length - 1);
        int found = 0;
        for (int i = 0; i < a.length; ++i) {
            T e = a[i];
            if (found == 0 && ObjectUtil.equalsOrNull(e, elem)) {
                found = 1;
                continue;
            }
            if (found <= 0 && i >= a.length - 1) continue;
            na[i - found] = e;
        }
        if (found == 0) {
            return a;
        }
        return na;
    }

    public static <T> T[] removeAt(T[] a, int i) {
        T[] na = ArrayUtil.createGenericArray(a.getClass(), a.length - 1);
        if (i > 0) {
            System.arraycopy(a, 0, na, 0, i);
        }
        if (i < na.length) {
            System.arraycopy(a, i + 1, na, i, na.length - i);
        }
        return na;
    }

    public static <T> Iterator<T> iterator(T[] a) {
        return new ArrayIterator<T>(a, a.length);
    }

    public static byte[] copy(byte[] a) {
        byte[] c = new byte[a.length];
        System.arraycopy(a, 0, c, 0, a.length);
        return c;
    }

    public static int[] toArray(Collection<Integer> col) {
        int[] a = new int[col.size()];
        int i = 0;
        for (Integer val : col) {
            a[i++] = val;
        }
        return a;
    }

    public static <T> ArrayList<T> newArrayList(T[] items) {
        ArrayList list = new ArrayList(items.length);
        Collections.addAll(list, items);
        return list;
    }

    public static int search(byte[] toFind, byte[] array) {
        return ArrayUtil.search(toFind, array, 0);
    }

    public static int search(byte[] toFind, byte[] array, int start) {
        return ArrayUtil.search(toFind, array, start, array.length - start);
    }

    public static int search(byte[] toFind, byte[] array, int start, int len) {
        int tfl = toFind.length;
        if (len < tfl) {
            return -1;
        }
        for (int i = 0; i <= len - tfl; ++i) {
            if (array[start + i] != toFind[0]) continue;
            boolean ok = true;
            for (int j = 1; j < tfl; ++j) {
                if (array[start + i + j] == toFind[j]) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return i;
        }
        return -1;
    }
}

