/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.lecousin.framework.util.ObjectUtil;

public final class CollectionsUtil {
    private CollectionsUtil() {
    }

    public static <T> Enumeration<T> enumeration(Iterator<T> iterator) {
        return new IteratorToEnumeration<T>(iterator);
    }

    public static <T> Iterable<T> iterable(Enumeration<T> enumeration) {
        LinkedList<T> list = new LinkedList<T>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    public static <T> Iterator<T> iterator(final Enumeration<T> enumeration) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }
        };
    }

    public static <T> Iterable<T> singleTimeIterable(Enumeration<T> enumeration) {
        return () -> CollectionsUtil.iterator(enumeration);
    }

    public static boolean equals(List<?> list1, List<?> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        Iterator<?> it1 = list1.iterator();
        Iterator<?> it2 = list2.iterator();
        while (it1.hasNext()) {
            if (ObjectUtil.equalsOrNull(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> void addAll(Collection<T> col, Enumeration<T> e) {
        while (e.hasMoreElements()) {
            col.add(e.nextElement());
        }
    }

    public static <T> void addAll(Collection<T> col, Iterator<T> it) {
        while (it.hasNext()) {
            col.add(it.next());
        }
    }

    public static boolean containsInstance(Collection<?> col, Object instance) {
        for (Object o : col) {
            if (o != instance) continue;
            return true;
        }
        return false;
    }

    public static <Input, Output> List<Output> map(List<Input> inputs, Function<Input, Output> mapper) {
        ArrayList<Output> outputs = new ArrayList<Output>(inputs.size());
        for (Input input : inputs) {
            outputs.add(mapper.apply(input));
        }
        return outputs;
    }

    public static <T> T findElement(Collection<T> collection, Predicate<T> predicate) {
        for (T element : collection) {
            if (!predicate.test(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> Function<Collection<T>, T> filterSingle(Predicate<T> predicate) {
        return collection -> {
            for (Object element : collection) {
                if (!predicate.test(element)) continue;
                return element;
            }
            return null;
        };
    }

    public static class IteratorToEnumeration<T>
    implements Enumeration<T> {
        private Iterator<T> it;

        public IteratorToEnumeration(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        @Override
        public T nextElement() {
            return this.it.next();
        }
    }
}

