/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.collections.CollectionsUtil;

public class CompoundCollection<T>
implements Iterable<T> {
    private List<Iterable<T>> list = new LinkedList<Iterable<T>>();

    public void add(Iterable<T> collection) {
        this.list.add(collection);
    }

    public void add(Enumeration<T> e) {
        this.list.add(CollectionsUtil.iterable(e));
    }

    public void addSingleton(T element) {
        this.list.add(Collections.singletonList(element));
    }

    public Enumeration<T> enumeration() {
        return CollectionsUtil.enumeration(new It());
    }

    @Override
    public Iterator<T> iterator() {
        return new It();
    }

    private class It
    implements Iterator<T> {
        private Iterator<Iterable<T>> itCol;
        private Iterator<T> itInner;

        private It() {
            this.itCol = CompoundCollection.this.list.iterator();
            while (this.itCol.hasNext()) {
                this.itInner = this.itCol.next().iterator();
                if (!this.itInner.hasNext()) continue;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.itInner != null && this.itInner.hasNext();
        }

        @Override
        public T next() {
            Object e = this.itInner.next();
            if (!this.itInner.hasNext()) {
                while (this.itCol.hasNext()) {
                    this.itInner = this.itCol.next().iterator();
                    if (!this.itInner.hasNext()) continue;
                    break;
                }
            }
            return e;
        }
    }
}

