/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections.map;

import java.util.Iterator;
import net.lecousin.framework.collections.LinkedArrayList;
import net.lecousin.framework.collections.LinkedIterators;
import net.lecousin.framework.collections.map.IntegerMap;

public class IntegerMapLinkedArrayList<T>
implements IntegerMap<T> {
    private LinkedArrayList<Entry<T>>[] buckets;
    private int size = 0;

    public IntegerMapLinkedArrayList(int nbBuckets, int arraySizeByBucket) {
        this.buckets = new LinkedArrayList[nbBuckets];
        for (int i = 0; i < nbBuckets; ++i) {
            this.buckets[i] = new LinkedArrayList(arraySizeByBucket);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        for (LinkedArrayList<Entry<T>> bucket : this.buckets) {
            bucket.clear();
        }
        this.size = 0;
    }

    @Override
    public T put(int key, T entry) {
        int b = key % this.buckets.length;
        if (b < 0) {
            b = -b;
        }
        for (Entry<T> e : this.buckets[b]) {
            if (((Entry)e).key != key) continue;
            Object previous = ((Entry)e).value;
            ((Entry)e).value = entry;
            return (T)previous;
        }
        this.buckets[b].add(new Entry(key, entry));
        ++this.size;
        return null;
    }

    @Override
    public T get(int key) {
        int b = key % this.buckets.length;
        if (b < 0) {
            b = -b;
        }
        for (Entry<T> e : this.buckets[b]) {
            if (((Entry)e).key != key) continue;
            return (T)((Entry)e).value;
        }
        return null;
    }

    @Override
    public T remove(int key) {
        int b = key % this.buckets.length;
        if (b < 0) {
            b = -b;
        }
        Iterator<Entry<T>> it = this.buckets[b].iterator();
        while (it.hasNext()) {
            Entry<T> e = it.next();
            if (((Entry)e).key != key) continue;
            it.remove();
            --this.size;
            return (T)((Entry)e).value;
        }
        return null;
    }

    @Override
    public boolean containsKey(int key) {
        int b = key % this.buckets.length;
        if (b < 0) {
            b = -b;
        }
        for (Entry<T> e : this.buckets[b]) {
            if (((Entry)e).key != key) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> values() {
        final LinkedIterators<Entry<T>> it = new LinkedIterators<Entry<T>>();
        for (LinkedArrayList<Entry<T>> bucket : this.buckets) {
            it.addIterator(bucket.iterator());
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                return ((Entry)it.next()).value;
            }

            @Override
            public void remove() {
                it.remove();
                IntegerMapLinkedArrayList.this.size--;
            }
        };
    }

    private static class Entry<T> {
        private int key;
        private T value;

        private Entry(int key, T value) {
            this.key = key;
            this.value = value;
        }
    }
}

