/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import java.io.Closeable;
import java.io.PrintStream;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.async.Async;

public class Console
implements Closeable {
    private TurnArray<Object> toPrint = new TurnArray(100);
    private TurnArray<PrintStream> stream = new TurnArray(100);
    private Thread thread;
    private boolean stop = false;
    private Async<Exception> stopped = new Async();
    private PrintStream out = System.out;
    private PrintStream err = System.err;

    public synchronized void out(String line) {
        this.add(line, this.out);
    }

    public synchronized void out(Throwable t) {
        this.add(t, this.out);
    }

    public synchronized void err(String line) {
        this.add(line, this.err);
    }

    public synchronized void err(Throwable t) {
        this.add(t, this.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Object o, PrintStream s) {
        Console console = this;
        synchronized (console) {
            this.toPrint.addLast(o);
            this.stream.addLast(s);
            this.notify();
        }
        int nb = this.toPrint.size();
        if (nb > 5000) {
            try {
                Thread.sleep(nb > 10000 ? 400L : (nb > 7500 ? 200L : 100L));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public Console(Application app) {
        this.thread = app.getThreadFactory().newThread(() -> {
            while (!this.stop) {
                PrintStream s;
                Object obj;
                Console console = this;
                synchronized (console) {
                    obj = this.toPrint.pollFirst();
                    if (obj == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    s = this.stream.pollFirst();
                }
                Console.printTo(obj, s);
            }
            while (!this.toPrint.isEmpty()) {
                Console.printTo(this.toPrint.removeFirst(), this.stream.removeFirst());
            }
            System.out.println("Console stopped for " + app.getFullName());
            this.stopped.unblock();
        });
        this.thread.setName("Console for " + app.getFullName());
        this.thread.start();
    }

    private static void printTo(Object toPrint, PrintStream stream) {
        if (toPrint instanceof CharSequence) {
            stream.println(toPrint);
        } else if (toPrint instanceof Throwable) {
            ((Throwable)toPrint).printStackTrace(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.stop = true;
        Console console = this;
        synchronized (console) {
            this.notify();
        }
        this.stopped.block(0L);
    }
}

