/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.TaskExecutor;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.util.ThreadUtil;

public class Async<TError extends Exception>
implements IAsync<TError>,
Future<Void> {
    private boolean unblocked = false;
    private TError error = null;
    private CancelException cancelled = null;
    private ArrayList<Runnable> listenersInline = null;

    public Async() {
    }

    public Async(boolean unblocked) {
        this.unblocked = unblocked;
    }

    public Async(TError error) {
        this.unblocked = true;
        this.error = error;
    }

    public Async(CancelException cancel) {
        this.unblocked = true;
        this.cancelled = cancel;
    }

    public <TError2 extends Exception> Async(IAsync<TError2> toConvert, Function<TError2, TError> errorConverter) {
        toConvert.onDone(this, errorConverter);
    }

    @Override
    public Collection<?> getAllListeners() {
        if (this.listenersInline == null) {
            return new ArrayList(0);
        }
        return new ArrayList<Runnable>(this.listenersInline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onDone(Runnable r) {
        Async async = this;
        synchronized (async) {
            if (!this.unblocked || this.listenersInline != null) {
                if (this.listenersInline == null) {
                    this.listenersInline = new ArrayList(5);
                }
                this.listenersInline.add(r);
                return;
            }
        }
        r.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unblock() {
        ArrayList<Runnable> listeners;
        Async async = this;
        synchronized (async) {
            if (this.unblocked) {
                return;
            }
            this.unblocked = true;
            if (this.listenersInline == null) {
                this.notifyAll();
                return;
            }
            listeners = this.listenersInline;
            this.listenersInline = new ArrayList(2);
        }
        Logger log = Threading.getLogger();
        do {
            int i;
            if (!log.debug()) {
                for (i = 0; i < listeners.size(); ++i) {
                    try {
                        listeners.get(i).run();
                        continue;
                    }
                    catch (Exception t) {
                        this.logListenerError(log, listeners.get(i), t);
                    }
                }
            } else {
                for (i = 0; i < listeners.size(); ++i) {
                    Runnable listener = listeners.get(i);
                    long start = System.nanoTime();
                    try {
                        listener.run();
                    }
                    catch (Exception t) {
                        this.logListenerError(log, listener, t);
                    }
                    Threading.debugListenerCall(listener, System.nanoTime() - start);
                }
            }
            Async async2 = this;
            synchronized (async2) {
                if (this.listenersInline.isEmpty()) {
                    this.listenersInline = null;
                    listeners = null;
                    this.notifyAll();
                } else {
                    listeners.clear();
                    ArrayList<Runnable> tmp = listeners;
                    listeners = this.listenersInline;
                    this.listenersInline = tmp;
                }
            }
        } while (listeners != null);
    }

    @Override
    public final void error(TError error) {
        this.error = error;
        this.unblock();
    }

    @Override
    public final void cancel(CancelException reason) {
        this.cancelled = reason;
        this.unblock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void block(long timeout) {
        TaskExecutor executor;
        Async async = this;
        synchronized (async) {
            if (this.unblocked && this.listenersInline == null) {
                return;
            }
            executor = Threading.getTaskExecutor();
            if (executor == null) {
                if (timeout <= 0L) {
                    while (!this.unblocked || this.listenersInline != null) {
                        if (ThreadUtil.wait(this, 0L)) continue;
                        return;
                    }
                } else if (!ThreadUtil.wait(this, timeout)) {
                    return;
                }
            }
        }
        if (executor != null) {
            executor.blocked(this, timeout);
        }
    }

    @Override
    public boolean blockPauseCondition() {
        return !this.unblocked || this.listenersInline != null;
    }

    @Override
    public final synchronized boolean isDone() {
        return this.unblocked;
    }

    @Override
    public final boolean isCancelled() {
        return this.cancelled != null;
    }

    @Override
    public final boolean hasError() {
        return this.error != null;
    }

    @Override
    public final CancelException getCancelEvent() {
        return this.cancelled;
    }

    @Override
    public final TError getError() {
        return this.error;
    }

    public final synchronized void reset() {
        this.unblocked = false;
        this.cancelled = null;
        this.error = null;
        this.listenersInline = null;
    }

    public final synchronized void restart() {
        this.unblocked = false;
        this.cancelled = null;
        this.error = null;
    }

    @Override
    public final Void get() throws InterruptedException, ExecutionException {
        this.block(0L);
        if (!this.isDone()) {
            throw new InterruptedException();
        }
        if (this.hasError()) {
            throw new ExecutionException((Throwable)this.error);
        }
        if (this.isCancelled()) {
            throw new ExecutionException(this.cancelled);
        }
        return null;
    }

    @Override
    public final Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.block(unit.toMillis(timeout));
        if (!this.isDone()) {
            throw new TimeoutException();
        }
        if (this.hasError()) {
            throw new ExecutionException((Throwable)this.error);
        }
        if (this.isCancelled()) {
            throw new ExecutionException(this.cancelled);
        }
        return null;
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        this.cancel(new CancelException("Cancelled"));
        return true;
    }
}

