/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskExecutor;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.util.Runnables;
import net.lecousin.framework.util.ThreadUtil;

public class AsyncSupplier<T, TError extends Exception>
implements IAsync<TError>,
Future<T> {
    private boolean unblocked = false;
    private T result = null;
    private TError error = null;
    private CancelException cancel = null;
    private ArrayList<Listener<T, TError>> listenersInline = null;

    public AsyncSupplier() {
    }

    public AsyncSupplier(T result, TError error) {
        this.unblocked = true;
        this.result = result;
        this.error = error;
    }

    public AsyncSupplier(T result, TError error, CancelException cancel) {
        this(result, error);
        this.cancel = cancel;
    }

    public final T getResult() {
        return this.result;
    }

    @Override
    public final TError getError() {
        return this.error;
    }

    @Override
    public final CancelException getCancelEvent() {
        return this.cancel;
    }

    @Override
    public final boolean isCancelled() {
        return this.cancel != null;
    }

    @Override
    public final boolean hasError() {
        return this.error != null;
    }

    @Override
    public Collection<?> getAllListeners() {
        if (this.listenersInline == null) {
            return new ArrayList(0);
        }
        return new ArrayList<Listener<T, TError>>(this.listenersInline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void listen(Listener<T, TError> listener) {
        AsyncSupplier asyncSupplier = this;
        synchronized (asyncSupplier) {
            if (!this.unblocked || this.listenersInline != null) {
                if (this.listenersInline == null) {
                    this.listenersInline = new ArrayList(5);
                }
                this.listenersInline.add(listener);
                return;
            }
        }
        if (this.error != null) {
            listener.error(this.error);
        } else if (this.cancel != null) {
            listener.cancelled(this.cancel);
        } else {
            listener.ready(this.result);
        }
    }

    public final void forward(AsyncSupplier<T, TError> sp) {
        this.listen(Listener.from(sp::unblockSuccess, sp::error, sp::cancel, sp.toString()));
    }

    public final <TError2 extends Exception> void forward(AsyncSupplier<T, TError2> sp, Function<TError, TError2> errorConverter) {
        this.listen(Listener.from(sp::unblockSuccess, e -> sp.unblockError((Exception)errorConverter.apply(e)), sp::cancel, sp.toString()));
    }

    @Override
    public final void onDone(final Runnable r) {
        this.listen(new Listener<T, TError>(){

            @Override
            public void ready(T result) {
                r.run();
            }

            @Override
            public void error(TError error) {
                r.run();
            }

            @Override
            public void cancelled(CancelException event) {
                r.run();
            }

            public String toString() {
                return r.toString();
            }
        });
    }

    @Override
    public final void onDone(Async<TError> sp) {
        this.listen(Listener.from(r -> sp.unblock(), sp::error, sp::cancel, sp.toString()));
    }

    public final void onDone(Consumer<T> onready, Consumer<TError> onerror, Consumer<CancelException> oncancel) {
        this.listen(Listener.from(onready, onerror, oncancel, null));
    }

    @Override
    public final void onDone(Consumer<T> onready) {
        this.listen(Listener.from(onready, null, null, null));
    }

    public final void onDone(Consumer<T> onready, IAsync<TError> onErrorAndCancel) {
        this.listen(Listener.from(onready, onErrorAndCancel::error, onErrorAndCancel::cancel, null));
    }

    @Override
    public final void onDone(Runnable onready, IAsync<TError> onErrorAndCancel) {
        this.listen(Listener.from(onready, onErrorAndCancel::error, onErrorAndCancel::cancel, null));
    }

    public final <TError2 extends Exception> void onDone(Consumer<T> onready, IAsync<TError2> onErrorAndCancel, Function<TError, TError2> errorConverter) {
        this.listen(Listener.from(onready, err -> onErrorAndCancel.error((Exception)errorConverter.apply(err)), onErrorAndCancel::cancel, null));
    }

    public final <TError2 extends Exception> AsyncSupplier<T, TError2> convertError(Function<TError, TError2> converter) {
        AsyncSupplier<T, TError> a = new AsyncSupplier<T, TError>();
        this.forward(a, converter);
        return a;
    }

    public <T2> AsyncSupplier<T2, TError> thenStart(String taskDescription, Task.Priority priority, Runnables.FunctionThrows<T, T2, TError> fct, boolean evenIfErrorOrCancel) {
        Executable.FromFunctionThrows executable = new Executable.FromFunctionThrows(fct);
        Task task = Task.cpu(taskDescription, priority, executable);
        if (evenIfErrorOrCancel) {
            this.onDone(() -> {
                executable.setInput(this.getResult());
                task.start();
            });
        } else {
            this.onDone((T res) -> {
                executable.setInput(res);
                task.start();
            }, (TError err) -> task.setDone(null, err), task::cancel);
        }
        return task.getOutput();
    }

    public <T2> AsyncSupplier<T2, TError> thenStart(String taskDescription, Task.Priority priority, Runnables.FunctionThrows<T, T2, TError> fct, IAsync<TError> onErrorOrCancel) {
        Executable.FromFunctionThrows executable = new Executable.FromFunctionThrows(fct);
        Task task = Task.cpu(taskDescription, priority, executable);
        this.onDone(() -> {
            executable.setInput(this.getResult());
            task.start();
        }, onErrorOrCancel);
        return task.getOutput();
    }

    public IAsync<TError> thenStart(String taskDescription, Task.Priority priority, Runnables.ConsumerThrows<T, TError> consumer, boolean evenIfErrorOrCancel) {
        Executable.FromConsumerThrows executable = new Executable.FromConsumerThrows(consumer);
        Task task = Task.cpu(taskDescription, priority, executable);
        if (evenIfErrorOrCancel) {
            this.onDone(() -> {
                executable.setInput(this.getResult());
                task.start();
            });
        } else {
            this.onDone((T res) -> {
                executable.setInput(res);
                task.start();
            }, (TError err) -> task.setDone(null, err), task::cancel);
        }
        return task.getOutput();
    }

    public IAsync<TError> thenStart(String taskDescription, Task.Priority priority, Runnables.ConsumerThrows<T, TError> consumer, IAsync<TError> onErrorOrCancel) {
        Executable.FromConsumerThrows<T, TError> executable = new Executable.FromConsumerThrows<T, TError>(consumer);
        Task<T, TError> task = Task.cpu(taskDescription, priority, executable);
        this.onDone(() -> {
            executable.setInput(this.getResult());
            task.start();
        }, onErrorOrCancel);
        return task.getOutput();
    }

    public boolean thenDoOrStart(String taskDescription, Task.Priority taskPriority, Consumer<T> consumer, IAsync<TError> onErrorOrCancel) {
        if (this.isDone()) {
            if (!this.forwardIfNotSuccessful(onErrorOrCancel)) {
                consumer.accept(this.getResult());
            }
            return true;
        }
        Executable.FromConsumer<T> executable = new Executable.FromConsumer<T>(consumer);
        this.onDone(() -> {
            executable.setInput(this.getResult());
            Task.cpu(taskDescription, taskPriority, executable).start();
        }, onErrorOrCancel);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unblockSuccess(T result) {
        ArrayList<Listener<T, TError>> listeners;
        AsyncSupplier asyncSupplier = this;
        synchronized (asyncSupplier) {
            if (this.unblocked) {
                return;
            }
            this.unblocked = true;
            this.result = result;
            if (this.listenersInline == null) {
                this.notifyAll();
                return;
            }
            listeners = this.listenersInline;
            this.listenersInline = new ArrayList(2);
        }
        Logger log = Threading.getLogger();
        do {
            int i;
            if (!log.debug()) {
                for (i = 0; i < listeners.size(); ++i) {
                    try {
                        listeners.get(i).ready(result);
                        continue;
                    }
                    catch (Exception t) {
                        this.logListenerError(log, listeners.get(i), t);
                    }
                }
                continue;
            }
            for (i = 0; i < listeners.size(); ++i) {
                Listener<T, TError> listener = listeners.get(i);
                long start = System.nanoTime();
                try {
                    listener.ready(result);
                }
                catch (Exception t) {
                    this.logListenerError(log, listener, t);
                }
                Threading.debugListenerCall(listener, System.nanoTime() - start);
            }
        } while ((listeners = this.getNextListeners(listeners)) != null);
    }

    private synchronized ArrayList<Listener<T, TError>> getNextListeners(ArrayList<Listener<T, TError>> previousListeners) {
        if (this.listenersInline.isEmpty()) {
            this.listenersInline = null;
            this.notifyAll();
            return null;
        }
        ArrayList<Listener<T, TError>> nextListeners = this.listenersInline;
        previousListeners.clear();
        this.listenersInline = previousListeners;
        return nextListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unblockError(TError error) {
        ArrayList<Listener<T, TError>> listeners;
        AsyncSupplier asyncSupplier = this;
        synchronized (asyncSupplier) {
            if (this.unblocked) {
                return;
            }
            this.unblocked = true;
            this.error = error;
            if (this.listenersInline == null) {
                this.notifyAll();
                return;
            }
            listeners = this.listenersInline;
            this.listenersInline = new ArrayList(2);
        }
        Logger log = Threading.getLogger();
        do {
            int i;
            if (!log.debug()) {
                for (i = 0; i < listeners.size(); ++i) {
                    try {
                        listeners.get(i).error(error);
                        continue;
                    }
                    catch (Exception t) {
                        this.logListenerError(log, listeners.get(i), t);
                        try {
                            listeners.get(i).cancelled(new CancelException("Error in listener", t));
                            continue;
                        }
                        catch (Exception t2) {
                            log.error("Exception thrown while cancelling inline listener of AsyncSupplier after error: " + listeners.get(i), t2);
                        }
                    }
                }
                continue;
            }
            for (i = 0; i < listeners.size(); ++i) {
                Listener<T, TError> listener = listeners.get(i);
                long start = System.nanoTime();
                try {
                    listener.error(error);
                }
                catch (Exception t) {
                    this.logListenerError(log, listener, t);
                    try {
                        listener.cancelled(new CancelException("Error in listener", t));
                    }
                    catch (Exception t2) {
                        log.error("Exception thrown while cancelling inline listener of AsyncSupplier after error: " + listener, t2);
                    }
                }
                Threading.debugListenerCall(listener, System.nanoTime() - start);
            }
        } while ((listeners = this.getNextListeners(listeners)) != null);
    }

    @Override
    public final void error(TError error) {
        this.unblockError(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblockCancel(CancelException event) {
        ArrayList<Listener<T, TError>> listeners;
        AsyncSupplier asyncSupplier = this;
        synchronized (asyncSupplier) {
            if (this.unblocked) {
                return;
            }
            this.unblocked = true;
            this.cancel = event;
            if (this.listenersInline == null) {
                this.notifyAll();
                return;
            }
            listeners = this.listenersInline;
            this.listenersInline = new ArrayList(2);
        }
        Logger log = Threading.getLogger();
        do {
            int i;
            if (!log.debug()) {
                for (i = 0; i < listeners.size(); ++i) {
                    try {
                        listeners.get(i).cancelled(event);
                        continue;
                    }
                    catch (Exception t) {
                        this.logListenerError(log, listeners.get(i), t);
                    }
                }
                continue;
            }
            for (i = 0; i < listeners.size(); ++i) {
                Listener<T, TError> listener = listeners.get(i);
                long start = System.nanoTime();
                try {
                    listener.cancelled(event);
                }
                catch (Exception t) {
                    this.logListenerError(log, listener, t);
                }
                Threading.debugListenerCall(listener, System.nanoTime() - start);
            }
        } while ((listeners = this.getNextListeners(listeners)) != null);
    }

    @Override
    public final void cancel(CancelException reason) {
        this.unblockCancel(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void block(long timeout) {
        TaskExecutor executor;
        AsyncSupplier asyncSupplier = this;
        synchronized (asyncSupplier) {
            if (this.unblocked && this.listenersInline == null) {
                return;
            }
            executor = Threading.getTaskExecutor();
            if (executor == null) {
                if (timeout <= 0L) {
                    while (!this.unblocked || this.listenersInline != null) {
                        if (ThreadUtil.wait(this, 0L)) continue;
                        return;
                    }
                } else if (!ThreadUtil.wait(this, timeout)) {
                    return;
                }
            }
        }
        if (executor != null) {
            executor.blocked(this, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T blockResult(long timeout) throws TError, CancelException {
        TaskExecutor executor;
        AsyncSupplier asyncSupplier = this;
        synchronized (asyncSupplier) {
            if (this.unblocked && this.listenersInline == null) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.cancel != null) {
                    throw this.cancel;
                }
                return this.result;
            }
            executor = Threading.getTaskExecutor();
            if (executor == null) {
                while (!this.unblocked || this.listenersInline != null) {
                    if (ThreadUtil.wait(this, timeout < 0L ? 0L : timeout)) continue;
                    return null;
                }
            }
        }
        if (executor != null) {
            executor.blocked(this, timeout);
        }
        if (this.error != null) {
            throw this.error;
        }
        if (this.cancel != null) {
            throw this.cancel;
        }
        return this.result;
    }

    @Override
    public boolean blockPauseCondition() {
        return !this.unblocked || this.listenersInline != null;
    }

    @Override
    public final synchronized boolean isDone() {
        return this.unblocked;
    }

    public final void reset() {
        this.unblocked = false;
        this.result = null;
        this.error = null;
        this.cancel = null;
        this.listenersInline = null;
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        this.block(0L);
        if (!this.isDone()) {
            throw new InterruptedException();
        }
        if (this.hasError()) {
            throw new ExecutionException((Throwable)this.error);
        }
        if (this.isCancelled()) {
            throw new ExecutionException(this.cancel);
        }
        return this.result;
    }

    @Override
    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.block(unit.toMillis(timeout));
        if (!this.isDone()) {
            throw new TimeoutException();
        }
        if (this.hasError()) {
            throw new ExecutionException((Throwable)this.error);
        }
        if (this.isCancelled()) {
            throw new ExecutionException(this.cancel);
        }
        return this.result;
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        this.cancel(new CancelException("Cancelled"));
        return true;
    }

    public static interface Listener<T, TError extends Exception> {
        public void ready(T var1);

        public void error(TError var1);

        public void cancelled(CancelException var1);

        public static <T, TError extends Exception> Listener<T, TError> from(final Consumer<T> onReady, final Consumer<TError> onError, final Consumer<CancelException> onCancel, final String name) {
            return new Listener<T, TError>(){

                @Override
                public void ready(T result) {
                    if (onReady != null) {
                        onReady.accept(result);
                    }
                }

                @Override
                public void error(TError error) {
                    if (onError != null) {
                        onError.accept(error);
                    }
                }

                @Override
                public void cancelled(CancelException event) {
                    if (onCancel != null) {
                        onCancel.accept(event);
                    }
                }

                public String toString() {
                    return name != null ? name : "" + onReady + " / " + onError + " / " + onCancel;
                }
            };
        }

        public static <T, TError extends Exception> Listener<T, TError> from(final Runnable onReady, Consumer<TError> onError, Consumer<CancelException> onCancel, String name) {
            return Listener.from(new Consumer<T>(){

                @Override
                public void accept(T t) {
                    if (onReady != null) {
                        onReady.run();
                    }
                }

                public String toString() {
                    return onReady != null ? onReady.toString() : "null";
                }
            }, onError, onCancel, name);
        }
    }
}

