/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.function.Consumer;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.tasks.drives.OpenFile;
import net.lecousin.framework.concurrent.tasks.drives.ReadFile;
import net.lecousin.framework.concurrent.tasks.drives.SeekFile;
import net.lecousin.framework.concurrent.tasks.drives.SetFileSize;
import net.lecousin.framework.concurrent.tasks.drives.WriteFile;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.util.Pair;

public class FileAccess
implements AutoCloseable,
Closeable {
    RandomAccessFile f;
    FileChannel channel;
    File file;
    String path;
    Task.Priority priority;
    Task<Void, IOException> openTask;
    long size;
    TaskManager manager;

    public FileAccess(File file, String mode, Task.Priority priority) {
        this.file = file;
        this.path = file.getAbsolutePath();
        this.priority = priority;
        this.manager = Threading.getDrivesManager().getTaskManager(file);
        if (this.manager == null) {
            this.manager = Threading.getUnmanagedTaskManager();
        }
        this.openTask = OpenFile.launch(this, mode, priority);
        LCCore.getApplication().toClose(0, this);
    }

    public String getPath() {
        return this.path;
    }

    public File getFile() {
        return this.file;
    }

    public Task<Void, IOException> getStartingTask() {
        return this.openTask;
    }

    public RandomAccessFile getDirectAccess() {
        return this.f;
    }

    public Task.Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Task.Priority priority) {
        this.priority = priority;
    }

    public String toString() {
        return "FileAccess[" + this.file.getAbsolutePath() + "]";
    }

    public void open() throws IOException {
        this.openTask.getOutput().blockException(0L);
    }

    public IAsync<IOException> closeAsync() {
        LCCore.getApplication().closed(this);
        if (this.openTask.cancelIfExecutionNotStarted(new CancelException("Close file requested", null))) {
            return new Async<boolean>(true);
        }
        Async<IOException> result = new Async<IOException>();
        this.openTask.getOutput().onDone(() -> {
            if (this.f != null) {
                try {
                    this.f.close();
                }
                catch (Exception e) {
                    result.error(IO.error(e));
                }
            }
            result.unblock();
        });
        return result;
    }

    @Override
    public void close() {
        LCCore.getApplication().closed(this);
        if (this.openTask.cancelIfExecutionNotStarted(new CancelException("Close file requested", null))) {
            return;
        }
        if (!this.openTask.isDone()) {
            this.openTask.getOutput().block(0L);
        }
        if (this.f != null) {
            try {
                this.f.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.f = null;
        }
    }

    public long getPosition() throws IOException {
        if (!this.openTask.isDone()) {
            return 0L;
        }
        if (!this.openTask.isSuccessful()) {
            throw this.openTask.getOutput().getError();
        }
        return this.channel.position();
    }

    public long getSize() throws IOException {
        this.openTask.getOutput().blockException(0L);
        return this.size;
    }

    public void getSize(AsyncSupplier<Long, IOException> sp) {
        Runnable ready = () -> {
            if (this.openTask.isSuccessful()) {
                sp.unblockSuccess(this.size);
            } else {
                sp.unblockError(this.openTask.getOutput().getError());
            }
        };
        this.openTask.getOutput().onDone(ready);
    }

    public void setSize(long newSize) throws IOException {
        SetFileSize.launch(this, newSize, this.priority).getOutput().blockException(0L);
    }

    public AsyncSupplier<Void, IOException> setSizeAsync(long newSize) {
        return SetFileSize.launch(this, newSize, this.priority).getOutput();
    }

    public int read(long pos, ByteBuffer buffer) throws IOException {
        try {
            return ReadFile.launch(this, pos, buffer, false, this.priority, null).getOutput().blockResult(0L);
        }
        catch (CancelException e) {
            throw IO.error(e);
        }
    }

    public AsyncSupplier<Integer, IOException> readAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return ReadFile.launch(this, pos, buffer, false, this.priority, ondone).getOutput();
    }

    public int readFully(long pos, ByteBuffer buffer) throws IOException {
        try {
            return ReadFile.launch(this, pos, buffer, true, this.priority, null).getOutput().blockResult(0L);
        }
        catch (CancelException e) {
            throw IO.error(e);
        }
    }

    public AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return ReadFile.launch(this, pos, buffer, true, this.priority, ondone).getOutput();
    }

    public long seek(IO.Seekable.SeekType type, long move, boolean allowAfterEnd) throws IOException {
        try {
            return SeekFile.launch(this, type, move, allowAfterEnd, true, this.priority, null).getOutput().blockResult(0L);
        }
        catch (Exception e) {
            throw IO.error(e);
        }
    }

    public AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, boolean allowAfterEnd, Consumer<Pair<Long, IOException>> ondone) {
        return SeekFile.launch(this, type, move, allowAfterEnd, true, this.priority, ondone).getOutput();
    }

    public long skip(long move) throws IOException {
        try {
            return SeekFile.launch(this, IO.Seekable.SeekType.FROM_CURRENT, move, false, false, this.priority, null).getOutput().blockResult(0L);
        }
        catch (Exception e) {
            throw IO.error(e);
        }
    }

    public AsyncSupplier<Long, IOException> skipAsync(long move, Consumer<Pair<Long, IOException>> ondone) {
        return SeekFile.launch(this, IO.Seekable.SeekType.FROM_CURRENT, move, false, false, this.priority, ondone).getOutput();
    }

    public int write(long pos, ByteBuffer buffer) throws IOException {
        try {
            return WriteFile.launch(this, pos, buffer, this.priority, null).getOutput().blockResult(0L);
        }
        catch (Exception e) {
            throw IO.error(e);
        }
    }

    public AsyncSupplier<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return WriteFile.launch(this, pos, buffer, this.priority, ondone).getOutput();
    }
}

