/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.tasks.drives.FileAccess;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.util.Pair;

class ReadFile
implements Executable<Integer, IOException> {
    private FileAccess file;
    private long pos;
    private ByteBuffer buffer;
    private boolean fully;

    public static Task<Integer, IOException> launch(FileAccess file, long pos, ByteBuffer buffer, boolean fully, Task.Priority priority, Consumer<Pair<Integer, IOException>> ondone) {
        Task<Integer, IOException> task = new Task<Integer, IOException>(file.manager, "Read from file " + file.path + (pos >= 0L ? " at " + pos : ""), priority, new ReadFile(file, pos, buffer, fully), ondone);
        file.openTask.ondone(task, false);
        return task;
    }

    public ReadFile(FileAccess file, long pos, ByteBuffer buffer, boolean fully) {
        this.file = file;
        this.pos = pos;
        this.buffer = buffer;
        this.fully = fully;
    }

    @Override
    public Integer execute(Task<Integer, IOException> taskContext) throws IOException, CancelException {
        if (!this.file.openTask.isSuccessful()) {
            throw this.file.openTask.getOutput().getError();
        }
        int nbRead = 0;
        if (this.pos >= 0L) {
            try {
                this.file.channel.position(this.pos);
            }
            catch (ClosedChannelException e) {
                throw IO.cancelClosed();
            }
            catch (IOException e) {
                throw new IOException("Unable to seek to position " + this.pos + " in file " + this.file.path, e);
            }
        }
        if (!this.fully) {
            try {
                nbRead = this.file.channel.read(this.buffer);
            }
            catch (ClosedChannelException e) {
                throw IO.cancelClosed();
            }
        }
        nbRead = 0;
        while (this.buffer.remaining() > 0) {
            int nb;
            if (taskContext.isCancelling()) {
                throw taskContext.getCancelEvent();
            }
            try {
                nb = this.file.channel.read(this.buffer);
            }
            catch (ClosedChannelException e) {
                throw IO.cancelClosed();
            }
            if (nb <= 0) break;
            nbRead += nb;
        }
        return nbRead;
    }
}

