/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.File;
import java.io.IOException;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.tasks.drives.RemoveDirectoryContent;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.progress.FakeWorkProgress;
import net.lecousin.framework.progress.WorkProgress;

public class RemoveDirectory
implements Executable<Long, IOException> {
    private File dir;
    private WorkProgress progress;
    private long work;
    private String progressSubText;
    private boolean calculateSize;

    public static Task<Long, IOException> task(File dir, WorkProgress progress, long work, String progressSubText, Task.Priority priority, boolean calculateSize) {
        return Task.file(dir, "Remove directory " + dir.getAbsolutePath(), priority, new RemoveDirectory(dir, progress, work, progressSubText, calculateSize));
    }

    public RemoveDirectory(File dir, WorkProgress progress, long work, String progressSubText, boolean calculateSize) {
        this.dir = dir;
        if (progress == null) {
            progress = new FakeWorkProgress();
        }
        this.progress = progress;
        this.work = work;
        if (progressSubText == null) {
            progressSubText = "";
        }
        this.progressSubText = progressSubText;
        this.calculateSize = calculateSize;
    }

    @Override
    public Long execute(Task<Long, IOException> taskContext) throws IOException, CancelException {
        String prev;
        String string = prev = this.progress != null ? this.progress.getSubText() : null;
        if (this.progress != null && this.progressSubText != null) {
            this.progress.setSubText(this.progressSubText);
        }
        long removedSize = RemoveDirectoryContent.deleteDirectory(this.dir, this.progress, this.work, this.calculateSize, taskContext);
        if (this.progress != null) {
            this.progress.setSubText(prev);
        }
        return removedSize;
    }
}

