/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.tasks.drives.RemoveFile;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.io.IOUtil;

public class RenameFile
implements Executable<Void, IOException> {
    private File source;
    private File destination;

    public static IAsync<IOException> rename(File source, File destination, Task.Priority priority) {
        String partitionDest;
        String partitionSource = Threading.getDrivesManager().getPartitionPath(source);
        if (Objects.equals(partitionSource, partitionDest = Threading.getDrivesManager().getPartitionPath(destination))) {
            return new Task<Void, IOException>(Threading.getDrivesManager().getTaskManager(partitionSource), "Rename file", priority, new RenameFile(source, destination), null).start().getOutput();
        }
        AsyncSupplier<Long, IOException> copy = IOUtil.copy(source, destination, priority, source.length(), null, 0L, null);
        Async<IOException> result = new Async<IOException>();
        copy.onDone(() -> RemoveFile.task(source, priority).start().getOutput().onDone(result), result);
        return result;
    }

    private RenameFile(File source, File destination) {
        this.source = source;
        this.destination = destination;
    }

    @Override
    public Void execute(Task<Void, IOException> taskContext) throws IOException {
        if (this.destination.exists()) {
            throw new IOException("Unable to rename file " + this.source.getAbsolutePath() + " into " + this.destination.getAbsolutePath() + " because the destination already exists");
        }
        if (!this.source.renameTo(this.destination)) {
            throw new IOException("Unable to rename file " + this.source.getAbsolutePath() + " into " + this.destination.getAbsolutePath());
        }
        return null;
    }
}

