/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.tasks.drives.FileAccess;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.util.Pair;

class WriteFile
implements Executable<Integer, IOException> {
    private FileAccess file;
    private long pos;
    private ByteBuffer buffer;

    public static Task<Integer, IOException> launch(FileAccess file, long pos, ByteBuffer buffer, Task.Priority priority, Consumer<Pair<Integer, IOException>> ondone) {
        Task<Integer, IOException> task = new Task<Integer, IOException>(file.manager, "Write to file " + file.path, priority, new WriteFile(file, pos, buffer), ondone);
        file.openTask.ondone(task, false);
        return task;
    }

    public WriteFile(FileAccess file, long pos, ByteBuffer buffer) {
        this.file = file;
        this.pos = pos;
        this.buffer = buffer;
    }

    @Override
    public Integer execute(Task<Integer, IOException> taskContext) throws IOException, CancelException {
        try {
            if (this.pos >= 0L) {
                this.file.channel.position(this.pos);
            }
            int nb = this.file.channel.write(this.buffer);
            this.file.size = this.file.channel.size();
            if (this.buffer.remaining() > 0) {
                throw new IOException("Only " + nb + " byte(s) written, " + this.buffer.remaining() + " remaining");
            }
            return nb;
        }
        catch (ClosedChannelException e) {
            throw new CancelException("File has been closed");
        }
    }
}

