/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.threads;

import java.util.ArrayList;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.util.DebugUtil;
import net.lecousin.framework.util.ThreadUtil;

public abstract class TaskExecutor {
    protected TaskManager manager;
    protected Thread thread;
    protected Task<?, ?> currentTask;
    protected long currentTaskStart = -1L;
    boolean blocked = false;
    boolean aside = false;

    protected TaskExecutor(TaskManager manager, String name) {
        this.manager = manager;
        this.thread = manager.threadFactory.newThread(() -> {
            try {
                this.threadLoop();
            }
            finally {
                Threading.unregisterTaskExecutor(this.thread);
                manager.executorEnd(this);
            }
        });
        this.thread.setName(name);
        this.thread.setUncaughtExceptionHandler(new UncaughtExceptionHandler());
        Threading.registerTaskExecutor(this, this.thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void blocked(IAsync<?> synchPoint, long timeout) {
        long start = System.nanoTime();
        this.manager.imBlocked(this);
        long startWait = System.nanoTime();
        IAsync<?> iAsync = synchPoint;
        synchronized (iAsync) {
            if (timeout <= 0L) {
                while (!synchPoint.isDone() && ThreadUtil.wait(synchPoint, 0L)) {
                }
            } else if (!synchPoint.isDone()) {
                ThreadUtil.wait(synchPoint, timeout);
            }
        }
        long endWait = System.nanoTime();
        this.manager.imUnblocked(this, startWait);
        long end = System.nanoTime();
        this.unblocked(start, startWait, endWait, end);
        if (end - start > this.currentTask.getMaxBlockingTimeInNanoBeforeToLog() && Threading.getLogger().debug()) {
            StackTraceElement[] stack = this.thread.getStackTrace();
            ArrayList<String> blocking = new ArrayList<String>(stack.length - 2);
            for (int i = 2; i < stack.length; ++i) {
                StackTraceElement e = stack[i];
                String c = e.getClassName();
                blocking.add(e.getFileName() + ":" + c + "." + e.getMethodName() + ":" + e.getLineNumber());
            }
            StringBuilder s = new StringBuilder();
            s.append("Task ").append(this.currentTask.getDescription()).append(" has been blocked for ").append((end - start) / 1000000L).append("ms. consider to split it into several tasks: ");
            for (String b : blocking) {
                s.append("\n - ").append(b);
            }
            Threading.getLogger().debug(s.toString());
        }
    }

    public final Task<?, ?> getCurrentTask() {
        return this.currentTask;
    }

    public boolean isAside() {
        return this.aside;
    }

    protected abstract void threadLoop();

    protected abstract void unblocked(long var1, long var3, long var5, long var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        this.currentTaskStart = System.nanoTime();
        Task<?, ?> task = this.currentTask;
        synchronized (task) {
            this.currentTask.status = (byte)3;
            this.currentTask.nextExecution = 0L;
        }
        this.currentTask.execute();
        if (Threading.traceTaskTime) {
            Threading.getLogger().debug("Task done in " + (System.nanoTime() - this.currentTaskStart) + "ns: " + this.currentTask.getDescription());
        }
        Task<?, ?> t = this.currentTask;
        this.currentTask = null;
        t.rescheduleIfNeeded();
    }

    public void debug(StringBuilder s, String type) {
        s.append("\n - ").append(type).append(' ').append(this.thread.getName()).append(": ");
        Task<?, ?> c = this.currentTask;
        if (c == null) {
            s.append("waiting");
        } else {
            s.append("executing ").append(c.getDescription()).append(" (").append(c.getClass().getName()).append(")");
        }
        if (c != null) {
            DebugUtil.createStackTrace(s, this.thread.getStackTrace());
        }
    }

    private class UncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (TaskExecutor.this.currentTask != null && !TaskExecutor.this.currentTask.isDone()) {
                TaskExecutor.this.currentTask.cancelledBecauseExecutorDied(new CancelException("Unexpected error in thread " + t.getName(), e));
            }
            TaskExecutor.this.manager.executorUncaughtException(TaskExecutor.this);
            LCCore.getApplication().getDefaultLogger().error("Error in TaskWorker " + t.getName(), e);
        }
    }
}

