/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.threads;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskExecutor;
import net.lecousin.framework.concurrent.threads.TaskManagerMonitor;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.concurrent.threads.priority.TaskPriorityManager;
import net.lecousin.framework.util.DebugUtil;

public abstract class TaskManager {
    private String name;
    private Object resource;
    protected ThreadFactory threadFactory;
    protected TaskPriorityManager taskPriorityManager;
    protected TaskManagerMonitor monitor;
    private LinkedList<TaskExecutor> aside = new LinkedList();
    private TurnArray<TaskExecutor> blocked = new TurnArray(20);
    protected Object stopping = null;
    protected TaskManager transferredTo = null;
    protected boolean stopped = false;

    public TaskManager(String name, Object resource, ThreadFactory threadFactory, TaskPriorityManager taskPriorityManager, TaskManagerMonitor.Configuration monitorConfig) {
        this.name = name;
        this.resource = resource;
        this.threadFactory = threadFactory;
        this.taskPriorityManager = taskPriorityManager;
        this.monitor = new TaskManagerMonitor(this, monitorConfig);
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final Object getResource() {
        return this.resource;
    }

    public TaskManagerMonitor getMonitor() {
        return this.monitor;
    }

    final void start() {
        this.startThreads();
    }

    protected abstract void startThreads();

    final void started() {
        this.threadingStarted();
    }

    protected abstract void threadingStarted();

    public final TaskManager getTransferTarget() {
        return this.transferredTo;
    }

    final void shutdownWhenNoMoreTasks() {
        this.stopping = new Object();
        this.taskPriorityManager.stopping();
        Thread t = new Thread("Stopping Task Manager: " + this.name){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                System.out.println("   * Stopping Task Manager: " + TaskManager.this.name);
                while (true) {
                    Object object = TaskManager.this.taskPriorityManager;
                    synchronized (object) {
                        if (!TaskManager.this.taskPriorityManager.hasRemainingTasks(false)) {
                            System.out.println("   * Task Manager has no more task to do: " + TaskManager.this.name);
                            TaskManager.this.finishAndStopActiveAndInactiveExecutors();
                            TaskManager.this.taskPriorityManager.notifyAll();
                            break;
                        }
                    }
                    System.out.println("   * Waiting for task manager " + TaskManager.this.name + " to finish its tasks");
                    object = TaskManager.this.stopping;
                    synchronized (object) {
                        try {
                            TaskManager.this.stopping.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
            }
        };
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void forceStop() {
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            this.forceStopActiveAndInactiveExecutors();
            this.taskPriorityManager.forceStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void transferAndClose(TaskManager transferTo) {
        List<Task<?, ?>> list;
        Threading.getLogger().info("Transferring TaskManager " + this.name + " to " + transferTo.name);
        this.transferredTo = transferTo;
        this.taskPriorityManager.stopping();
        TurnArray<TaskExecutor> turnArray = this.taskPriorityManager;
        synchronized (turnArray) {
            list = this.taskPriorityManager.removeAllPendingTasks();
        }
        for (Task task : list) {
            Threading.getLogger().debug("  - Task ready " + task.getDescription() + " transferred to " + transferTo.name);
            transferTo.addReady(task);
        }
        turnArray = this.taskPriorityManager;
        synchronized (turnArray) {
            this.finishAndStopActiveAndInactiveExecutors();
            this.taskPriorityManager.notifyAll();
        }
        turnArray = this.blocked;
        synchronized (turnArray) {
            for (TaskExecutor executor : this.blocked) {
                Threading.getLogger().error("  - Remaining blocked thread: " + executor.thread.getName());
            }
        }
        Threading.getLogger().info("End of transfer for TaskManager " + this.name + " to " + transferTo.name);
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cancelAndStop() {
        List<Task<?, ?>> list;
        this.stopped = true;
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            this.forceStopActiveAndInactiveExecutors();
            this.taskPriorityManager.notifyAll();
        }
        TaskPriorityManager taskPriorityManager2 = this.taskPriorityManager;
        synchronized (taskPriorityManager2) {
            list = this.taskPriorityManager.removeAllPendingTasks();
        }
        for (Task task : list) {
            task.cancel(new CancelException("Stop Task Manager", null));
        }
    }

    final int getRemainingTasks(boolean includingBackground) {
        return this.taskPriorityManager.getRemainingTasks(includingBackground);
    }

    protected abstract void finishAndStopActiveAndInactiveExecutors();

    protected abstract void forceStopActiveAndInactiveExecutors();

    public abstract boolean allActiveExecutorsStopped();

    final boolean isStopping() {
        return this.stopping != null;
    }

    final void addReady(Task<?, ?> t) {
        if (this.stopped) {
            t.cancel(new CancelException("Task Manager already stopped", null));
        }
        this.add(t);
    }

    protected void add(Task<?, ?> t) {
        this.taskPriorityManager.add(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(Task<?, ?> task) {
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            if (this.taskPriorityManager.remove(task)) {
                return true;
            }
        }
        if (this.transferredTo != null) {
            do {
                task.transferTo(task.getTaskManager().transferredTo);
            } while (task.getTaskManager().transferredTo != null);
            taskPriorityManager = task.getTaskManager().taskPriorityManager;
            synchronized (taskPriorityManager) {
                return task.getTaskManager().taskPriorityManager.remove(task);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imBlocked(TaskExecutor executor) {
        executor.blocked = true;
        if (Threading.traceBlockingTasks) {
            Threading.getLogger().error("Task " + executor.getCurrentTask().getDescription() + " blocked", new Exception());
        }
        if (this.transferredTo != null) {
            Threading.getLogger().info("Task blocked while transferring to a new TaskManager: " + executor.getCurrentTask().getDescription());
            TurnArray<TaskExecutor> turnArray = this.blocked;
            synchronized (turnArray) {
                this.blocked.addLast(executor);
            }
            return;
        }
        this.replaceBlockedExecutor(executor);
        TurnArray<TaskExecutor> turnArray = this.blocked;
        synchronized (turnArray) {
            this.blocked.addLast(executor);
        }
    }

    protected abstract void replaceBlockedExecutor(TaskExecutor var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imUnblocked(TaskExecutor executor, long since) {
        executor.blocked = false;
        if (Threading.traceBlockingTasks) {
            Threading.getLogger().error("Task " + executor.getCurrentTask().getDescription() + " unblocked after " + (System.nanoTime() - since) / 1000000L + "ms.");
        }
        this.unblockedExecutor(executor);
        TurnArray<TaskExecutor> turnArray = this.blocked;
        synchronized (turnArray) {
            this.blocked.removeInstance(executor);
        }
    }

    protected abstract void unblockedExecutor(TaskExecutor var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executorEnd(TaskExecutor executor) {
        LinkedList<TaskExecutor> linkedList = this.aside;
        synchronized (linkedList) {
            this.aside.remove(executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putExecutorAside(TaskExecutor executor) {
        if (executor.aside) {
            return;
        }
        executor.aside = true;
        LinkedList<TaskExecutor> linkedList = this.aside;
        synchronized (linkedList) {
            this.aside.add(executor);
        }
        this.executorAside(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void killExecutor(TaskExecutor executor) {
        LinkedList<TaskExecutor> linkedList = this.aside;
        synchronized (linkedList) {
            if (!this.aside.remove(executor)) {
                return;
            }
        }
        StackTraceElement[] stack = executor.thread.getStackTrace();
        StringBuilder s = new StringBuilder(1024);
        s.append("Task stopped at \r\n");
        DebugUtil.createStackTrace(s, stack);
        Threading.getLogger().error(s.toString());
        Task<?, ?> task = executor.getCurrentTask();
        if (task != null) {
            task.cancel(new CancelException("Task was running since a too long time"));
        }
        try {
            executor.thread.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected abstract void executorUncaughtException(TaskExecutor var1);

    protected abstract void executorAside(TaskExecutor var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<TaskExecutor> getBlockedExecutors() {
        TurnArray<TaskExecutor> turnArray = this.blocked;
        synchronized (turnArray) {
            return new ArrayList<TaskExecutor>(this.blocked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<TaskExecutor> getAllActiveExecutors() {
        List<TaskExecutor> actives = this.getActiveExecutors();
        ArrayList<TaskExecutor> list = new ArrayList<TaskExecutor>(actives.size() + this.blocked.size() + this.aside.size());
        list.addAll(actives);
        Deque<TaskExecutor> deque = this.blocked;
        synchronized (deque) {
            list.addAll(this.blocked);
        }
        deque = this.aside;
        synchronized (deque) {
            list.addAll(this.aside);
        }
        return list;
    }

    public abstract List<TaskExecutor> getActiveExecutors();

    public abstract List<TaskExecutor> getInactiveExecutors();

    public final void debug(StringBuilder s) {
        this.getDebugDescription(s);
        for (TaskExecutor w : this.getActiveExecutors()) {
            try {
                w.debug(s, "Active");
            }
            catch (Exception exception) {}
        }
        List<TaskExecutor> inactives = this.getInactiveExecutors();
        if (!inactives.isEmpty()) {
            s.append("\n - ").append(inactives.size()).append(" thread(s) inactive");
        }
        for (TaskExecutor w : this.blocked) {
            try {
                w.debug(s, "Blocked");
            }
            catch (Exception exception) {}
        }
        for (TaskExecutor w : this.aside) {
            try {
                w.debug(s, "Aside");
            }
            catch (Exception exception) {}
        }
    }

    protected abstract void getDebugDescription(StringBuilder var1);
}

