/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.threads;

import net.lecousin.framework.collections.sort.RedBlackTreeLong;
import net.lecousin.framework.collections.sort.RedBlackTreeLongByRange;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.Threading;

class TaskScheduler
extends Thread {
    private static TaskScheduler instance;
    private static Object lock;
    private boolean stop = false;
    static boolean stopping;
    private RedBlackTreeLongByRange<Task<?, ?>> waitingTime = new RedBlackTreeLongByRange(120000L);
    long waitingNano = 0L;
    long busyNano = 0L;
    long nbRounds = 0L;

    private TaskScheduler() {
        super("Task Scheduler");
    }

    static void init() {
        lock = new Object();
        instance = new TaskScheduler();
        instance.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void schedule(Task<?, ?> task) {
        Object object = lock;
        synchronized (object) {
            boolean first = TaskScheduler.instance.waitingTime.isEmpty() || task.nextExecution < TaskScheduler.instance.waitingTime.getMin().getValue();
            TaskScheduler.instance.waitingTime.add(task.nextExecution, task);
            task.status = 1;
            if (first) {
                lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean cancel(Task<?, ?> task) {
        Object object = lock;
        synchronized (object) {
            if (TaskScheduler.instance.waitingTime.containsInstance(task.nextExecution, task)) {
                TaskScheduler.instance.waitingTime.removeInstance(task.nextExecution, task);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void changeNextExecutionTime(Task<?, ?> t, long time) {
        Object object = lock;
        synchronized (object) {
            if (t.status == 1) {
                boolean needWakeUp = TaskScheduler.instance.waitingTime.getMin().getElement() == t;
                TaskScheduler.instance.waitingTime.removeInstance(t.nextExecution, t);
                t.nextExecution = time;
                if (!needWakeUp && (TaskScheduler.instance.waitingTime.isEmpty() || TaskScheduler.instance.waitingTime.getMin().getValue() > time)) {
                    needWakeUp = true;
                }
                TaskScheduler.instance.waitingTime.add(time, t);
                if (needWakeUp) {
                    lock.notify();
                }
                return;
            }
            if (t.status == 2) {
                t.getTaskManager().remove(t);
                t.nextExecution = time;
                t.status = 1;
                if (time <= System.currentTimeMillis()) {
                    t.sendToTaskManager();
                } else {
                    boolean needWakeUp = TaskScheduler.instance.waitingTime.isEmpty() || TaskScheduler.instance.waitingTime.getMin().getValue() > time;
                    TaskScheduler.instance.waitingTime.add(time, t);
                    if (needWakeUp) {
                        lock.notify();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void end() {
        TaskScheduler.instance.stop = true;
        Object object = lock;
        synchronized (object) {
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start = System.nanoTime();
        while (!this.stop) {
            ++this.nbRounds;
            try {
                Object object = lock;
                synchronized (object) {
                    long now;
                    long timeout = 0L;
                    if (!this.waitingTime.isEmpty()) {
                        now = System.currentTimeMillis();
                        do {
                            RedBlackTreeLong.Node<Task<?, ?>> min;
                            if ((min = this.waitingTime.getMin()).getValue() > now) {
                                timeout = min.getValue() - now;
                                break;
                            }
                            Task<?, ?> task = min.getElement();
                            this.waitingTime.removeMin();
                            if (task.isCancelled()) continue;
                            if (task.status != 1) {
                                Threading.getLogger().debug("Scheduled task is not in a waiting status (" + task.status + "), so the scheduler does not start it");
                                continue;
                            }
                            task.sendToTaskManager();
                        } while (!this.waitingTime.isEmpty());
                    }
                    now = System.nanoTime();
                    this.busyNano += now - start;
                    try {
                        lock.wait(timeout);
                        start = System.nanoTime();
                        this.waitingNano += start - now;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            catch (Exception t) {
                Threading.getLogger().error("Error in Task Scheduler", t);
            }
        }
        System.out.println("Task Scheduler stopped: was busy " + (double)this.busyNano / 1.0E9 + ", was waiting " + (double)this.waitingNano / 1.0E9 + ", did " + this.nbRounds + " rounds");
    }

    static {
        stopping = false;
    }
}

