/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.threads.fixed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskExecutor;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.TaskManagerMonitor;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.concurrent.threads.fixed.TaskWorker;
import net.lecousin.framework.concurrent.threads.priority.TaskPriorityManager;
import net.lecousin.framework.exception.NoException;

public abstract class FixedThreadTaskManager
extends TaskManager {
    private int nbThreads;
    private TurnArray<TaskWorker> spare;
    private LinkedList<AsyncSupplier<TaskWorker, NoException>> pausesToDo = new LinkedList();

    public FixedThreadTaskManager(String name, Object resource, int nbThreads, ThreadFactory threadFactory, TaskPriorityManager taskPriorityManager, TaskManagerMonitor.Configuration monitorConfig) {
        super(name, resource, threadFactory, taskPriorityManager, monitorConfig);
        this.nbThreads = nbThreads;
        this.spare = new TurnArray(nbThreads * 2);
    }

    public int getNbThreads() {
        return this.nbThreads;
    }

    @Override
    protected void threadingStarted() {
        Task.cpu("Close old spare threads for " + this.getName(), Task.Priority.BACKGROUND, new CloseOldSpare()).executeEvery(60000L, 360000L).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void finishAndStopActiveAndInactiveExecutors() {
        AsyncSupplier<TaskWorker, NoException> waitPause;
        this.finishAndStopWorkers();
        TurnArray<TaskWorker> turnArray = this.spare;
        synchronized (turnArray) {
            while (!this.spare.isEmpty()) {
                this.spare.removeFirst().forceStop(true);
            }
        }
        while ((waitPause = this.getPauseToDo()) != null) {
            waitPause.unblockSuccess(null);
        }
    }

    protected abstract void finishAndStopWorkers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void forceStopActiveAndInactiveExecutors() {
        this.forceStopWorkers();
        TurnArray<TaskWorker> turnArray = this.spare;
        synchronized (turnArray) {
            while (!this.spare.isEmpty()) {
                this.spare.removeFirst().forceStop(true);
            }
        }
    }

    protected abstract void forceStopWorkers();

    @Override
    protected void executorUncaughtException(TaskExecutor executor) {
        this.replaceBySpare((TaskWorker)executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final Task<?, ?> peekNextOrWait() {
        block12: {
            Task<?, ?> task;
            try {
                TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
                // MONITORENTER : taskPriorityManager
                if (this.pausesToDo.isEmpty()) break block12;
                task = null;
                // MONITOREXIT : taskPriorityManager
                if (this.stopping == null) return task;
                Object object = this.stopping;
            }
            catch (Throwable throwable) {
                if (this.stopping == null) throw throwable;
                Object object = this.stopping;
                // MONITORENTER : object
                this.stopping.notify();
                // MONITOREXIT : object
                throw throwable;
            }
            this.stopping.notify();
            // MONITOREXIT : object
            return task;
        }
        Task<?, ?> task = this.taskPriorityManager.peekNextOrWait();
        // MONITOREXIT : taskPriorityManager
        if (this.stopping == null) return task;
        Object object = this.stopping;
        // MONITORENTER : object
        this.stopping.notify();
        // MONITOREXIT : object
        return task;
    }

    protected abstract TaskWorker createWorker();

    protected abstract void replaceWorkerBySpare(TaskWorker var1, TaskWorker var2);

    protected abstract TaskWorker[] getWorkers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsyncSupplier<TaskWorker, NoException> getPauseToDo() {
        if (this.pausesToDo.isEmpty()) {
            return null;
        }
        LinkedList<AsyncSupplier<TaskWorker, NoException>> linkedList = this.pausesToDo;
        synchronized (linkedList) {
            if (this.pausesToDo.isEmpty()) {
                return null;
            }
            return this.pausesToDo.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceBySpare(TaskWorker worker) {
        TaskWorker w;
        Object object = this.spare;
        synchronized (object) {
            w = this.spare.pollFirst();
        }
        if (w == null) {
            w = this.createWorker();
            this.replaceWorkerBySpare(worker, w);
            w.getThread().start();
        } else {
            this.replaceWorkerBySpare(worker, w);
            object = w;
            synchronized (object) {
                w.notify();
            }
        }
    }

    @Override
    protected void replaceBlockedExecutor(TaskExecutor executor) {
        this.replaceBySpare((TaskWorker)executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unblockedExecutor(TaskExecutor executor) {
        AsyncSupplier pause = new AsyncSupplier();
        Object object = this.taskPriorityManager;
        synchronized (object) {
            LinkedList<AsyncSupplier<TaskWorker, NoException>> linkedList = this.pausesToDo;
            synchronized (linkedList) {
                this.pausesToDo.add(pause);
            }
            this.taskPriorityManager.notify();
        }
        if (!this.stopped) {
            pause.blockPause(30000L);
        }
        if (pause.getResult() != null) {
            this.replaceWorkerBySpare((TaskWorker)pause.getResult(), (TaskWorker)executor);
            object = this.spare;
            synchronized (object) {
                this.spare.addFirst((TaskWorker)pause.getResult());
            }
        }
    }

    @Override
    public List<TaskExecutor> getActiveExecutors() {
        return Arrays.asList(this.getWorkers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskExecutor> getInactiveExecutors() {
        TurnArray<TaskWorker> turnArray = this.spare;
        synchronized (turnArray) {
            return new ArrayList<TaskExecutor>(this.spare);
        }
    }

    @Override
    protected void executorAside(TaskExecutor executor) {
        TaskWorker newWorker = this.createWorker();
        this.replaceWorkerBySpare((TaskWorker)executor, newWorker);
        newWorker.getThread().start();
    }

    @Override
    protected void getDebugDescription(StringBuilder s) {
        s.append("Task Manager: ").append(this.getName()).append(" (").append(this.nbThreads).append(" threads)");
    }

    private class CloseOldSpare
    implements Executable<Void, NoException> {
        private CloseOldSpare() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void execute(Task<Void, NoException> taskContext) {
            TurnArray turnArray = FixedThreadTaskManager.this.spare;
            synchronized (turnArray) {
                if (FixedThreadTaskManager.this.spare.size() <= FixedThreadTaskManager.this.nbThreads) {
                    return null;
                }
                int maxToStop = (FixedThreadTaskManager.this.spare.size() - FixedThreadTaskManager.this.nbThreads) / 3 + 1;
                int nbStop = 0;
                for (TaskWorker t : FixedThreadTaskManager.this.spare) {
                    if (t.lastUsed <= 300000L) continue;
                    Threading.getLogger().info("Spare thread not used since more than 5 minutes => stop it: " + t.getThread().getName());
                    t.forceStop(true);
                    FixedThreadTaskManager.this.spare.removeInstance(t);
                    if (++nbStop < maxToStop) continue;
                    return null;
                }
            }
            return null;
        }
    }
}

