/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.threads.fixed;

import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.threads.TaskExecutor;
import net.lecousin.framework.concurrent.threads.fixed.FixedThreadTaskManager;
import net.lecousin.framework.exception.NoException;

class TaskWorker
extends TaskExecutor {
    boolean stop = false;
    boolean finish = false;
    long tasksDone = 0L;
    long workingTime = 0L;
    long waitingTime = 0L;
    long blockedTime = 0L;
    long lastUsed = -1L;

    TaskWorker(String name, FixedThreadTaskManager manager) {
        super(manager, name);
    }

    Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceStop(boolean normal) {
        if (!normal) {
            StringBuilder s = new StringBuilder(200);
            s.append("Task worker forced to stop: ");
            this.debug(s, "");
            System.err.print(s.toString());
        }
        this.stop = true;
        TaskWorker taskWorker = this;
        synchronized (taskWorker) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishAndStop() {
        this.finish = true;
        TaskWorker taskWorker = this;
        synchronized (taskWorker) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void threadLoop() {
        FixedThreadTaskManager manager = (FixedThreadTaskManager)this.manager;
        long waitStart = System.nanoTime();
        while (!this.stop) {
            AsyncSupplier<TaskWorker, NoException> waitPause = manager.getPauseToDo();
            if (waitPause != null) {
                TaskWorker taskWorker = this;
                synchronized (taskWorker) {
                    waitPause.unblockSuccess(this);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            long now = System.nanoTime();
            this.waitingTime += now - waitStart;
            waitStart = now;
            this.currentTask = manager.peekNextOrWait();
            if (this.currentTask == null) {
                if (!this.finish) continue;
                this.stop = true;
                continue;
            }
            this.executeTask();
            this.lastUsed = System.currentTimeMillis();
            ++this.tasksDone;
            waitStart = now = System.nanoTime();
            this.workingTime += now - this.currentTaskStart;
            if (!this.isAside()) continue;
            break;
        }
    }

    @Override
    protected void unblocked(long startBlock, long startWait, long endWait, long endBlock) {
        this.blockedTime += endWait - startWait;
        this.workingTime -= endBlock - startBlock;
        this.waitingTime += endBlock - startBlock;
    }
}

