/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.util;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;

public interface AsyncConsumer<T, TError extends Exception> {
    public IAsync<TError> consume(T var1);

    public IAsync<TError> end();

    public void error(TError var1);

    default public IAsync<TError> push(List<T> dataList) {
        final Iterator<T> it = dataList.iterator();
        final Async result = new Async();
        Runnable pushNext = new Runnable(){

            @Override
            public void run() {
                if (!it.hasNext()) {
                    result.unblock();
                    return;
                }
                AsyncConsumer.this.consume(it.next()).onDone(this, result);
            }
        };
        pushNext.run();
        return result;
    }

    default public IAsync<TError> consumeEnd(T data) {
        Async result = new Async();
        this.consume(data).onDone(() -> this.end().onDone(result), result);
        return result;
    }

    default public <T2> AsyncConsumer<T2, TError> convert(final Function<T2, T> converter) {
        final AsyncConsumer parent = this;
        return new AsyncConsumer<T2, TError>(){

            @Override
            public IAsync<TError> consume(T2 data) {
                return parent.consume(converter.apply(data));
            }

            @Override
            public IAsync<TError> end() {
                return parent.end();
            }

            @Override
            public void error(TError error) {
                parent.error(error);
            }
        };
    }

    public static class Error<T, TError extends Exception>
    implements AsyncConsumer<T, TError> {
        protected TError error;

        public Error(TError error) {
            this.error = error;
        }

        @Override
        public IAsync<TError> consume(T data) {
            return new Async<TError>(this.error);
        }

        @Override
        public IAsync<TError> end() {
            return new Async<TError>(this.error);
        }

        @Override
        public void error(TError error) {
        }
    }

    public static interface Simple<T, TError extends Exception>
    extends AsyncConsumer<T, TError> {
        @Override
        default public IAsync<TError> end() {
            return new Async<boolean>(true);
        }

        @Override
        default public void error(TError error) {
        }
    }
}

