/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.util;

import java.util.Iterator;
import java.util.LinkedList;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.exception.NoException;

public final class AsyncTimeoutManager {
    private Task<Void, NoException> task = null;
    private long taskTime = 0L;
    private LinkedList<Waiting> waiting = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void timeout(IAsync<?> async, int timeout, Runnable onTimeout) {
        AsyncTimeoutManager manager;
        Application app;
        Application application = app = LCCore.getApplication();
        synchronized (application) {
            manager = app.getInstance(AsyncTimeoutManager.class);
            if (manager == null) {
                manager = new AsyncTimeoutManager();
                app.setInstance(AsyncTimeoutManager.class, manager);
            }
        }
        manager.add(async, timeout, onTimeout);
    }

    private AsyncTimeoutManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(IAsync<?> async, int timeout, Runnable onTimeout) {
        if (async.isDone()) {
            return;
        }
        Waiting w = new Waiting();
        w.async = async;
        w.onTimeout = onTimeout;
        w.expiration = System.currentTimeMillis() + (long)timeout;
        LinkedList<Waiting> linkedList = this.waiting;
        synchronized (linkedList) {
            this.waiting.add(w);
            this.updateTask(w.expiration);
        }
        async.onDone(() -> {
            LinkedList<Waiting> linkedList = this.waiting;
            synchronized (linkedList) {
                if (this.waiting.remove(w)) {
                    this.updateTask();
                }
            }
        });
    }

    private void updateTask(long expiration) {
        if (this.task == null) {
            this.taskTime = expiration;
            this.task = Task.cpu("Watch asynchronous operations timeout", Task.Priority.LOW, new TimeoutTask());
            this.task.executeAt(expiration);
            this.task.start();
        } else if (expiration < this.taskTime) {
            this.taskTime = expiration;
            this.task.changeNextExecutionTime(expiration);
        }
    }

    private void updateTask() {
        long next = -1L;
        for (Waiting w : this.waiting) {
            if (next != -1L && w.expiration >= next) continue;
            next = w.expiration;
        }
        if (next == -1L) {
            if (this.task != null) {
                this.task.cancelIfExecutionNotStarted(new CancelException("No more timeout to watch"));
                this.task = null;
            }
        } else if (next != this.taskTime) {
            this.taskTime = next;
            this.task.changeNextExecutionTime(next);
        }
    }

    private class TimeoutTask
    implements Executable<Void, NoException> {
        private TimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void execute(Task<Void, NoException> taskContext) throws NoException, CancelException {
            long next = -1L;
            LinkedList<Runnable> toRun = new LinkedList<Runnable>();
            long now = System.currentTimeMillis();
            LinkedList linkedList = AsyncTimeoutManager.this.waiting;
            synchronized (linkedList) {
                Iterator it = AsyncTimeoutManager.this.waiting.iterator();
                while (it.hasNext()) {
                    Waiting w = (Waiting)it.next();
                    if (w.expiration <= now) {
                        if (!w.async.isDone()) {
                            toRun.add(w.onTimeout);
                        }
                        it.remove();
                        continue;
                    }
                    if (next != -1L && w.expiration >= next) continue;
                    next = w.expiration;
                }
                AsyncTimeoutManager.this.taskTime = next;
                if (next != -1L) {
                    AsyncTimeoutManager.this.task.executeAgainAt(next);
                }
            }
            for (Runnable r : toRun) {
                r.run();
            }
            return null;
        }
    }

    private static class Waiting {
        private IAsync<?> async;
        private long expiration;
        private Runnable onTimeout;

        private Waiting() {
        }
    }
}

