/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.lecousin.framework.concurrent.async.AsyncSupplier;

public interface PartialAsyncConsumer<T, TError extends Exception> {
    public AsyncSupplier<Boolean, TError> consume(T var1);

    public boolean isExpectingData();

    default public <Target, TErrorTarget extends Exception> PartialAsyncConsumer<Target, TErrorTarget> convert(Function<Target, T> convertAtTheBeginning, BiConsumer<T, Target> updateAtTheEnd, Function<TError, TErrorTarget> errorConverter) {
        return new Converter<Target, TErrorTarget, T, TError>(this, convertAtTheBeginning, updateAtTheEnd, errorConverter);
    }

    default public <TErrorTarget extends Exception> PartialAsyncConsumer<T, TErrorTarget> convertError(Function<TError, TErrorTarget> errorConverter) {
        return new ErrorConverter(this, errorConverter);
    }

    public static class ErrorConverter<T, TErrorSource extends Exception, TErrorTarget extends Exception>
    implements PartialAsyncConsumer<T, TErrorTarget> {
        private PartialAsyncConsumer<T, TErrorSource> consumer;
        private Function<TErrorSource, TErrorTarget> errorConverter;

        public ErrorConverter(PartialAsyncConsumer<T, TErrorSource> consumer, Function<TErrorSource, TErrorTarget> errorConverter) {
            this.consumer = consumer;
            this.errorConverter = errorConverter;
        }

        @Override
        public AsyncSupplier<Boolean, TErrorTarget> consume(T data) {
            AsyncSupplier result = new AsyncSupplier();
            this.consumer.consume(data).forward(result, this.errorConverter);
            return result;
        }

        @Override
        public boolean isExpectingData() {
            return this.consumer.isExpectingData();
        }
    }

    public static class Converter<T, TError extends Exception, Target, TErrorTarget extends Exception>
    implements PartialAsyncConsumer<T, TError> {
        private PartialAsyncConsumer<Target, TErrorTarget> consumer;
        private Function<T, Target> convertAtTheBeginning;
        private BiConsumer<Target, T> updateAtTheEnd;
        private Function<TErrorTarget, TError> errorConverter;

        public Converter(PartialAsyncConsumer<Target, TErrorTarget> consumer, Function<T, Target> convertAtTheBeginning, BiConsumer<Target, T> updateAtTheEnd, Function<TErrorTarget, TError> errorConverter) {
            this.consumer = consumer;
            this.convertAtTheBeginning = convertAtTheBeginning;
            this.updateAtTheEnd = updateAtTheEnd;
            this.errorConverter = errorConverter;
        }

        @Override
        public AsyncSupplier<Boolean, TError> consume(T data) {
            Target target = this.convertAtTheBeginning.apply(data);
            AsyncSupplier<Boolean, TErrorTarget> consumption = this.consumer.consume(target);
            AsyncSupplier result = new AsyncSupplier();
            consumption.onDone(() -> {
                if (consumption.hasError()) {
                    result.error((Exception)this.errorConverter.apply(consumption.getError()));
                } else if (consumption.isCancelled()) {
                    result.cancel(consumption.getCancelEvent());
                } else {
                    this.updateAtTheEnd.accept(target, data);
                    result.unblockSuccess(consumption.getResult());
                }
            });
            return result;
        }

        @Override
        public boolean isExpectingData() {
            return this.consumer.isExpectingData();
        }
    }

    public static class ConsumerQueue<T, TError extends Exception>
    implements PartialAsyncConsumer<T, TError> {
        private PartialAsyncConsumer<T, TError> currentConsumer;
        protected Queue<PartialAsyncConsumer<T, TError>> queue;

        public ConsumerQueue(Queue<PartialAsyncConsumer<T, TError>> consumers) {
            this.queue = consumers;
            this.nextConsumer();
        }

        @SafeVarargs
        public ConsumerQueue(PartialAsyncConsumer<T, TError> ... consumers) {
            this.queue = new LinkedList<PartialAsyncConsumer<T, TError>>();
            Collections.addAll(this.queue, consumers);
            this.nextConsumer();
        }

        protected ConsumerQueue() {
            this.queue = new LinkedList<PartialAsyncConsumer<T, TError>>();
        }

        protected void nextConsumer() {
            do {
                this.currentConsumer = this.queue.poll();
            } while (this.currentConsumer != null && !this.currentConsumer.isExpectingData());
        }

        @Override
        public AsyncSupplier<Boolean, TError> consume(T data) {
            AsyncSupplier result = new AsyncSupplier();
            if (this.currentConsumer == null) {
                result.unblockSuccess(Boolean.TRUE);
                return result;
            }
            this.currentConsumer.consume(data).onDone(endOfConsumer -> {
                if (!endOfConsumer.booleanValue()) {
                    result.unblockSuccess(Boolean.FALSE);
                    return;
                }
                this.nextConsumer();
                this.consume(data).forward(result);
            }, result);
            return result;
        }

        @Override
        public boolean isExpectingData() {
            return this.currentConsumer != null;
        }
    }
}

