/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.encoding;

import java.util.function.Function;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.encoding.BytesDecoder;
import net.lecousin.framework.encoding.BytesEncoder;
import net.lecousin.framework.encoding.EncodingException;
import net.lecousin.framework.encoding.UnexpectedEndOfEncodedData;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.memory.ByteArrayCache;

public final class Base64Encoding
implements BytesEncoder.KnownOutputSize,
BytesDecoder.KnownOutputSize {
    public static final Base64Encoding instance = new Base64Encoding(43, 47);
    public static final Base64Encoding instanceURL = new Base64Encoding(45, 95);
    private byte char62;
    private byte char63;

    private Base64Encoding(byte char62, byte char63) {
        this.char62 = char62;
        this.char63 = char63;
    }

    public int decodeChar(byte b) throws EncodingException {
        if (b >= 65) {
            if (b >= 97) {
                if (b <= 122) {
                    return b - 97 + 26;
                }
                throw new InvalidBase64Character(b);
            }
            if (b <= 90) {
                return b - 65;
            }
            throw new InvalidBase64Character(b);
        }
        if (b >= 48) {
            if (b <= 57) {
                return b - 48 + 52;
            }
            if (b == 61) {
                return 64;
            }
            throw new InvalidBase64Character(b);
        }
        if (b == this.char62) {
            return 62;
        }
        if (b == this.char63) {
            return 63;
        }
        throw new InvalidBase64Character(b);
    }

    public int decode4Bytes(byte[] inputBuffer, int inputOffset, byte[] outputBuffer, int outputOffset) throws EncodingException {
        int v1 = this.decodeChar(inputBuffer[inputOffset]);
        int v2 = this.decodeChar(inputBuffer[inputOffset + 1]);
        int v3 = this.decodeChar(inputBuffer[inputOffset + 2]);
        outputBuffer[outputOffset] = (byte)(v1 << 2 | v2 >>> 4);
        if (v3 == 64) {
            return 1;
        }
        int v4 = this.decodeChar(inputBuffer[inputOffset + 3]);
        outputBuffer[outputOffset + 1] = (byte)((v2 & 0xF) << 4 | v3 >>> 2);
        if (v4 == 64) {
            return 2;
        }
        outputBuffer[outputOffset + 2] = (byte)((v3 & 3) << 6 | v4);
        return 3;
    }

    public int decode4Bytes(Bytes.Readable inputBuffer, byte[] outputBuffer, int outputOffset) throws EncodingException {
        int v1 = this.decodeChar(inputBuffer.get());
        int v2 = this.decodeChar(inputBuffer.get());
        int v3 = this.decodeChar(inputBuffer.get());
        outputBuffer[outputOffset] = (byte)(v1 << 2 | v2 >>> 4);
        if (v3 == 64) {
            if (inputBuffer.hasRemaining() && inputBuffer.getForward(0) == 61) {
                inputBuffer.moveForward(1);
            }
            return 1;
        }
        int v4 = this.decodeChar(inputBuffer.get());
        outputBuffer[outputOffset + 1] = (byte)((v2 & 0xF) << 4 | v3 >>> 2);
        if (v4 == 64) {
            return 2;
        }
        outputBuffer[outputOffset + 2] = (byte)((v3 & 3) << 6 | v4);
        return 3;
    }

    public int decode4Bytes(byte[] inputBuffer, int inputOffset, Bytes.Writable outputBuffer) throws EncodingException {
        int v1 = this.decodeChar(inputBuffer[inputOffset]);
        int v2 = this.decodeChar(inputBuffer[inputOffset + 1]);
        int v3 = this.decodeChar(inputBuffer[inputOffset + 2]);
        outputBuffer.put((byte)(v1 << 2 | v2 >>> 4));
        if (v3 == 64) {
            return 1;
        }
        int v4 = this.decodeChar(inputBuffer[inputOffset + 3]);
        outputBuffer.put((byte)((v2 & 0xF) << 4 | v3 >>> 2));
        if (v4 == 64) {
            return 2;
        }
        outputBuffer.put((byte)((v3 & 3) << 6 | v4));
        return 3;
    }

    public int decode4Bytes(Bytes.Readable inputBuffer, Bytes.Writable outputBuffer) throws EncodingException {
        int v1 = this.decodeChar(inputBuffer.get());
        int v2 = this.decodeChar(inputBuffer.get());
        int v3 = this.decodeChar(inputBuffer.get());
        outputBuffer.put((byte)(v1 << 2 | v2 >>> 4));
        if (v3 == 64) {
            if (inputBuffer.hasRemaining() && inputBuffer.getForward(0) == 61) {
                inputBuffer.moveForward(1);
            }
            return 1;
        }
        int v4 = this.decodeChar(inputBuffer.get());
        outputBuffer.put((byte)((v2 & 0xF) << 4 | v3 >>> 2));
        if (v4 == 64) {
            return 2;
        }
        outputBuffer.put((byte)((v3 & 3) << 6 | v4));
        return 3;
    }

    @Override
    public byte[] decode(byte[] input, int offset, int length) throws EncodingException {
        int outLen;
        if (length == 0) {
            return new byte[0];
        }
        int nbBlocks = length / 4;
        int lastBlock = length % 4;
        if (lastBlock == 0) {
            outLen = nbBlocks * 3;
            if (input[offset + nbBlocks * 4 - 1] == 61) {
                outLen = input[offset + nbBlocks * 4 - 2] == 61 ? (outLen -= 2) : --outLen;
            }
        } else if (lastBlock == 3) {
            if (input[offset + nbBlocks * 4 + 2] != 61) {
                throw new UnexpectedEndOfEncodedData();
            }
            outLen = nbBlocks * 3 + 1;
            ++nbBlocks;
        } else {
            throw new UnexpectedEndOfEncodedData();
        }
        byte[] decoded = new byte[outLen];
        int pos = 0;
        int i = 0;
        while (i < nbBlocks) {
            this.decode4Bytes(input, offset + i * 4, decoded, pos);
            ++i;
            pos += 3;
        }
        return decoded;
    }

    @Override
    public byte[] decode(Bytes.Readable input) throws EncodingException {
        int outLen;
        int length = input.remaining();
        if (length == 0) {
            return new byte[0];
        }
        int nbBlocks = length / 4;
        int lastBlock = length % 4;
        if (lastBlock == 0) {
            outLen = nbBlocks * 3;
            if (input.getForward(nbBlocks * 4 - 1) == 61) {
                outLen = input.getForward(nbBlocks * 4 - 2) == 61 ? (outLen -= 2) : --outLen;
            }
        } else if (lastBlock == 3) {
            if (input.getForward(nbBlocks * 4 + 2) != 61) {
                throw new UnexpectedEndOfEncodedData();
            }
            outLen = nbBlocks * 3 + 1;
            ++nbBlocks;
        } else {
            throw new UnexpectedEndOfEncodedData();
        }
        byte[] decoded = new byte[outLen];
        int pos = 0;
        int i = 0;
        while (i < nbBlocks) {
            this.decode4Bytes(input, decoded, pos);
            ++i;
            pos += 3;
        }
        return decoded;
    }

    @Override
    public void decode(Bytes.Readable input, Bytes.Writable output, boolean end) throws EncodingException {
        int l = Math.min(input.remaining() / 4, output.remaining() / 3);
        for (int i = 0; i < l; ++i) {
            this.decode4Bytes(input, output);
        }
        if (end) {
            int remDec;
            int remIn = input.remaining();
            if (remIn == 0) {
                return;
            }
            if (remIn < 3) {
                throw new UnexpectedEndOfEncodedData();
            }
            if (!output.hasRemaining()) {
                return;
            }
            if (input.getForward(2) == 61) {
                remDec = 1;
            } else if (remIn >= 4) {
                remDec = input.getForward(3) == 61 ? 2 : 3;
            } else {
                throw new UnexpectedEndOfEncodedData();
            }
            if (remDec > output.remaining()) {
                return;
            }
            this.decode4Bytes(input, output);
        }
    }

    @Override
    public <TError extends Exception> AsyncConsumer<Bytes.Readable, TError> createDecoderConsumer(AsyncConsumer<Bytes.Readable, TError> decodedConsumer, Function<EncodingException, TError> errorConverter) {
        return new DecoderConsumer<TError>(decodedConsumer, errorConverter);
    }

    public void encode3Bytes(byte[] inputBuffer, int inputBufferOffset, byte[] outputBuffer, int outputBufferOffset) {
        outputBuffer[outputBufferOffset + 0] = this.encodeSafe((inputBuffer[inputBufferOffset + 0] & 0xFC) >> 2);
        outputBuffer[outputBufferOffset + 1] = this.encodeSafe((inputBuffer[inputBufferOffset + 0] & 3) << 4 | (inputBuffer[inputBufferOffset + 1] & 0xF0) >> 4);
        outputBuffer[outputBufferOffset + 2] = this.encodeSafe((inputBuffer[inputBufferOffset + 1] & 0xF) << 2 | (inputBuffer[inputBufferOffset + 2] & 0xC0) >> 6);
        outputBuffer[outputBufferOffset + 3] = this.encodeSafe(inputBuffer[inputBufferOffset + 2] & 0x3F);
    }

    public void encode3Bytes(Bytes.Readable inputBuffer, byte[] outputBuffer, int outputBufferOffset) {
        byte b = inputBuffer.get();
        outputBuffer[outputBufferOffset + 0] = this.encodeSafe((b & 0xFC) >> 2);
        int n = (b & 3) << 4;
        b = inputBuffer.get();
        outputBuffer[outputBufferOffset + 1] = this.encodeSafe(n | (b & 0xF0) >> 4);
        int n2 = (b & 0xF) << 2;
        b = inputBuffer.get();
        outputBuffer[outputBufferOffset + 2] = this.encodeSafe(n2 | (b & 0xC0) >> 6);
        outputBuffer[outputBufferOffset + 3] = this.encodeSafe(b & 0x3F);
    }

    public void encode3Bytes(Bytes.Readable inputBuffer, Bytes.Writable outputBuffer) {
        byte b = inputBuffer.get();
        outputBuffer.put(this.encodeSafe((b & 0xFC) >> 2));
        int n = (b & 3) << 4;
        b = inputBuffer.get();
        outputBuffer.put(this.encodeSafe(n | (b & 0xF0) >> 4));
        int n2 = (b & 0xF) << 2;
        b = inputBuffer.get();
        outputBuffer.put(this.encodeSafe(n2 | (b & 0xC0) >> 6));
        outputBuffer.put(this.encodeSafe(b & 0x3F));
    }

    public void encodeUpTo3Bytes(byte[] inputBuffer, int inputBufferOffset, byte[] outputBuffer, int outputBufferOffset, int nbInput) {
        outputBuffer[outputBufferOffset + 0] = this.encodeSafe((inputBuffer[inputBufferOffset + 0] & 0xFC) >> 2);
        if (nbInput == 1) {
            outputBuffer[outputBufferOffset + 1] = this.encodeSafe((inputBuffer[inputBufferOffset + 0] & 3) << 4);
            outputBuffer[outputBufferOffset + 2] = 61;
            outputBuffer[outputBufferOffset + 3] = 61;
            return;
        }
        outputBuffer[outputBufferOffset + 1] = this.encodeSafe((inputBuffer[inputBufferOffset + 0] & 3) << 4 | (inputBuffer[inputBufferOffset + 1] & 0xF0) >> 4);
        if (nbInput == 2) {
            outputBuffer[outputBufferOffset + 2] = this.encodeSafe((inputBuffer[inputBufferOffset + 1] & 0xF) << 2);
            outputBuffer[outputBufferOffset + 3] = 61;
            return;
        }
        outputBuffer[outputBufferOffset + 2] = this.encodeSafe((inputBuffer[inputBufferOffset + 1] & 0xF) << 2 | (inputBuffer[inputBufferOffset + 2] & 0xC0) >> 6);
        outputBuffer[outputBufferOffset + 3] = this.encodeSafe(inputBuffer[inputBufferOffset + 2] & 0x3F);
    }

    public void encodeUpTo3Bytes(Bytes.Readable inputBuffer, byte[] outputBuffer, int outputBufferOffset) {
        int nbInput = inputBuffer.remaining();
        byte b = inputBuffer.get();
        outputBuffer[outputBufferOffset + 0] = this.encodeSafe((b & 0xFC) >> 2);
        if (nbInput == 1) {
            outputBuffer[outputBufferOffset + 1] = this.encodeSafe((b & 3) << 4);
            outputBuffer[outputBufferOffset + 2] = 61;
            outputBuffer[outputBufferOffset + 3] = 61;
            return;
        }
        int n = (b & 3) << 4;
        b = inputBuffer.get();
        outputBuffer[outputBufferOffset + 1] = this.encodeSafe(n | (b & 0xF0) >> 4);
        if (nbInput == 2) {
            outputBuffer[outputBufferOffset + 2] = this.encodeSafe((b & 0xF) << 2);
            outputBuffer[outputBufferOffset + 3] = 61;
            return;
        }
        int n2 = (b & 0xF) << 2;
        b = inputBuffer.get();
        outputBuffer[outputBufferOffset + 2] = this.encodeSafe(n2 | (b & 0xC0) >> 6);
        outputBuffer[outputBufferOffset + 3] = this.encodeSafe(b & 0x3F);
    }

    public void encodeUpTo3Bytes(Bytes.Readable inputBuffer, Bytes.Writable outputBuffer) {
        int nbInput = inputBuffer.remaining();
        byte b = inputBuffer.get();
        outputBuffer.put(this.encodeSafe((b & 0xFC) >> 2));
        if (nbInput == 1) {
            outputBuffer.put(this.encodeSafe((b & 3) << 4));
            outputBuffer.put((byte)61);
            outputBuffer.put((byte)61);
            return;
        }
        int n = (b & 3) << 4;
        b = inputBuffer.get();
        outputBuffer.put(this.encodeSafe(n | (b & 0xF0) >> 4));
        if (nbInput == 2) {
            outputBuffer.put(this.encodeSafe((b & 0xF) << 2));
            outputBuffer.put((byte)61);
            return;
        }
        int n2 = (b & 0xF) << 2;
        b = inputBuffer.get();
        outputBuffer.put(this.encodeSafe(n2 | (b & 0xC0) >> 6));
        outputBuffer.put(this.encodeSafe(b & 0x3F));
    }

    private byte encodeSafe(int v) {
        if (v <= 25) {
            return (byte)(v + 65);
        }
        if (v <= 51) {
            return (byte)(v - 26 + 97);
        }
        if (v <= 61) {
            return (byte)(v - 52 + 48);
        }
        if (v == 62) {
            return this.char62;
        }
        if (v == 63) {
            return this.char63;
        }
        return 0;
    }

    public byte encode(int v) throws EncodingException {
        if (v < 0) {
            throw new InvalidBase64Value(v);
        }
        byte b = this.encodeSafe(v);
        if (b == 0) {
            throw new InvalidBase64Value(v);
        }
        return b;
    }

    @Override
    public byte[] encode(byte[] input) {
        return this.encode(input, 0, input.length);
    }

    @Override
    public byte[] encode(byte[] input, int offset, int len) {
        int nb = len / 3;
        if (len % 3 > 0) {
            ++nb;
        }
        byte[] output = new byte[nb *= 4];
        int pos = 0;
        while (len >= 3) {
            this.encode3Bytes(input, offset, output, pos);
            offset += 3;
            len -= 3;
            pos += 4;
        }
        if (len > 0) {
            this.encodeUpTo3Bytes(input, offset, output, pos, len);
        }
        return output;
    }

    @Override
    public byte[] encode(Bytes.Readable input) {
        int len = input.remaining();
        int nb = len / 3;
        if (len % 3 > 0) {
            ++nb;
        }
        byte[] output = new byte[nb *= 4];
        int pos = 0;
        while (len >= 3) {
            this.encode3Bytes(input, output, pos);
            len -= 3;
            pos += 4;
        }
        if (len > 0) {
            this.encodeUpTo3Bytes(input, output, pos);
        }
        return output;
    }

    @Override
    public int encode(byte[] input, int offset, int length, Bytes.Writable output, boolean end) {
        ByteArray in = new ByteArray(input, offset, length);
        this.encode(in, output, end);
        return in.position();
    }

    @Override
    public void encode(Bytes.Readable input, Bytes.Writable output, boolean end) {
        int l = Math.min(input.remaining() / 3, output.remaining() / 4);
        for (int i = 0; i < l; ++i) {
            this.encode3Bytes(input, output);
        }
        if (end && input.hasRemaining() && output.remaining() >= 4) {
            this.encodeUpTo3Bytes(input, output);
        }
    }

    @Override
    public <TError extends Exception> AsyncConsumer<Bytes.Readable, TError> createEncoderConsumer(AsyncConsumer<Bytes.Readable, TError> encodedConsumer, Function<EncodingException, TError> errorConverter) {
        return new EncoderConsumer<TError>(encodedConsumer);
    }

    public <TError extends Exception> AsyncConsumer<Bytes.Readable, TError> createEncoderConsumer(AsyncConsumer<Bytes.Readable, TError> encodedConsumer) {
        return new EncoderConsumer<TError>(encodedConsumer);
    }

    public class DecoderConsumer<TError extends Exception>
    implements AsyncConsumer<Bytes.Readable, TError> {
        private ByteArrayCache cache;
        private AsyncConsumer<Bytes.Readable, TError> decodedBytesConsumer;
        private Function<EncodingException, TError> errorConverter;
        private byte[] buf = new byte[4];
        private int nbBuf = 0;

        public DecoderConsumer(AsyncConsumer<Bytes.Readable, TError> decodedBytesConsumer, Function<EncodingException, TError> errorConverter) {
            this.cache = ByteArrayCache.getInstance();
            this.decodedBytesConsumer = decodedBytesConsumer;
            this.errorConverter = errorConverter;
        }

        @Override
        public IAsync<TError> consume(Bytes.Readable data) {
            ByteArray.Writable output = null;
            try {
                int nb;
                if (this.nbBuf != 0) {
                    do {
                        this.buf[this.nbBuf++] = data.get();
                    } while (this.nbBuf < 4 && data.hasRemaining());
                    if (this.nbBuf < 4) {
                        data.free();
                        return new Async<boolean>(true);
                    }
                    nb = data.remaining() / 4;
                    output = new ByteArray.Writable((byte[])this.cache.get((nb + 1) * 3, true), true);
                    Base64Encoding.this.decode4Bytes(this.buf, 0, output);
                    this.nbBuf = 0;
                } else {
                    nb = data.remaining() / 4;
                    if (nb > 0) {
                        output = new ByteArray.Writable((byte[])this.cache.get(nb * 3, true), true);
                    }
                }
                if (nb > 0) {
                    Base64Encoding.this.decode(data, output, false);
                }
            }
            catch (EncodingException e) {
                EncodingException err = this.errorConverter != null ? (Exception)this.errorConverter.apply(e) : e;
                this.decodedBytesConsumer.error(err);
                return new Async<EncodingException>(err);
            }
            this.nbBuf = data.remaining();
            if (this.nbBuf != 0) {
                data.get(this.buf, 0, this.nbBuf);
            }
            data.free();
            if (output == null) {
                return new Async<boolean>(true);
            }
            output.flip();
            return this.decodedBytesConsumer.consume(output);
        }

        @Override
        public IAsync<TError> end() {
            if (this.nbBuf != 0) {
                UnexpectedEndOfEncodedData e = new UnexpectedEndOfEncodedData();
                UnexpectedEndOfEncodedData err = this.errorConverter != null ? (Exception)this.errorConverter.apply(e) : e;
                this.decodedBytesConsumer.error(err);
                return new Async<UnexpectedEndOfEncodedData>(err);
            }
            return this.decodedBytesConsumer.end();
        }

        @Override
        public void error(TError error) {
            this.decodedBytesConsumer.error(error);
        }
    }

    public class EncoderConsumer<TError extends Exception>
    implements AsyncConsumer<Bytes.Readable, TError> {
        private ByteArrayCache cache;
        private AsyncConsumer<Bytes.Readable, TError> encodedBytesConsumer;
        private byte[] buf = new byte[3];
        private int nbBuf = 0;

        public EncoderConsumer(AsyncConsumer<Bytes.Readable, TError> encodedBytesConsumer) {
            this.cache = ByteArrayCache.getInstance();
            this.encodedBytesConsumer = encodedBytesConsumer;
        }

        @Override
        public IAsync<TError> consume(Bytes.Readable data) {
            ByteArray.Writable output;
            if (this.nbBuf != 0) {
                do {
                    this.buf[this.nbBuf++] = data.get();
                } while (this.nbBuf < 3 && data.hasRemaining());
                if (this.nbBuf < 3) {
                    data.free();
                    return new Async<boolean>(true);
                }
                int nb = data.remaining() / 3 + 1;
                output = new ByteArray.Writable((byte[])this.cache.get(nb * 4, true), true);
                Base64Encoding.this.encode(this.buf, 0, 3, output, false);
                this.nbBuf = 0;
            } else {
                int nb = data.remaining() / 3;
                output = new ByteArray.Writable((byte[])this.cache.get(nb * 4, true), true);
            }
            Base64Encoding.this.encode(data, output, false);
            this.nbBuf = data.remaining();
            if (this.nbBuf != 0) {
                data.get(this.buf, 0, this.nbBuf);
            }
            data.free();
            output.flip();
            return this.encodedBytesConsumer.consume(output);
        }

        @Override
        public IAsync<TError> end() {
            if (this.nbBuf == 0) {
                return this.encodedBytesConsumer.end();
            }
            byte[] out = new byte[4];
            Base64Encoding.this.encodeUpTo3Bytes(this.buf, 0, out, 0, this.nbBuf);
            Async result = new Async();
            this.encodedBytesConsumer.consume(new ByteArray(out)).onDone(() -> this.encodedBytesConsumer.end().onDone(result), result);
            return result;
        }

        @Override
        public void error(TError error) {
            this.encodedBytesConsumer.error(error);
        }
    }

    public static final class InvalidBase64Value
    extends EncodingException {
        private static final long serialVersionUID = 1L;

        public InvalidBase64Value(int value) {
            super("Invalid base 64 value: " + value);
        }
    }

    public static final class InvalidBase64Character
    extends EncodingException {
        private static final long serialVersionUID = 1L;

        public InvalidBase64Character(byte b) {
            super("Invalid base 64 character: " + (b & 0xFF));
        }
    }
}

