/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.encoding.charset;

import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.encoding.charset.CharacterDecoderFromCharsetDecoder;
import net.lecousin.framework.encoding.charset.Iso8859Decoder;
import net.lecousin.framework.encoding.charset.UTF8Decoder;
import net.lecousin.framework.encoding.charset.UsAsciiDecoder;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.io.data.Chars;
import net.lecousin.framework.text.CharArrayStringBuffer;

public interface CharacterDecoder {
    public static CharacterDecoder get(Charset charset, int bufferSize) {
        Constructor ctor = (Constructor)Registry.decoders.get(charset.name());
        if (ctor != null) {
            try {
                return (CharacterDecoder)ctor.newInstance(bufferSize);
            }
            catch (Exception e) {
                LCCore.getApplication().getDefaultLogger().error("Unable to instantiate character decoder " + ctor, e);
            }
        }
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        return new CharacterDecoderFromCharsetDecoder(decoder, bufferSize);
    }

    public Charset getEncoding();

    public Chars.Readable decode(Bytes.Readable var1);

    public Chars.Readable flush();

    default public <TError extends Exception> AsyncConsumer<Bytes.Readable, TError> createConsumer(final AsyncConsumer<Chars.Readable, TError> charsConsumer) {
        return new AsyncConsumer<Bytes.Readable, TError>(){

            @Override
            public IAsync<TError> consume(Bytes.Readable data) {
                return charsConsumer.consume(CharacterDecoder.this.decode(data));
            }

            @Override
            public IAsync<TError> end() {
                Chars.Readable chars = CharacterDecoder.this.flush();
                if (chars == null) {
                    return charsConsumer.end();
                }
                Async result = new Async();
                charsConsumer.consume(chars).onDone(() -> charsConsumer.end().onDone(result), result);
                return result;
            }

            @Override
            public void error(TError error) {
                charsConsumer.error(error);
            }
        };
    }

    default public <TError extends Exception> AsyncConsumer<Bytes.Readable, TError> decodeConsumerToString(final Consumer<String> onEnd) {
        return new AsyncConsumer<Bytes.Readable, TError>(){
            private CharArrayStringBuffer str = new CharArrayStringBuffer();

            @Override
            public IAsync<TError> consume(Bytes.Readable data) {
                Chars.Readable chars = CharacterDecoder.this.decode(data);
                chars.get(this.str, chars.remaining());
                return new Async<boolean>(true);
            }

            @Override
            public IAsync<TError> end() {
                Chars.Readable chars = CharacterDecoder.this.flush();
                if (chars != null) {
                    chars.get(this.str, chars.remaining());
                }
                onEnd.accept(this.str.toString());
                return new Async<boolean>(true);
            }

            @Override
            public void error(TError error) {
            }
        };
    }

    public static final class Registry {
        private static Map<String, Constructor<? extends CharacterDecoder>> decoders = new HashMap<String, Constructor<? extends CharacterDecoder>>();

        private Registry() {
        }

        public static void register(Charset charset, Class<? extends CharacterDecoder> decoder) throws NoSuchMethodException {
            decoders.put(charset.name(), decoder.getConstructor(Integer.TYPE));
        }

        static {
            try {
                Registry.register(StandardCharsets.UTF_8, UTF8Decoder.class);
                Registry.register(StandardCharsets.US_ASCII, UsAsciiDecoder.class);
                Registry.register(StandardCharsets.ISO_8859_1, Iso8859Decoder.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

