/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.encoding.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import net.lecousin.framework.encoding.charset.CharacterDecoder;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.io.data.CharArray;
import net.lecousin.framework.io.data.Chars;
import net.lecousin.framework.io.data.CompositeChars;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.memory.CharArrayCache;

public class CharacterDecoderFromCharsetDecoder
implements CharacterDecoder {
    private CharsetDecoder decoder;
    private int bufferSize;
    private byte[] remainingBytes;
    private int nbRemaining;

    public CharacterDecoderFromCharsetDecoder(CharsetDecoder decoder, int bufferSize) {
        this.decoder = decoder;
        this.bufferSize = bufferSize;
    }

    @Override
    public Chars.Readable decode(Bytes.Readable input) {
        CoderResult res;
        ByteBuffer in;
        CompositeChars.Readable result = new CompositeChars.Readable();
        CharBuffer out = CharBuffer.wrap((char[])CharArrayCache.getInstance().get(this.bufferSize, true));
        if (this.remainingBytes != null) {
            block6: {
                do {
                    this.remainingBytes[this.nbRemaining++] = input.get();
                    in = ByteBuffer.wrap(this.remainingBytes, 0, this.nbRemaining);
                    res = this.decoder.decode(in, out, false);
                    if (!res.isUnderflow()) break block6;
                    if (in.position() <= 0) continue;
                    this.nbRemaining = in.remaining();
                    System.arraycopy(this.remainingBytes, in.position(), this.remainingBytes, 0, this.nbRemaining);
                } while (input.hasRemaining());
                input.free();
                if (out.position() > 0) {
                    result.add(new CharArray.Writable(out.array(), 0, out.position(), true));
                }
                return result;
            }
            ByteArrayCache.getInstance().free(this.remainingBytes);
            this.remainingBytes = null;
        }
        in = input.toByteBuffer();
        while (true) {
            res = this.decoder.decode(in, out, false);
            if (out.position() > 0) {
                result.add(new CharArray.Writable(out.array(), out.arrayOffset(), out.position(), true));
            }
            if (!res.isOverflow()) break;
            out = CharBuffer.wrap((char[])CharArrayCache.getInstance().get(this.bufferSize, true));
        }
        if (in.hasRemaining()) {
            this.remainingBytes = (byte[])ByteArrayCache.getInstance().get(32, true);
            this.nbRemaining = in.remaining();
            in.get(this.remainingBytes, 0, this.nbRemaining);
        }
        input.goToEnd();
        input.free();
        return result.getWrappedBuffers().size() == 1 ? (Chars.Readable)result.getWrappedBuffers().get(0) : result;
    }

    @Override
    public Chars.Readable flush() {
        if (this.remainingBytes == null) {
            this.decoder.reset();
            return null;
        }
        CharBuffer out = CharBuffer.allocate(8);
        this.decoder.decode(ByteBuffer.wrap(this.remainingBytes, 0, this.nbRemaining), out, true);
        this.decoder.reset();
        this.remainingBytes = null;
        this.nbRemaining = 0;
        if (out.position() == 0) {
            return null;
        }
        return new CharArray(out.array(), 0, out.position());
    }

    @Override
    public Charset getEncoding() {
        return this.decoder.charset();
    }
}

