/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.encoding.charset;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.lecousin.framework.encoding.charset.CharacterDecoder;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.io.data.CharArray;
import net.lecousin.framework.io.data.Chars;
import net.lecousin.framework.io.data.CharsFromIso8859Bytes;
import net.lecousin.framework.io.data.CompositeChars;
import net.lecousin.framework.memory.CharArrayCache;

public class UTF8Decoder
implements CharacterDecoder {
    private CharArrayCache cache;
    private int bufferSize;
    private CharArray.Writable buffer;
    private CharPusher charPusher;
    private int val = 0;
    private int state = 0;
    CompositeChars.Readable result;
    public static final char INVALID_CHAR = '\ufffd';

    public UTF8Decoder(int bufferSize) {
        this.bufferSize = Math.max(2, bufferSize);
        this.cache = CharArrayCache.getInstance();
        this.charPusher = new InitCharPusher();
    }

    @Override
    public Charset getEncoding() {
        return StandardCharsets.UTF_8;
    }

    @Override
    public Chars.Readable decode(Bytes.Readable input) {
        byte b;
        this.result = new CompositeChars.Readable();
        if (this.state != 0) {
            this.finishState(input);
            if (!input.hasRemaining()) {
                input.free();
                return this.result();
            }
        }
        boolean inputReused = false;
        while (input.remaining() >= 4) {
            byte b3;
            byte b2;
            b = input.get();
            if (b >= 0) {
                int endOfAscii;
                if (input.getForward(0) < 0) {
                    this.charPusher.push((char)b);
                    continue;
                }
                int r = input.remaining();
                for (endOfAscii = 1; endOfAscii < r && input.getForward(endOfAscii) >= 0; ++endOfAscii) {
                }
                if (endOfAscii >= 4 || endOfAscii == r) {
                    this.pushBuffer();
                    this.result.add(new CharsFromIso8859Bytes(input.subBuffer(input.position() - 1, endOfAscii + 1), false));
                    input.moveForward(endOfAscii);
                    inputReused = true;
                    continue;
                }
                this.charPusher.push((char)b);
                for (int i = 0; i < endOfAscii; ++i) {
                    this.charPusher.push((char)input.get());
                }
                continue;
            }
            if ((b & 0xE0) == 192) {
                b2 = input.get();
                if ((b2 & 0xC0) == 128) {
                    this.charPusher.push((char)((b & 0x1F) << 6 | b2 & 0x3F));
                    continue;
                }
                this.charPusher.push('\ufffd');
                continue;
            }
            if ((b & 0xF0) == 224) {
                b2 = input.get();
                b3 = input.get();
                if ((b2 & 0xC0) == 128 && (b3 & 0xC0) == 128) {
                    this.charPusher.push((char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F));
                    continue;
                }
                this.charPusher.push('\ufffd');
                continue;
            }
            if ((b & 0xF8) == 240) {
                b2 = input.get();
                b3 = input.get();
                byte b4 = input.get();
                if ((b2 & 0xC0) == 128 && (b3 & 0xC0) == 128 && (b4 & 0xC0) == 128) {
                    int v = (b & 7) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F;
                    int uuuuu = (v & 0x7C00) >> 10;
                    if (uuuuu > 16) {
                        this.charPusher.push('\ufffd');
                        continue;
                    }
                    int wwww = uuuuu - 1;
                    this.charPusher.push((char)(0xD800 | wwww << 6 | (v & 0x3C0) >> 4 | (v & 0x30) >> 4));
                    this.charPusher.push((char)(0xDC00 | (v & 0xF) << 6 | b4 & 0x3F));
                    continue;
                }
                this.charPusher.push('\ufffd');
                continue;
            }
            this.charPusher.push('\ufffd');
        }
        while (input.hasRemaining()) {
            if (this.state == 0) {
                b = input.get();
                if (b >= 0) {
                    this.charPusher.push((char)b);
                    continue;
                }
                if ((b & 0xE0) == 192) {
                    this.val = (b & 0x1F) << 6;
                    this.state = 1;
                    continue;
                }
                if ((b & 0xF0) == 224) {
                    this.val = (b & 0xF) << 12;
                    this.state = 2;
                    continue;
                }
                if ((b & 0xF8) == 240) {
                    this.val = (b & 7) << 12;
                    this.state = 4;
                    continue;
                }
                this.charPusher.push('\ufffd');
                continue;
            }
            this.finishState(input);
        }
        if (!inputReused) {
            input.free();
        } else {
            input.goToEnd();
        }
        return this.result();
    }

    private void pushBuffer() {
        if (this.buffer == null) {
            return;
        }
        int l = this.buffer.position();
        if (l > 0) {
            this.result.add(this.buffer.subBuffer(0, l));
            this.buffer.slice();
            this.charPusher = new BufferCharPusher();
        }
    }

    private Chars.Readable result() {
        this.pushBuffer();
        if (this.result.getWrappedBuffers().size() == 1) {
            return (Chars.Readable)this.result.getWrappedBuffers().get(0);
        }
        return this.result;
    }

    private void finishState(Bytes.Readable input) {
        switch (this.state) {
            case 1: 
            case 3: {
                this.finishState1or3(input);
                return;
            }
            case 2: {
                this.finishState2(input);
                return;
            }
            case 4: {
                this.finishState4(input);
                return;
            }
            case 5: {
                this.finishState5(input);
                return;
            }
        }
        this.finishState6(input);
    }

    private void finishState1or3(Bytes.Readable input) {
        byte b = input.get();
        if ((b & 0xC0) == 128) {
            this.charPusher.push((char)(this.val | b & 0x3F));
        } else {
            this.charPusher.push('\ufffd');
        }
        this.state = 0;
    }

    private void finishState2(Bytes.Readable input) {
        byte b = input.get();
        if ((b & 0xC0) == 128) {
            this.val |= (b & 0x3F) << 6;
            if (input.hasRemaining()) {
                this.finishState1or3(input);
            } else {
                this.state = 3;
            }
        } else {
            this.charPusher.push('\ufffd');
            this.state = 0;
        }
    }

    private void finishState4(Bytes.Readable input) {
        byte b = input.get();
        if ((b & 0xC0) == 128) {
            this.val |= (b & 0x3F) << 6;
            if (input.hasRemaining()) {
                this.finishState5(input);
            } else {
                this.state = 5;
            }
        } else {
            this.charPusher.push('\ufffd');
            this.state = 0;
        }
    }

    private void finishState5(Bytes.Readable input) {
        byte b = input.get();
        if ((b & 0xC0) == 128) {
            this.val |= b & 0x3F;
            if (input.hasRemaining()) {
                this.finishState6(input);
            } else {
                this.state = 6;
            }
        } else {
            this.charPusher.push('\ufffd');
            this.state = 0;
        }
    }

    private void finishState6(Bytes.Readable input) {
        byte b = input.get();
        if ((b & 0xC0) == 128) {
            int uuuuu = (this.val & 0x7C00) >> 10;
            if (uuuuu > 16) {
                this.charPusher.push('\ufffd');
            } else {
                int wwww = uuuuu - 1;
                this.charPusher.push((char)(0xD800 | wwww << 6 | (this.val & 0x3C0) >> 4 | (this.val & 0x30) >> 4));
                this.charPusher.push((char)(0xDC00 | (this.val & 0xF) << 6 | b & 0x3F));
            }
        } else {
            this.charPusher.push('\ufffd');
        }
        this.state = 0;
    }

    @Override
    public Chars.Readable flush() {
        this.result = null;
        this.charPusher = new InitCharPusher();
        this.buffer = null;
        if (this.state == 0) {
            return null;
        }
        this.state = 0;
        return new CharArray(new char[]{(char)this.val});
    }

    private class BufferCharPusher
    implements CharPusher {
        private BufferCharPusher() {
        }

        @Override
        public void push(char c) {
            UTF8Decoder.this.buffer.put(c);
            if (!UTF8Decoder.this.buffer.hasRemaining()) {
                UTF8Decoder.this.buffer.flip();
                UTF8Decoder.this.result.add(UTF8Decoder.this.buffer);
                UTF8Decoder.this.buffer = null;
                UTF8Decoder.this.charPusher = new InitCharPusher();
            }
        }
    }

    private class InitCharPusher
    implements CharPusher {
        private InitCharPusher() {
        }

        @Override
        public void push(char c) {
            UTF8Decoder.this.buffer = new CharArray.Writable((char[])UTF8Decoder.this.cache.get(UTF8Decoder.this.bufferSize, true), true);
            UTF8Decoder.this.buffer.put(c);
            UTF8Decoder.this.charPusher = new BufferCharPusher();
        }
    }

    private static interface CharPusher {
        public void push(char var1);
    }
}

