/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.tasks.drives.FileAccess;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;

public abstract class FileIO
extends ConcurrentCloseable<IOException>
implements IO.KnownSize {
    protected FileAccess file;
    protected long position = 0L;

    protected FileIO(File file, String mode, Task.Priority priority) {
        this.file = new FileAccess(file, mode, priority);
        this.file.getStartingTask().start();
    }

    public IAsync<IOException> canStart() {
        return this.file.getStartingTask().getOutput();
    }

    public File getFile() {
        return this.file.getFile();
    }

    @Override
    public String getSourceDescription() {
        return this.file.getPath();
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    public Task.Priority getPriority() {
        return this.file.getPriority();
    }

    @Override
    public void setPriority(Task.Priority priority) {
        this.file.setPriority(priority);
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getDrivesManager().getTaskManager(this.file.getFile());
    }

    protected long getPosition() {
        return this.position;
    }

    protected long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
        this.position = this.file.seek(type, move, false);
        return this.position;
    }

    protected AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
        return this.operation(this.file.seekAsync(type, move, false, res -> {
            if (res.getValue1() != null) {
                this.position = ((Long)res.getValue1()).intValue();
            }
            if (ondone != null) {
                ondone.accept((Pair<Long, IOException>)res);
            }
        }));
    }

    protected long skipSync(long n) throws IOException {
        long change = this.file.skip(n);
        this.position += change;
        return change;
    }

    protected AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        return this.operation(this.file.skipAsync(n, res -> {
            if (res.getValue1() != null) {
                this.position += (long)((Long)res.getValue1()).intValue();
            }
            if (ondone != null) {
                ondone.accept((Pair<Long, IOException>)res);
            }
        }));
    }

    @Override
    public long getSizeSync() throws IOException {
        return this.file.getSize();
    }

    @Override
    public AsyncSupplier<Long, IOException> getSizeAsync() {
        AsyncSupplier<Long, IOException> sp = new AsyncSupplier<Long, IOException>();
        this.file.getSize(sp);
        return this.operation(sp);
    }

    protected void setSizeSync(long size) throws IOException {
        this.file.setSize(size);
        if (this.position > size) {
            this.position = size;
        }
    }

    protected AsyncSupplier<Void, IOException> setSizeAsync(long size) {
        if (this.position > size) {
            this.position = size;
        }
        return this.operation(this.file.setSizeAsync(size));
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        return null;
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.file.closeAsync().onDone(ondone);
    }

    protected int readSync(ByteBuffer buffer) throws IOException {
        int nb = this.file.read(this.position, buffer);
        if (nb > 0) {
            this.position += (long)nb;
        }
        return nb;
    }

    protected int readSync(long pos, ByteBuffer buffer) throws IOException {
        return this.file.read(pos, buffer);
    }

    protected AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(this.file.readAsync(this.position, buffer, res -> {
            if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                this.position += (long)((Integer)res.getValue1()).intValue();
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)res);
            }
        }));
    }

    protected AsyncSupplier<Integer, IOException> readAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(this.file.readAsync(pos, buffer, ondone));
    }

    protected int readFullySync(ByteBuffer buffer) throws IOException {
        int nb = this.file.readFully(this.position, buffer);
        if (nb > 0) {
            this.position += (long)nb;
        }
        return nb;
    }

    protected int readFullySync(long pos, ByteBuffer buffer) throws IOException {
        return this.file.readFully(pos, buffer);
    }

    protected AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(this.file.readFullyAsync(this.position, buffer, res -> {
            if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                this.position += (long)((Integer)res.getValue1()).intValue();
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)res);
            }
        }));
    }

    protected AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(this.file.readFullyAsync(pos, buffer, ondone));
    }

    protected int writeSync(ByteBuffer buffer) throws IOException {
        int nb = this.file.write(this.position, buffer);
        if (nb > 0) {
            this.position += (long)nb;
        }
        return nb;
    }

    protected int writeSync(long pos, ByteBuffer buffer) throws IOException {
        return this.file.write(pos, buffer);
    }

    protected AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(this.file.writeAsync(this.position, buffer, res -> {
            if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                this.position += (long)((Integer)res.getValue1()).intValue();
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)res);
            }
        }));
    }

    protected AsyncSupplier<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(this.file.writeAsync(pos, buffer, ondone));
    }

    public static class ReadWrite
    extends FileIO
    implements IO.Readable.Seekable,
    IO.Writable.Seekable,
    IO.Resizable,
    IO.KnownSize {
        public ReadWrite(File file, Task.Priority priority) {
            super(file, "rw", priority);
        }

        @Override
        public IAsync<IOException> canStartReading() {
            return this.canStart();
        }

        @Override
        public IAsync<IOException> canStartWriting() {
            return this.canStart();
        }

        @Override
        public long getPosition() {
            return super.getPosition();
        }

        @Override
        public long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
            return super.seekSync(type, move);
        }

        @Override
        public AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
            return super.seekAsync(type, move, ondone);
        }

        @Override
        public long skipSync(long n) throws IOException {
            return super.skipSync(n);
        }

        @Override
        public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
            return super.skipAsync(n, ondone);
        }

        @Override
        public int readSync(ByteBuffer buffer) throws IOException {
            return super.readSync(buffer);
        }

        @Override
        public int readSync(long pos, ByteBuffer buffer) throws IOException {
            return super.readSync(pos, buffer);
        }

        @Override
        public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readAsync(buffer, ondone);
        }

        @Override
        public AsyncSupplier<Integer, IOException> readAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readAsync(pos, buffer, ondone);
        }

        @Override
        public int readFullySync(ByteBuffer buffer) throws IOException {
            return super.readFullySync(buffer);
        }

        @Override
        public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
            return super.readFullySync(pos, buffer);
        }

        @Override
        public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(buffer, ondone);
        }

        @Override
        public AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(pos, buffer, ondone);
        }

        @Override
        public int writeSync(ByteBuffer buffer) throws IOException {
            return super.writeSync(buffer);
        }

        @Override
        public int writeSync(long pos, ByteBuffer buffer) throws IOException {
            return super.writeSync(pos, buffer);
        }

        @Override
        public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(buffer, ondone);
        }

        @Override
        public AsyncSupplier<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(pos, buffer, ondone);
        }

        @Override
        public void setSizeSync(long newSize) throws IOException {
            super.setSizeSync(newSize);
        }

        @Override
        public AsyncSupplier<Void, IOException> setSizeAsync(long newSize) {
            return super.setSizeAsync(newSize);
        }
    }

    public static class WriteOnly
    extends FileIO
    implements IO.Writable.Seekable,
    IO.Resizable {
        public WriteOnly(File file, Task.Priority priority) {
            super(file, "rw", priority);
        }

        @Override
        public IAsync<IOException> canStartWriting() {
            return this.canStart();
        }

        @Override
        public long getPosition() {
            return super.getPosition();
        }

        @Override
        public void setSizeSync(long size) throws IOException {
            super.setSizeSync(size);
        }

        @Override
        public AsyncSupplier<Void, IOException> setSizeAsync(long size) {
            return super.setSizeAsync(size);
        }

        @Override
        public long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
            return super.seekSync(type, move);
        }

        @Override
        public AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
            return super.seekAsync(type, move, ondone);
        }

        @Override
        public int writeSync(ByteBuffer buffer) throws IOException {
            return super.writeSync(buffer);
        }

        @Override
        public int writeSync(long pos, ByteBuffer buffer) throws IOException {
            return super.writeSync(pos, buffer);
        }

        @Override
        public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(buffer, ondone);
        }

        @Override
        public AsyncSupplier<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(pos, buffer, ondone);
        }
    }

    public static class ReadOnly
    extends FileIO
    implements IO.Readable.Seekable {
        public ReadOnly(File file, Task.Priority priority) {
            super(file, "r", priority);
        }

        @Override
        public IAsync<IOException> canStartReading() {
            return this.canStart();
        }

        @Override
        public long getPosition() {
            return super.getPosition();
        }

        @Override
        public long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
            return super.seekSync(type, move);
        }

        @Override
        public AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
            return super.seekAsync(type, move, ondone);
        }

        @Override
        public long skipSync(long n) throws IOException {
            return super.skipSync(n);
        }

        @Override
        public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
            return super.skipAsync(n, ondone);
        }

        @Override
        public int readSync(ByteBuffer buffer) throws IOException {
            return super.readSync(buffer);
        }

        @Override
        public int readSync(long pos, ByteBuffer buffer) throws IOException {
            return super.readSync(pos, buffer);
        }

        @Override
        public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readAsync(buffer, ondone);
        }

        @Override
        public AsyncSupplier<Integer, IOException> readAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readAsync(pos, buffer, ondone);
        }

        @Override
        public int readFullySync(ByteBuffer buffer) throws IOException {
            return super.readFullySync(buffer);
        }

        @Override
        public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
            return super.readFullySync(pos, buffer);
        }

        @Override
        public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(buffer, ondone);
        }

        @Override
        public AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(pos, buffer, ondone);
        }
    }
}

