/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.math.RangeLong;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;

public abstract class FragmentedSubIO
extends ConcurrentCloseable<IOException>
implements IO.KnownSize,
IO.Seekable {
    protected IO.Seekable io;
    protected List<RangeLong> fragments;
    protected long pos = 0L;
    protected long size;
    protected boolean closeParentIOOnClose;
    protected String description;

    public FragmentedSubIO(IO.Seekable io, List<RangeLong> fragments, boolean closeParentIOOnClose, String description) {
        this.io = io;
        this.fragments = fragments;
        this.closeParentIOOnClose = closeParentIOOnClose;
        this.description = description;
        this.size = 0L;
        for (RangeLong r : fragments) {
            this.size += r.max - r.min + 1L;
        }
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        if (!this.closeParentIOOnClose) {
            return null;
        }
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.io = null;
        this.fragments = null;
        ondone.unblock();
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    public TaskManager getTaskManager() {
        return this.io.getTaskManager();
    }

    @Override
    public Task.Priority getPriority() {
        return this.io.getPriority();
    }

    @Override
    public void setPriority(Task.Priority priority) {
        this.io.setPriority(priority);
    }

    @Override
    public String getSourceDescription() {
        return this.description + " in " + this.io.getSourceDescription();
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public long getSizeSync() {
        return this.size;
    }

    @Override
    public AsyncSupplier<Long, IOException> getSizeAsync() {
        AsyncSupplier<Long, IOException> sp = new AsyncSupplier<Long, IOException>();
        sp.unblockSuccess(this.getSizeSync());
        return sp;
    }

    protected AsyncSupplier<Integer, IOException> readAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        Iterator<RangeLong> it = this.fragments.iterator();
        long p = 0L;
        while (it.hasNext()) {
            RangeLong r = it.next();
            long s = r.max - r.min + 1L;
            if (pos >= p + s) {
                p += s;
                continue;
            }
            long start = pos - p;
            int len = buffer.remaining();
            if (start + (long)len > s) {
                int prevLimit = buffer.limit();
                buffer.limit((int)((long)prevLimit - (start + (long)len - s)));
                return ((IO.Readable.Seekable)this.io).readAsync(r.min + start, buffer, param -> {
                    buffer.limit(prevLimit);
                    if (ondone != null) {
                        ondone.accept((Pair<Integer, IOException>)param);
                    }
                });
            }
            return this.operation(((IO.Readable.Seekable)this.io).readAsync(r.min + start, buffer, ondone));
        }
        AsyncSupplier<Integer, IOException> sp = new AsyncSupplier<Integer, IOException>();
        if (ondone != null) {
            ondone.accept(new Pair<Integer, Object>(0, null));
        }
        sp.unblockSuccess(0);
        return sp;
    }

    protected int readSync(long pos, ByteBuffer buffer) throws IOException {
        Iterator<RangeLong> it = this.fragments.iterator();
        long p = 0L;
        while (it.hasNext()) {
            RangeLong r = it.next();
            long s = r.max - r.min + 1L;
            if (pos >= p + s) {
                p += s;
                continue;
            }
            long start = pos - p;
            int len = buffer.remaining();
            if (start + (long)len > s) {
                int prevLimit = buffer.limit();
                buffer.limit((int)((long)prevLimit - (start + (long)len - s)));
                len = ((IO.Readable.Seekable)this.io).readSync(r.min + start, buffer);
                buffer.limit(prevLimit);
            } else {
                len = ((IO.Readable.Seekable)this.io).readSync(r.min + start, buffer);
            }
            return len;
        }
        return 0;
    }

    protected int readFullySync(long pos, ByteBuffer buffer) throws IOException {
        Iterator<RangeLong> it = this.fragments.iterator();
        long p = 0L;
        int done = 0;
        while (it.hasNext()) {
            RangeLong r = it.next();
            long s = r.max - r.min + 1L;
            if (pos >= p + s) {
                p += s;
                continue;
            }
            long start = pos - p;
            int len = buffer.remaining();
            if (start + (long)len > s) {
                int prevLimit = buffer.limit();
                buffer.limit((int)((long)prevLimit - (start + (long)len - s)));
                len = ((IO.Readable.Seekable)this.io).readFullySync(r.min + start, buffer);
                buffer.limit(prevLimit);
            } else {
                len = ((IO.Readable.Seekable)this.io).readFullySync(r.min + start, buffer);
            }
            done += len;
            if (!buffer.hasRemaining()) {
                return done;
            }
            pos += (long)len;
            p += s;
        }
        return done;
    }

    @Override
    public long seekSync(IO.Seekable.SeekType type, long move) {
        switch (type) {
            case FROM_BEGINNING: {
                this.pos = move;
                break;
            }
            case FROM_END: {
                this.pos = this.size - move;
                break;
            }
            default: {
                this.pos += move;
            }
        }
        if (this.pos > this.size) {
            this.pos = this.size;
        }
        if (this.pos < 0L) {
            this.pos = 0L;
        }
        return this.pos;
    }

    protected long skipSync(long n) {
        long siz = this.getSizeSync();
        long prevPos = this.pos;
        this.pos += n;
        if (this.pos > siz) {
            this.pos = siz;
        }
        if (this.pos < 0L) {
            this.pos = 0L;
        }
        return this.pos - prevPos;
    }

    @Override
    public AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
        AsyncSupplier<Long, IOException> sp = new AsyncSupplier<Long, IOException>();
        this.seekSync(type, move);
        if (ondone != null) {
            ondone.accept(new Pair<Long, Object>(this.pos, null));
        }
        sp.unblockSuccess(this.pos);
        return sp;
    }

    protected AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        AsyncSupplier<Long, IOException> sp = new AsyncSupplier<Long, IOException>();
        long skipped = this.skipSync(n);
        if (ondone != null) {
            ondone.accept(new Pair<Long, Object>(skipped, null));
        }
        sp.unblockSuccess(skipped);
        return sp;
    }

    protected IAsync<IOException> canStartWriting() {
        return ((IO.Writable)((Object)this.io)).canStartWriting();
    }

    protected int writeSync(long pos, ByteBuffer buffer) throws IOException {
        Iterator<RangeLong> it = this.fragments.iterator();
        long p = 0L;
        int total = 0;
        while (it.hasNext()) {
            RangeLong r = it.next();
            long s = r.max - r.min + 1L;
            if (pos >= p + s) {
                p += s;
                continue;
            }
            long start = pos - p;
            int len = buffer.remaining();
            if (start + (long)len > s) {
                int prevLimit = buffer.limit();
                buffer.limit((int)((long)prevLimit - (start + (long)len - s)));
                len = ((IO.Writable.Seekable)this.io).writeSync(r.min + start, buffer);
                buffer.limit(prevLimit);
            } else {
                len = ((IO.Writable.Seekable)this.io).writeSync(r.min + start, buffer);
            }
            total += len;
            pos += (long)len;
            p += s;
            if (buffer.hasRemaining()) continue;
            return total;
        }
        return total;
    }

    protected AsyncSupplier<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        Iterator<RangeLong> it = this.fragments.iterator();
        long p = 0L;
        while (it.hasNext()) {
            RangeLong r = it.next();
            long s = r.max - r.min + 1L;
            if (pos >= p + s) {
                p += s;
                continue;
            }
            AsyncSupplier<Integer, IOException> sp = new AsyncSupplier<Integer, IOException>();
            this.writeAsync(it, r, p, 0, pos, buffer, ondone, sp);
            return this.operation(sp);
        }
        AsyncSupplier<Integer, IOException> sp = new AsyncSupplier<Integer, IOException>();
        if (ondone != null) {
            ondone.accept(new Pair<Integer, Object>(0, null));
        }
        sp.unblockSuccess(0);
        return sp;
    }

    protected void writeAsync(Iterator<RangeLong> it, RangeLong r, long p, int done, long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone, AsyncSupplier<Integer, IOException> sp) {
        long s;
        long start = pos - p;
        int len = buffer.remaining();
        if (start + (long)len > (s = r.max - r.min + 1L)) {
            int prevLimit = buffer.limit();
            buffer.limit((int)((long)prevLimit - (start + (long)len - s)));
            IOUtil.listenOnDone(((IO.Writable.Seekable)this.io).writeAsync(r.min + start, buffer), nb -> {
                buffer.limit(prevLimit);
                int i = nb;
                if (!buffer.hasRemaining() || !it.hasNext()) {
                    IOUtil.success(i, sp, ondone);
                    return;
                }
                this.writeAsync(it, (RangeLong)it.next(), p + s, done + i, pos + (long)i, buffer, ondone, sp);
            }, sp, ondone);
            return;
        }
        IOUtil.listenOnDone(((IO.Writable.Seekable)this.io).writeAsync(r.min + start, buffer), nb -> IOUtil.success(nb + done, sp, ondone), sp, ondone);
    }

    public static class ReadWrite
    extends Readable
    implements IO.Writable.Seekable {
        public <T extends IO.Readable.Seekable & IO.Writable.Seekable> ReadWrite(T io, List<RangeLong> fragments, boolean closeParentIOOnClose, String description) {
            super(io, fragments, closeParentIOOnClose, description);
        }

        @Override
        public IAsync<IOException> canStartWriting() {
            return super.canStartWriting();
        }

        @Override
        public int writeSync(long pos, ByteBuffer buffer) throws IOException {
            return super.writeSync(pos, buffer);
        }

        @Override
        public int writeSync(ByteBuffer buffer) throws IOException {
            int nb = super.writeSync(this.pos, buffer);
            if (nb > 0) {
                this.pos += (long)nb;
            }
            return nb;
        }

        @Override
        public AsyncSupplier<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(pos, buffer, ondone);
        }

        @Override
        public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(this.pos, buffer, res -> {
                if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                    this.pos += (long)((Integer)res.getValue1()).intValue();
                }
                if (ondone != null) {
                    ondone.accept((Pair<Integer, IOException>)res);
                }
            });
        }
    }

    public static class Readable
    extends FragmentedSubIO
    implements IO.Readable.Seekable {
        public Readable(IO.Readable.Seekable io, List<RangeLong> fragments, boolean closeParentIOOnClose, String description) {
            super(io, fragments, closeParentIOOnClose, description);
        }

        @Override
        public IAsync<IOException> canStartReading() {
            return ((IO.Readable.Seekable)this.io).canStartReading();
        }

        @Override
        public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readAsync(this.pos, buffer, res -> {
                if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                    this.pos += (long)((Integer)res.getValue1()).intValue();
                }
                if (ondone != null) {
                    ondone.accept((Pair<Integer, IOException>)res);
                }
            });
        }

        @Override
        public AsyncSupplier<Integer, IOException> readAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readAsync(pos, buffer, ondone);
        }

        @Override
        public int readSync(ByteBuffer buffer) throws IOException {
            int nb = super.readSync(this.pos, buffer);
            if (nb > 0) {
                this.pos += (long)nb;
            }
            return nb;
        }

        @Override
        public int readSync(long pos, ByteBuffer buffer) throws IOException {
            return super.readSync(pos, buffer);
        }

        @Override
        public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
            return super.readFullySync(pos, buffer);
        }

        @Override
        public int readFullySync(ByteBuffer buffer) throws IOException {
            int nb = super.readFullySync(this.pos, buffer);
            if (nb > 0) {
                this.pos += (long)nb;
            }
            return nb;
        }

        @Override
        public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return this.readFullyAsync(this.pos, buffer, res -> {
                if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                    this.pos += (long)((Integer)res.getValue1()).intValue();
                }
                if (ondone != null) {
                    ondone.accept((Pair<Integer, IOException>)res);
                }
            });
        }

        @Override
        public AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return this.operation(IOUtil.readFullyAsync(this, pos, buffer, ondone));
        }

        @Override
        public long skipSync(long n) {
            return super.skipSync(n);
        }

        @Override
        public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
            return super.skipAsync(n, ondone);
        }
    }
}

