/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.io.AbstractIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.Pair;

public class IOFromInputStream
extends AbstractIO
implements IO.Readable {
    private InputStream stream;
    private TaskManager manager;

    public IOFromInputStream(InputStream stream, String sourceDescription, TaskManager manager, Task.Priority priority) {
        super(sourceDescription, priority);
        this.stream = stream;
        this.manager = manager;
    }

    @Override
    public IAsync<IOException> canStartReading() {
        return new Async<boolean>(true);
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    public TaskManager getTaskManager() {
        return this.manager;
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        return IOUtil.closeAsync(this.stream);
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.stream = null;
        ondone.unblock();
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        int nb = this.stream.read(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        if (nb >= 0) {
            buffer.position(buffer.position() + nb);
        }
        return nb;
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        int nb;
        int total = 0;
        while ((nb = this.stream.read(buffer.array(), buffer.arrayOffset() + buffer.position() + total, buffer.remaining() - total)) > 0 && (total += nb) < buffer.remaining()) {
        }
        buffer.position(buffer.position() + total);
        return total;
    }

    @Override
    public long skipSync(long n) throws IOException {
        int l;
        int nb;
        if (n <= 0L) {
            return 0L;
        }
        long total = 0L;
        byte[] b = new byte[n > 65536L ? 65536 : (int)n];
        while ((nb = this.stream.read(b, 0, l = n - total > 65536L ? 65536 : (int)(n - total))) > 0 && (total += (long)nb) < n) {
        }
        return total;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(new Task(this.manager, "Read from InputStream", this.priority, t -> {
            try {
                int nb = this.stream.read(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                if (nb >= 0) {
                    buffer.position(buffer.position() + nb);
                }
                return nb;
            }
            catch (IOException e) {
                if (this.isClosing() || this.isClosed()) {
                    throw IO.cancelClosed();
                }
                throw e;
            }
        }, ondone).start()).getOutput();
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(new Task(this.manager, "Read from InputStream", this.priority, t -> {
            int nb;
            int total = 0;
            do {
                if (this.isClosing() || this.isClosed()) {
                    throw IO.cancelClosed();
                }
                try {
                    nb = this.stream.read(buffer.array(), buffer.arrayOffset() + buffer.position() + total, buffer.remaining() - total);
                    if (nb <= 0) break;
                }
                catch (IOException e) {
                    if (this.isClosing() || this.isClosed()) {
                        throw IO.cancelClosed();
                    }
                    throw e;
                }
            } while ((total += nb) < buffer.remaining());
            buffer.position(buffer.position() + total);
            return total;
        }, ondone).start()).getOutput();
    }

    @Override
    public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        if (n <= 0L) {
            if (ondone != null) {
                ondone.accept(new Pair<Long, Object>(0L, null));
            }
            return new AsyncSupplier<Long, Object>(0L, null);
        }
        return this.operation(new Task(this.manager, "Skip from InputStream", this.priority, t -> {
            int l;
            int nb;
            long total = 0L;
            byte[] b = new byte[n > 65536L ? 65536 : (int)n];
            do {
                int n2 = l = n - total > 65536L ? 65536 : (int)(n - total);
                if (!this.isClosing() && !this.isClosed()) continue;
                throw IO.cancelClosed();
            } while ((nb = this.stream.read(b, 0, l)) > 0 && (total += (long)nb) < n);
            return total;
        }, ondone).start()).getOutput();
    }

    public static class KnownSize
    extends IOFromInputStream
    implements IO.KnownSize {
        private long size;

        public KnownSize(InputStream stream, long size, String sourceDescription, TaskManager manager, Task.Priority priority) {
            super(stream, sourceDescription, manager, priority);
            this.size = size;
        }

        @Override
        public long getSizeSync() {
            return this.size;
        }

        @Override
        public AsyncSupplier<Long, IOException> getSizeAsync() {
            return new AsyncSupplier<Long, Object>(this.size, null);
        }
    }
}

