/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.event.ListenableLongProperty;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;

public abstract class PositionKnownWrapper<IOType extends IO>
extends ConcurrentCloseable<IOException>
implements IO.PositionKnown {
    protected IOType io;
    protected ListenableLongProperty position;

    public PositionKnownWrapper(IOType io, long position) {
        this.io = io;
        this.position = new ListenableLongProperty(position);
    }

    public void addPositionChangedListener(Consumer<Long> listener) {
        this.position.addListener(listener);
    }

    public void addPositionChangedListener(Runnable listener) {
        this.position.addListener(listener);
    }

    public void removePositionChangedListener(Consumer<Long> listener) {
        this.position.removeListener(listener);
    }

    public void removePositionChangedListener(Runnable listener) {
        this.position.removeListener(listener);
    }

    @Override
    public String getSourceDescription() {
        return this.io.getSourceDescription();
    }

    @Override
    public IO getWrappedIO() {
        return this.io;
    }

    @Override
    public Task.Priority getPriority() {
        return this.io.getPriority();
    }

    @Override
    public void setPriority(Task.Priority priority) {
        this.io.setPriority(priority);
    }

    @Override
    public TaskManager getTaskManager() {
        return this.io.getTaskManager();
    }

    @Override
    public long getPosition() {
        return this.position.get();
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.io = null;
        ondone.unblock();
    }

    protected IAsync<IOException> canStartReading() {
        return ((IO.Readable)this.io).canStartReading();
    }

    protected int readSync(ByteBuffer buffer) throws IOException {
        int nb = ((IO.Readable)this.io).readSync(buffer);
        if (nb > 0) {
            this.position.add(nb);
        }
        return nb;
    }

    protected int readAsync() throws IOException {
        int c = ((IO.Readable.Buffered)this.io).readAsync();
        if (c >= 0) {
            this.position.inc();
        }
        return c;
    }

    protected AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return ((IO.Readable)this.io).readAsync(buffer, result -> {
            Integer nb = (Integer)result.getValue1();
            if (nb != null && nb > 0) {
                this.position.add(nb.longValue());
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)result);
            }
        });
    }

    protected int readFullySync(ByteBuffer buffer) throws IOException {
        int nb = ((IO.Readable)this.io).readFullySync(buffer);
        if (nb > 0) {
            this.position.add(nb);
        }
        return nb;
    }

    protected AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return ((IO.Readable)this.io).readFullyAsync(buffer, result -> {
            Integer nb = (Integer)result.getValue1();
            if (nb != null && nb > 0) {
                this.position.add(nb.intValue());
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)result);
            }
        });
    }

    protected long skipSync(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long skipped = ((IO.Readable)this.io).skipSync(n);
        this.position.add(skipped);
        return skipped;
    }

    protected AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        if (n <= 0L) {
            return IOUtil.success(0L, ondone);
        }
        return ((IO.Readable)this.io).skipAsync(n, result -> {
            Long nb = (Long)result.getValue1();
            if (nb != null) {
                this.position.add(nb);
            }
            if (ondone != null) {
                ondone.accept(result);
            }
        });
    }

    protected int read() throws IOException {
        int c = ((IO.Readable.Buffered)this.io).read();
        if (c >= 0) {
            this.position.inc();
        }
        return c;
    }

    protected int read(byte[] buffer, int offset, int len) throws IOException {
        int nb = ((IO.Readable.Buffered)this.io).read(buffer, offset, len);
        if (nb > 0) {
            this.position.add(nb);
        }
        return nb;
    }

    protected int readFully(byte[] buffer) throws IOException {
        int nb = ((IO.Readable.Buffered)this.io).readFully(buffer);
        if (nb > 0) {
            this.position.add(nb);
        }
        return nb;
    }

    protected int skip(int skip) throws IOException {
        int skipped = ((IO.Readable.Buffered)this.io).skip(skip);
        this.position.add(skipped);
        return skipped;
    }

    protected AsyncSupplier<ByteBuffer, IOException> readNextBufferAsync(Consumer<Pair<ByteBuffer, IOException>> ondone) {
        return ((IO.Readable.Buffered)this.io).readNextBufferAsync(result -> {
            ByteBuffer buf = (ByteBuffer)result.getValue1();
            if (buf != null) {
                this.position.add(buf.remaining());
            }
            if (ondone != null) {
                ondone.accept((Pair<ByteBuffer, IOException>)result);
            }
        });
    }

    protected ByteBuffer readNextBuffer() throws IOException {
        ByteBuffer buf = ((IO.Readable.Buffered)this.io).readNextBuffer();
        if (buf != null) {
            this.position.add(buf.remaining());
        }
        return buf;
    }

    protected AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        AsyncSupplier<Integer, IOException> res = new AsyncSupplier<Integer, IOException>();
        ((IO.Readable.Buffered)this.io).readFullySyncIfPossible(buffer, r -> {
            if (r.getValue1() != null) {
                this.position.add(((Integer)r.getValue1()).intValue());
            }
            if (ondone == null) {
                return;
            }
            ondone.accept((Pair<Integer, IOException>)r);
        }).onDone(res::unblockSuccess, res);
        return res;
    }

    public static class Readable
    extends PositionKnownWrapper<IO.Readable>
    implements IO.Readable,
    IO.PositionKnown {
        public Readable(IO.Readable io, long position) {
            super(io, position);
        }

        public Readable(IO.Readable io) {
            this(io, 0L);
        }

        @Override
        public IAsync<IOException> canStartReading() {
            return super.canStartReading();
        }

        @Override
        public int readSync(ByteBuffer buffer) throws IOException {
            return super.readSync(buffer);
        }

        @Override
        public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readAsync(buffer, ondone);
        }

        @Override
        public int readFullySync(ByteBuffer buffer) throws IOException {
            return super.readFullySync(buffer);
        }

        @Override
        public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(buffer, ondone);
        }

        @Override
        public long skipSync(long n) throws IOException {
            return super.skipSync(n);
        }

        @Override
        public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
            return super.skipAsync(n, ondone);
        }

        public static class Buffered
        extends PositionKnownWrapper<IO.Readable.Buffered>
        implements IO.Readable.Buffered,
        IO.PositionKnown {
            public Buffered(IO.Readable.Buffered io, long position) {
                super(io, position);
            }

            public Buffered(IO.Readable.Buffered io) {
                this(io, 0L);
            }

            @Override
            public IAsync<IOException> canStartReading() {
                return super.canStartReading();
            }

            @Override
            public int readSync(ByteBuffer buffer) throws IOException {
                return super.readSync(buffer);
            }

            @Override
            public int readAsync() throws IOException {
                return super.readAsync();
            }

            @Override
            public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
                return super.readAsync(buffer, ondone);
            }

            @Override
            public int readFullySync(ByteBuffer buffer) throws IOException {
                return super.readFullySync(buffer);
            }

            @Override
            public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
                return super.readFullyAsync(buffer, ondone);
            }

            @Override
            public long skipSync(long n) throws IOException {
                return super.skipSync(n);
            }

            @Override
            public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
                return super.skipAsync(n, ondone);
            }

            @Override
            public int read() throws IOException {
                return super.read();
            }

            @Override
            public int read(byte[] buffer, int offset, int len) throws IOException {
                return super.read(buffer, offset, len);
            }

            @Override
            public int readFully(byte[] buffer) throws IOException {
                return super.readFully(buffer);
            }

            @Override
            public int skip(int skip) throws IOException {
                return super.skip(skip);
            }

            @Override
            public AsyncSupplier<ByteBuffer, IOException> readNextBufferAsync(Consumer<Pair<ByteBuffer, IOException>> ondone) {
                return super.readNextBufferAsync(ondone);
            }

            @Override
            public ByteBuffer readNextBuffer() throws IOException {
                return super.readNextBuffer();
            }

            @Override
            public AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
                return super.readFullySyncIfPossible(buffer, ondone);
            }
        }
    }
}

