/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.bit;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.io.IO;

public interface BitIO
extends IO {

    public static interface Readable
    extends BitIO {
        public IAsync<IOException> canStartReading();

        public boolean readBoolean() throws IOException;

        public Boolean readBooleanIfAvailable() throws IOException;

        default public AsyncSupplier<Boolean, IOException> readBooleanAsync() {
            AsyncSupplier<Boolean, IOException> result = new AsyncSupplier<Boolean, IOException>();
            Consumer<AsyncSupplier<Boolean, IOException>> doIt = new Consumer<AsyncSupplier<Boolean, IOException>>(){

                @Override
                public void accept(AsyncSupplier<Boolean, IOException> result) {
                    try {
                        Boolean b = this.readBooleanIfAvailable();
                        if (b != null) {
                            result.unblockSuccess(b);
                            return;
                        }
                    }
                    catch (IOException e) {
                        result.error(e);
                        return;
                    }
                    this.canStartReading().onDone(() -> this.accept(result), result);
                }
            };
            doIt.accept(result);
            return result;
        }

        public long readBits(int var1) throws IOException;

        public long readBitsIfAvailable(int var1) throws IOException;

        default public AsyncSupplier<Long, IOException> readBitsAsync(int n) {
            AsyncSupplier<Long, IOException> result = new AsyncSupplier<Long, IOException>();
            BiConsumer<Integer, AsyncSupplier<Long, IOException>> doIt = new BiConsumer<Integer, AsyncSupplier<Long, IOException>>(){

                @Override
                public void accept(Integer n, AsyncSupplier<Long, IOException> result) {
                    try {
                        long val = this.readBitsIfAvailable(n);
                        if (val != -1L) {
                            result.unblockSuccess(val);
                            return;
                        }
                    }
                    catch (IOException e) {
                        result.error(e);
                        return;
                    }
                    this.canStartReading().onDone(() -> this.accept(n, result), result);
                }
            };
            doIt.accept(n, result);
            return result;
        }
    }

    public static interface LittleEndian
    extends BitIO {
    }

    public static interface BigEndian
    extends BitIO {
    }
}

