/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.bit;

import java.io.EOFException;
import java.io.IOException;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.bit.AbstractBitIO;
import net.lecousin.framework.io.bit.BitIO;

public abstract class SimpleReadableBitIO
extends AbstractBitIO<IO.Readable.Buffered>
implements BitIO.Readable {
    protected long currentValue;
    protected int currentNbBits = 0;
    protected boolean eof = false;

    protected SimpleReadableBitIO(IO.Readable.Buffered io) {
        super(io);
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    @Override
    public IAsync<IOException> canStartReading() {
        return ((IO.Readable.Buffered)this.io).canStartReading();
    }

    @Override
    public boolean readBoolean() throws IOException {
        if (this.currentNbBits == 0) {
            this.currentValue = ((IO.Readable.Buffered)this.io).read();
            if (this.currentValue == -1L) {
                this.eof = true;
                throw new EOFException();
            }
            this.currentNbBits = 7;
            return this.getBooleanValueFromByte();
        }
        return this.getNextBooleanValue();
    }

    @Override
    public Boolean readBooleanIfAvailable() throws IOException {
        if (this.currentNbBits == 0) {
            this.currentValue = ((IO.Readable.Buffered)this.io).readAsync();
            if (this.currentValue == -1L) {
                this.eof = true;
                throw new EOFException();
            }
            if (this.currentValue == -2L) {
                return null;
            }
            this.currentNbBits = 7;
            return this.getBooleanValueFromByte();
        }
        return this.getNextBooleanValue();
    }

    protected abstract boolean getBooleanValueFromByte();

    protected abstract boolean getNextBooleanValue();

    protected abstract long getRemainingBits();

    @Override
    public long readBits(int n) throws IOException {
        while (n >= this.currentNbBits) {
            if (n == this.currentNbBits) {
                long val = this.getRemainingBits();
                this.currentValue = 0L;
                this.currentNbBits = 0;
                return val;
            }
            if (this.eof) {
                throw new EOFException();
            }
            int b = ((IO.Readable.Buffered)this.io).read();
            if (b == -1) {
                this.eof = true;
                throw new EOFException();
            }
            this.pushNewByte(b);
            this.currentNbBits += 8;
        }
        return this.getNextBits(n);
    }

    @Override
    public long readBitsIfAvailable(int n) throws IOException {
        while (n >= this.currentNbBits) {
            if (n == this.currentNbBits) {
                long val = this.getRemainingBits();
                this.currentNbBits = 0;
                this.currentValue = 0L;
                return val;
            }
            if (this.eof) {
                throw new EOFException();
            }
            int b = ((IO.Readable.Buffered)this.io).readAsync();
            if (b == -2) {
                return -1L;
            }
            if (b == -1) {
                this.eof = true;
                throw new EOFException();
            }
            this.pushNewByte(b);
            this.currentNbBits += 8;
        }
        return this.getNextBits(n);
    }

    protected abstract long getNextBits(int var1);

    protected abstract void pushNewByte(int var1);

    public static class LittleEndian
    extends SimpleReadableBitIO
    implements BitIO.BigEndian {
        public LittleEndian(IO.Readable.Buffered io) {
            super(io);
        }

        @Override
        protected boolean getBooleanValueFromByte() {
            boolean value = (this.currentValue & 1L) != 0L;
            this.currentValue >>= 1;
            return value;
        }

        @Override
        protected boolean getNextBooleanValue() {
            boolean value = (this.currentValue & 1L) != 0L;
            this.currentValue >>= 1;
            --this.currentNbBits;
            return value;
        }

        @Override
        protected long getNextBits(int n) {
            long value = this.currentValue & (long)((1 << n) - 1);
            this.currentValue >>= n;
            this.currentNbBits -= n;
            return value;
        }

        @Override
        protected long getRemainingBits() {
            return this.currentValue;
        }

        @Override
        protected void pushNewByte(int b) {
            this.currentValue |= (long)(b << this.currentNbBits);
        }
    }

    public static class BigEndian
    extends SimpleReadableBitIO
    implements BitIO.BigEndian {
        public BigEndian(IO.Readable.Buffered io) {
            super(io);
        }

        @Override
        protected boolean getBooleanValueFromByte() {
            return (this.currentValue & 0x80L) != 0L;
        }

        @Override
        protected boolean getNextBooleanValue() {
            return (this.currentValue & (long)(1 << --this.currentNbBits)) != 0L;
        }

        @Override
        protected long getNextBits(int n) {
            long value = this.currentValue >> this.currentNbBits - n & (long)((1 << n) - 1);
            this.currentNbBits -= n;
            return value;
        }

        @Override
        protected long getRemainingBits() {
            return this.currentValue & (long)((1 << this.currentNbBits) - 1);
        }

        @Override
        protected void pushNewByte(int b) {
            this.currentValue = this.currentValue << 8 | (long)b;
        }
    }
}

