/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.IOException;
import java.io.InputStream;
import net.lecousin.framework.io.IO;

public class BufferedToInputStream
extends InputStream {
    private IO.Readable.Buffered io;
    private boolean closeAsync;

    public BufferedToInputStream(IO.Readable.Buffered io, boolean closeAsync) {
        this.io = io;
        this.closeAsync = closeAsync;
    }

    @Override
    public int read() throws IOException {
        return this.io.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nb = this.io.read(b, off, len);
        if (nb == 0 && len > 0) {
            return -1;
        }
        return nb;
    }

    @Override
    public void close() throws IOException {
        if (!this.closeAsync) {
            try {
                this.io.close();
            }
            catch (Exception e) {
                throw IO.error(e);
            }
        } else {
            this.io.closeAsync();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        return this.io.skipSync(n);
    }
}

