/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.function.Consumer;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;

public class PreBufferedReadable
extends ConcurrentCloseable<IOException>
implements IO.Readable.Buffered {
    private IO.Readable src;
    private Task.Priority priority;
    private IOException error = null;
    private long size = -1L;
    private long read = 0L;
    private boolean endReached = false;
    private boolean stopReading = false;
    private ByteBuffer current = null;
    private int nextBufferSize;
    private Async<NoException> dataReady = null;
    private TurnArray<ByteBuffer> buffersReady;
    private AsyncSupplier<?, ?> nextReadTask = null;

    public PreBufferedReadable(IO.Readable src, int firstBuffer, Task.Priority firstBufferPriority, int nextBuffer, Task.Priority nextBufferPriority, int maxNbNextBuffersReady) {
        this.src = src;
        this.priority = firstBufferPriority;
        if (src instanceof IO.KnownSize) {
            AsyncSupplier<Long, IOException> getSize = ((IO.KnownSize)((Object)src)).getSizeAsync();
            Task start = Task.cpu("Start PreBufferedReadable after size is known", firstBufferPriority, task -> {
                if (getSize.hasError()) {
                    this.error = (IOException)getSize.getError();
                    PreBufferedReadable preBufferedReadable = this;
                    synchronized (preBufferedReadable) {
                        if (this.dataReady != null) {
                            this.dataReady.unblock();
                            this.dataReady = null;
                        }
                    }
                    return null;
                }
                if (getSize.isCancelled()) {
                    return null;
                }
                this.size = (Long)getSize.getResult();
                this.startWithKnownSize(firstBuffer, firstBufferPriority, nextBuffer, nextBufferPriority, maxNbNextBuffersReady);
                return null;
            });
            this.operation(start).startOn(getSize, true);
        } else {
            this.start(firstBuffer, firstBufferPriority, nextBuffer, nextBufferPriority, maxNbNextBuffersReady);
        }
    }

    public <T extends IO.Readable.Seekable & IO.KnownSize> PreBufferedReadable(T src, int firstBuffer, Task.Priority firstBufferPriority, int nextBuffer, Task.Priority nextBufferPriority, int maxNbNextBuffersReady) throws IOException {
        this.src = src;
        this.priority = firstBufferPriority;
        this.read = src.getPosition();
        this.size = ((IO.KnownSize)src).getSizeSync();
        this.startWithKnownSize(firstBuffer, firstBufferPriority, nextBuffer, nextBufferPriority, maxNbNextBuffersReady);
    }

    public PreBufferedReadable(IO.Readable src, long size, int firstBuffer, Task.Priority firstBufferPriority, int nextBuffer, Task.Priority nextBufferPriority, int maxNbNextBuffersReady) {
        this.src = src;
        this.priority = firstBufferPriority;
        this.size = size;
        this.startWithKnownSize(firstBuffer, firstBufferPriority, nextBuffer, nextBufferPriority, maxNbNextBuffersReady);
    }

    public <T extends IO.Readable.Seekable & IO.KnownSize> PreBufferedReadable(T src, long size, int firstBuffer, Task.Priority firstBufferPriority, int nextBuffer, Task.Priority nextBufferPriority, int maxNbNextBuffersReady) throws IOException {
        this.src = src;
        this.priority = firstBufferPriority;
        this.read = src.getPosition();
        this.size = size;
        this.startWithKnownSize(firstBuffer, firstBufferPriority, nextBuffer, nextBufferPriority, maxNbNextBuffersReady);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWithKnownSize(int firstBuffer, Task.Priority firstBufferPriority, int nextBuffer, Task.Priority nextBufferPriority, int maxNbNextBuffersReady) {
        if (this.size == this.read) {
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                this.endReached = true;
                if (this.dataReady != null) {
                    this.dataReady.unblock();
                    this.dataReady = null;
                }
            }
        } else if (this.size - this.read <= (long)firstBuffer) {
            this.start((int)(this.size - this.read), firstBufferPriority, 0, null, 0);
        } else if (this.size - this.read <= (long)(firstBuffer + nextBuffer)) {
            this.start(firstBuffer, firstBufferPriority, (int)(this.size - this.read - (long)firstBuffer), nextBufferPriority, 1);
        } else {
            this.start(firstBuffer, firstBufferPriority, nextBuffer, nextBufferPriority, maxNbNextBuffersReady);
        }
    }

    @Override
    public String getSourceDescription() {
        return this.src != null ? this.src.getSourceDescription() : "closed";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Async<IOException> getDataReadySynchronization() {
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            Async<IOException> sp = new Async<IOException>();
            if (this.error != null) {
                sp.error(this.error);
                return sp;
            }
            if (this.current != null || this.endReached) {
                sp.unblock();
                return sp;
            }
            if (this.isClosing() || this.isClosed()) {
                sp.cancel(IO.cancelClosed());
                return sp;
            }
            if (this.dataReady == null) {
                this.dataReady = new Async();
            }
            this.dataReady.onDone(() -> {
                if (this.error != null) {
                    sp.error(this.error);
                } else {
                    sp.unblock();
                }
            });
            return sp;
        }
    }

    @Override
    public IAsync<IOException> canStartReading() {
        return this.getDataReadySynchronization();
    }

    @Override
    public IO getWrappedIO() {
        return this.src;
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        AsyncSupplier<?, ?> nextRead;
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            nextRead = this.nextReadTask;
        }
        if (nextRead != null && !nextRead.isDone()) {
            nextRead.cancel(IO.cancelClosed());
        }
        while (this.dataReady != null) {
            Async<NoException> dr;
            PreBufferedReadable preBufferedReadable2 = this;
            synchronized (preBufferedReadable2) {
                dr = this.dataReady;
                this.dataReady = null;
            }
            if (dr == null) continue;
            dr.unblock();
        }
        return this.src.closeAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeResources(Async<IOException> ondone) {
        Async<NoException> dr = null;
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            this.endReached = true;
            if (this.dataReady != null) {
                dr = this.dataReady;
                this.dataReady = null;
            }
            this.buffersReady = null;
            this.nextReadTask = null;
        }
        if (dr != null) {
            dr.unblock();
        }
        this.src = null;
        ondone.unblock();
    }

    @Override
    public Task.Priority getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(Task.Priority priority) {
        this.priority = priority;
    }

    private void start(int firstBuffer, Task.Priority firstBufferPriority, int nextBuffer, Task.Priority nextBufferPriority, int maxNbNextBuffersReady) {
        if (nextBuffer < 0) {
            throw new IllegalArgumentException("next buffer size must be positive, or zero to disable it, given: " + nextBuffer);
        }
        if (maxNbNextBuffersReady < 0) {
            throw new IllegalArgumentException("maximum number of next buffers must be positive, or zero to disable it, given: " + maxNbNextBuffersReady);
        }
        if (nextBuffer == 0) {
            maxNbNextBuffersReady = 0;
        }
        if (maxNbNextBuffersReady == 0) {
            nextBuffer = 0;
        }
        this.nextBufferSize = nextBuffer;
        this.buffersReady = new TurnArray(maxNbNextBuffersReady + 1);
        ByteBuffer buffer = ByteBuffer.wrap((byte[])ByteArrayCache.getInstance().get(firstBuffer, true));
        this.src.setPriority(firstBufferPriority);
        JoinPoint jpNextRead = new JoinPoint();
        jpNextRead.addToJoin(1);
        AsyncSupplier<Integer, IOException> firstReadTask = nextBuffer > 0 ? this.operation(this.src.readAsync(buffer)) : this.operation(this.src.readFullyAsync(buffer));
        Task firstNextReadTask = null;
        if (nextBuffer > 0) {
            firstNextReadTask = Task.cpu("First next read of pre-buffered IO " + this.getSourceDescription(), nextBufferPriority, task -> {
                Async<NoException> dr = null;
                PreBufferedReadable preBufferedReadable = this;
                synchronized (preBufferedReadable) {
                    this.nextReadTask = null;
                    if (!(this.error != null || this.endReached || this.stopReading || this.isClosing() || this.isClosed())) {
                        this.nextRead();
                    } else if (this.dataReady != null) {
                        dr = this.dataReady;
                        this.dataReady = null;
                    }
                }
                if (dr != null) {
                    dr.unblock();
                }
                return null;
            });
            this.nextReadTask = firstNextReadTask.getOutput();
        }
        boolean singleRead = nextBuffer <= 0;
        firstReadTask.onDone(() -> {
            if (this.buffersReady == null) {
                jpNextRead.joined();
                return;
            }
            buffer.flip();
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                if (firstReadTask.isCancelled()) {
                    if (this.dataReady != null) {
                        Async<NoException> dr = this.dataReady;
                        this.dataReady = null;
                        dr.unblock();
                    }
                    jpNextRead.joined();
                    return;
                }
                Object e = firstReadTask.getError();
                if (singleRead && e == null && (long)((Integer)firstReadTask.getResult()).intValue() < this.size) {
                    e = new IOException("Only " + (Integer)firstReadTask.getResult() + " bytes read, expected is " + this.size);
                }
                if (e != null) {
                    this.error = e instanceof IOException ? (IOException)e : new IOException("Read failed", (Throwable)e);
                    if (this.dataReady != null) {
                        Async<NoException> dr = this.dataReady;
                        this.dataReady = null;
                        dr.unblock();
                    }
                } else {
                    if (buffer.remaining() == 0) {
                        this.endReached = true;
                    } else {
                        this.current = buffer;
                    }
                    this.read += (long)buffer.remaining();
                    if (this.size > 0L && this.read == this.size) {
                        this.endReached = true;
                    }
                    if (this.endReached && this.size > 0L && this.read < this.size) {
                        this.error = new UnexpectedEnd(this);
                    }
                    if (this.dataReady != null) {
                        Async<NoException> dr = this.dataReady;
                        this.dataReady = null;
                        dr.unblock();
                    }
                }
            }
            if (this.buffersReady == null) {
                jpNextRead.joined();
                return;
            }
            this.src.setPriority(nextBufferPriority);
            jpNextRead.joined();
        });
        if (nextBuffer > 0) {
            this.operation(firstNextReadTask.getOutput());
            jpNextRead.start();
            jpNextRead.thenStart(firstNextReadTask, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        while (true) {
            Async<NoException> sp;
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.current != null) {
                    break;
                }
                if (this.endReached) {
                    return -1;
                }
                if (this.isClosing() || this.isClosed()) {
                    return -1;
                }
                if (this.dataReady == null) {
                    this.dataReady = new Async();
                }
                sp = this.dataReady;
            }
            sp.block(0L);
        }
        if (this.buffersReady == null) {
            throw new ClosedChannelException();
        }
        int nb = buffer.remaining();
        if (this.current.remaining() > nb) {
            int limit = this.current.limit();
            this.current.limit(limit - (this.current.remaining() - nb));
            buffer.put(this.current);
            this.current.limit(limit);
            return nb;
        }
        nb = this.current.remaining();
        buffer.put(this.current);
        this.moveNextBuffer(true);
        return nb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readAsync() throws IOException {
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            if (this.error != null) {
                throw this.error;
            }
            if (this.current != null) {
                if (!this.current.hasRemaining() && this.endReached) {
                    return -1;
                }
            } else {
                if (this.endReached) {
                    return -1;
                }
                if (this.isClosing() || this.isClosed()) {
                    return -1;
                }
                if (this.dataReady == null) {
                    this.dataReady = new Async();
                }
                if (!this.dataReady.isDone()) {
                    return -2;
                }
            }
        }
        int res = this.current.get() & 0xFF;
        if (!this.current.hasRemaining()) {
            this.moveNextBuffer(true);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        Async<NoException> sp = null;
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            if (this.error != null) {
                return IOUtil.error(this.error, ondone);
            }
            if (this.current == null) {
                if (this.endReached) {
                    return IOUtil.success(-1, ondone);
                }
                if (this.isClosing() || this.isClosed()) {
                    return new AsyncSupplier<Object, Object>(null, null, IO.cancelClosed());
                }
                if (this.dataReady == null) {
                    this.dataReady = new Async();
                }
                sp = this.dataReady;
            }
        }
        Task t = Task.cpu("Async read on pre-buffered IO " + this.getSourceDescription(), this.getPriority(), task -> {
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.buffersReady == null) {
                    if (this.endReached) {
                        return -1;
                    }
                    throw IO.cancelClosed();
                }
                if (this.current == null) {
                    if (this.endReached) {
                        return -1;
                    }
                    if (this.isClosing() || this.isClosed()) {
                        throw IO.cancelClosed();
                    }
                    throw new IOException("Unexpected error: current buffer is null but end is not reached");
                }
            }
            int nb = buffer.remaining();
            if (this.current.remaining() > nb) {
                int limit = this.current.limit();
                this.current.limit(limit - (this.current.remaining() - nb));
                buffer.put(this.current);
                this.current.limit(limit);
                return nb;
            }
            nb = this.current.remaining();
            buffer.put(this.current);
            this.moveNextBuffer(true);
            return nb;
        }, ondone);
        this.operation(t);
        if (sp == null) {
            t.start();
            return t.getOutput();
        }
        t.startOn(sp, false);
        return t.getOutput();
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        return IOUtil.readFully((IO.Readable)this, buffer);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsync(this, buffer, ondone));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skipSync(long n) throws IOException {
        long skipped = 0L;
        while (true) {
            Async<NoException> sp = null;
            long remaining = -1L;
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                if (this.error != null) {
                    throw this.error;
                }
                if (n <= 0L) {
                    this.stopReading = false;
                    return 0L;
                }
                if (this.current != null) {
                    int nb = this.current.remaining();
                    if ((long)nb > n) {
                        this.stopReading = false;
                        this.current.position(this.current.position() + (int)n);
                        return n + skipped;
                    }
                    if ((long)nb == n) {
                        this.stopReading = false;
                        this.moveNextBuffer(true);
                        return n + skipped;
                    }
                    skipped += (long)nb;
                    if (this.buffersReady == null || this.nextBufferSize == 0) {
                        this.endReached = true;
                        if (this.size > 0L && this.read < this.size) {
                            this.error = new UnexpectedEnd(this);
                        }
                        if (this.dataReady != null) {
                            this.dataReady.unblock();
                        }
                        return skipped;
                    }
                    this.stopReading = true;
                    this.moveNextBuffer(false);
                    remaining = n - (long)nb;
                } else {
                    if (this.endReached) {
                        return skipped;
                    }
                    if (this.nextReadTask == null && this.nextBufferSize > 0) {
                        long n2 = this.src.skipSync(n);
                        this.read += n2;
                        this.stopReading = false;
                        this.moveNextBuffer(true);
                        return skipped += n2;
                    }
                    if (this.isClosing() || this.isClosed()) {
                        return skipped;
                    }
                    if (this.dataReady == null) {
                        this.dataReady = new Async();
                    }
                    sp = this.dataReady;
                }
            }
            if (remaining > 0L) {
                n = remaining;
                continue;
            }
            if (sp == null) continue;
            sp.block(0L);
        }
    }

    @Override
    public int skip(int skip) throws IOException {
        return (int)this.skipSync(skip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            if (this.error != null) {
                return IOUtil.error(this.error, ondone);
            }
            if (n <= 0L) {
                return IOUtil.success(0L, ondone);
            }
            return this.operation(Task.cpu("Skipping data from pre-buffered IO " + this.getSourceDescription(), this.priority, t -> this.skipSync(n), ondone).start()).getOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveNextBuffer(boolean startNextRead) {
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            this.current = this.buffersReady.pollFirst();
            if (!this.endReached && this.error == null && this.nextReadTask == null && startNextRead && !this.stopReading) {
                this.nextRead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextRead() {
        if (this.isClosing() || this.isClosed()) {
            Async<NoException> dr;
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                dr = this.dataReady;
                this.dataReady = null;
            }
            if (dr != null) {
                dr.unblock();
            }
            return;
        }
        ByteBuffer buffer = ByteBuffer.wrap((byte[])ByteArrayCache.getInstance().get(this.nextBufferSize, true));
        this.nextReadTask = this.operation(this.src.readFullyAsync(buffer));
        this.nextReadTask.onDone(() -> {
            int nb;
            if (this.handleNextReadError()) {
                return;
            }
            try {
                nb = (Integer)this.nextReadTask.getResult();
            }
            catch (NullPointerException ex) {
                nb = 0;
            }
            if (this.handleNextReadResult(nb, buffer)) {
                return;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleNextReadError() {
        Object e;
        if (this.nextReadTask == null) {
            return true;
        }
        try {
            e = this.nextReadTask.getError();
        }
        catch (NullPointerException ex) {
            return true;
        }
        if (e == null) {
            return false;
        }
        this.error = e instanceof IOException ? (IOException)e : new IOException("Read failed", (Throwable)e);
        this.nextReadTask = null;
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            if (this.dataReady != null) {
                Async<NoException> dr = this.dataReady;
                this.dataReady = null;
                dr.unblock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleNextReadResult(int nb, ByteBuffer buffer) {
        Async<NoException> sp = null;
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            this.nextReadTask = null;
            if (this.buffersReady == null) {
                return true;
            }
            if (nb <= 0) {
                this.endReached = true;
            } else {
                this.read += (long)nb;
                if (nb < buffer.limit() || this.size > 0L && this.read == this.size) {
                    this.endReached = true;
                }
                buffer.flip();
                if (this.current == null) {
                    this.current = buffer;
                } else {
                    this.buffersReady.addLast(buffer);
                }
                if (!(this.endReached || this.buffersReady.isFull() || this.stopReading)) {
                    this.nextRead();
                }
            }
            if (this.endReached && this.size > 0L && this.read < this.size && this.buffersReady != null && !this.isClosing() && !this.isClosed()) {
                this.error = new UnexpectedEnd(this);
            }
            if (this.dataReady != null) {
                sp = this.dataReady;
                this.dataReady = null;
            }
        }
        if (sp != null) {
            sp.unblock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        while (true) {
            Async<NoException> sp;
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.current != null) {
                    if (!this.current.hasRemaining() && this.endReached) {
                        return -1;
                    }
                    break;
                }
                if (this.endReached) {
                    return -1;
                }
                if (this.isClosing() || this.isClosed()) {
                    return -1;
                }
                if (this.dataReady == null) {
                    this.dataReady = new Async();
                }
                sp = this.dataReady;
            }
            sp.block(0L);
        }
        int res = this.current.get() & 0xFF;
        if (!this.current.hasRemaining()) {
            this.moveNextBuffer(true);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        while (true) {
            Async<NoException> sp;
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.current != null) {
                    if (!this.current.hasRemaining() && this.endReached) {
                        return -1;
                    }
                    break;
                }
                if (this.endReached) {
                    return -1;
                }
                if (this.isClosing() || this.isClosed()) {
                    return -1;
                }
                if (this.dataReady == null) {
                    this.dataReady = new Async();
                }
                sp = this.dataReady;
            }
            sp.block(0L);
        }
        if (this.current.remaining() > len) {
            this.current.get(buffer, offset, len);
            return len;
        }
        len = this.current.remaining();
        this.current.get(buffer, offset, len);
        this.moveNextBuffer(true);
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readFully(byte[] buffer) throws IOException {
        int pos;
        while (true) {
            Async<NoException> sp;
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.current != null) {
                    if (!this.current.hasRemaining() && this.endReached) {
                        return -1;
                    }
                    break;
                }
                if (this.endReached) {
                    return -1;
                }
                if (this.isClosing() || this.isClosed()) {
                    return -1;
                }
                if (this.dataReady == null) {
                    this.dataReady = new Async();
                }
                sp = this.dataReady;
            }
            sp.block(0L);
        }
        if (this.current.remaining() > buffer.length) {
            this.current.get(buffer);
            return buffer.length;
        }
        int len = this.current.remaining();
        this.current.get(buffer, 0, len);
        this.moveNextBuffer(true);
        for (pos = len; pos < buffer.length && (len = this.read(buffer, pos, buffer.length - pos)) >= 0; pos += len) {
        }
        return pos;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.readFullySyncIfPossible(buffer, 0, ondone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, int alreadyDone, Consumer<Pair<Integer, IOException>> ondone) {
        boolean ok = true;
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            if (this.error != null) {
                return IOUtil.error(this.error, ondone);
            }
            if (this.current != null) {
                if (!this.current.hasRemaining() && this.endReached) {
                    return IOUtil.success(alreadyDone > 0 ? alreadyDone : -1, ondone);
                }
            } else {
                if (this.endReached || this.isClosing() || this.isClosed()) {
                    return IOUtil.success(alreadyDone > 0 ? alreadyDone : -1, ondone);
                }
                ok = false;
            }
        }
        if (!ok) {
            if (alreadyDone == 0) {
                return this.readFullyAsync(buffer, ondone);
            }
            AsyncSupplier<Integer, IOException> res = new AsyncSupplier<Integer, IOException>();
            this.readFullyAsync(buffer, r -> {
                if (ondone != null) {
                    if (r.getValue1() != null) {
                        ondone.accept(new Pair<Integer, Object>((Integer)r.getValue1() + alreadyDone, null));
                    } else {
                        ondone.accept((Pair<Integer, IOException>)r);
                    }
                }
            }).onDone(nb -> res.unblockSuccess(alreadyDone + nb), res);
            return res;
        }
        int len = buffer.remaining();
        if (this.current.remaining() > len) {
            int l = this.current.limit();
            this.current.limit(this.current.position() + len);
            buffer.put(this.current);
            this.current.limit(l);
            Integer r2 = alreadyDone + len;
            if (ondone != null) {
                ondone.accept(new Pair<Integer, Object>(r2, null));
            }
            return new AsyncSupplier<Integer, Object>(r2, null);
        }
        len = this.current.remaining();
        buffer.put(this.current);
        this.moveNextBuffer(true);
        return this.readFullySyncIfPossible(buffer, len + alreadyDone, ondone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncSupplier<ByteBuffer, IOException> readNextBufferAsync(Consumer<Pair<ByteBuffer, IOException>> ondone) {
        Async<NoException> sp;
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            if (this.error != null) {
                return IOUtil.error(this.error, ondone);
            }
            if (this.current != null) {
                if (!this.current.hasRemaining() && this.endReached) {
                    return IOUtil.success(null, ondone);
                }
                return this.operation(Task.cpu("Read next buffer", this.getPriority(), t -> {
                    ByteBuffer buf = this.current.asReadOnlyBuffer();
                    this.current.position(this.current.limit());
                    this.moveNextBuffer(true);
                    return buf;
                }, ondone).start()).getOutput();
            }
            if (this.endReached) {
                return IOUtil.success(null, ondone);
            }
            if (this.isClosing() || this.isClosed()) {
                return new AsyncSupplier<Object, Object>(null, null, IO.cancelClosed());
            }
            if (this.dataReady == null) {
                this.dataReady = new Async();
            }
            sp = this.dataReady;
        }
        AsyncSupplier result = new AsyncSupplier();
        sp.onDone(() -> this.readNextBufferAsync(ondone).forward(result));
        return this.operation(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer readNextBuffer() throws IOException {
        while (true) {
            Async<NoException> sp;
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.current != null) {
                    if (!this.current.hasRemaining() && this.endReached) {
                        return null;
                    }
                    ByteBuffer buf = this.current.asReadOnlyBuffer();
                    this.current.position(this.current.limit());
                    this.moveNextBuffer(true);
                    return buf;
                }
                if (this.endReached) {
                    return null;
                }
                if (this.isClosing() || this.isClosed()) {
                    throw new ClosedChannelException();
                }
                if (this.dataReady == null) {
                    this.dataReady = new Async();
                }
                sp = this.dataReady;
            }
            sp.block(0L);
        }
    }

    private static class UnexpectedEnd
    extends IOException {
        private static final long serialVersionUID = 1L;

        public UnexpectedEnd(PreBufferedReadable io) {
            super("Unexpected end after " + io.read + " bytes read, known size is " + io.size);
        }
    }
}

