/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;

public class SingleBufferReadable
extends ConcurrentCloseable<IOException>
implements IO.Readable.Buffered {
    private IO.Readable io;
    private boolean useReadFully;
    private byte[] buffer;
    private AtomicState state;
    private AsyncSupplier<Integer, IOException> reading;

    public SingleBufferReadable(IO.Readable io, int bufferSize, boolean useReadFully) {
        this.io = io;
        this.buffer = new byte[bufferSize];
        this.useReadFully = useReadFully;
        this.state = new AtomicState();
        this.state.pos = (this.state.len = 0);
        this.state.eof = false;
        this.fillNextBuffer();
    }

    @Override
    public IAsync<IOException> canStartReading() {
        return new Async<boolean>(true);
    }

    private void fillNextBuffer() {
        this.reading = this.useReadFully ? this.io.readFullyAsync(ByteBuffer.wrap(this.buffer), result -> {
            if (result.getValue1() == null) {
                return;
            }
            AtomicState ns = new AtomicState();
            ns.len = (Integer)result.getValue1();
            if (ns.len <= 0) {
                ns.len = 0;
                ns.eof = true;
            } else if (ns.len < this.buffer.length) {
                ns.eof = true;
            } else {
                ns.eof = false;
            }
            ns.pos = 0;
            this.state = ns;
        }) : this.io.readAsync(ByteBuffer.wrap(this.buffer), result -> {
            if (result.getValue1() == null) {
                return;
            }
            AtomicState ns = new AtomicState();
            ns.len = (Integer)result.getValue1();
            if (ns.len <= 0) {
                ns.len = 0;
                ns.eof = true;
            } else {
                ns.eof = false;
            }
            ns.pos = 0;
            this.state = ns;
        });
        this.operation(this.reading);
    }

    private void waitBufferSync() throws IOException {
        this.reading.blockException(0L);
        if (this.reading.isCancelled()) {
            throw new IOException("Read cancelled", this.reading.getCancelEvent());
        }
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.eof) {
                return 0;
            }
            this.waitBufferSync();
            return this.readSync(buffer);
        }
        int l = buffer.remaining();
        if (l > s.len - s.pos) {
            l = s.len - s.pos;
        }
        buffer.put(this.buffer, s.pos, l);
        AtomicState atomicState = s;
        atomicState.pos = atomicState.pos + l;
        if (s.pos == s.len) {
            this.fillNextBuffer();
        }
        return l;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.eof) {
                return IOUtil.success(-1, ondone);
            }
            return this.readFullyAsync(buffer, ondone);
        }
        int l = buffer.remaining();
        if (l > s.len - s.pos) {
            l = s.len - s.pos;
        }
        buffer.put(this.buffer, s.pos, l);
        AtomicState atomicState = s;
        atomicState.pos = atomicState.pos + l;
        if (s.pos == s.len) {
            this.fillNextBuffer();
        }
        if (!buffer.hasRemaining()) {
            return IOUtil.success(l, ondone);
        }
        return this.operation(IOUtil.readFullyAsync(this, buffer, l, ondone));
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readAsyncUsingSync(this, buffer, ondone));
    }

    @Override
    public int readAsync() throws IOException {
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (this.reading.hasError()) {
                throw this.reading.getError();
            }
            if (s.eof) {
                return -1;
            }
            return -2;
        }
        int c = this.buffer[s.pos++] & 0xFF;
        if (s.pos == s.len) {
            this.fillNextBuffer();
        }
        return c;
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        return IOUtil.readFully((IO.Readable)this, buffer);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsync(this, buffer, ondone));
    }

    @Override
    public long skipSync(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long nb = 0L;
        while (n > 0L) {
            int l;
            AtomicState s = this.state;
            if (s.pos == s.len) {
                if (s.eof) {
                    return nb;
                }
                this.waitBufferSync();
            }
            if ((long)(l = this.state.len - this.state.pos) > n) {
                l = (int)n;
            }
            AtomicState atomicState = this.state;
            atomicState.pos = atomicState.pos + l;
            nb += (long)l;
            n -= (long)l;
            if (this.state.pos != this.state.len) continue;
            this.fillNextBuffer();
        }
        return nb;
    }

    @Override
    public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        return this.operation(IOUtil.skipAsyncByReading(this, n, ondone));
    }

    @Override
    public String getSourceDescription() {
        return this.io.getSourceDescription();
    }

    @Override
    public IO getWrappedIO() {
        return this.io;
    }

    @Override
    public Task.Priority getPriority() {
        return this.io != null ? this.io.getPriority() : Task.Priority.NORMAL;
    }

    @Override
    public void setPriority(Task.Priority priority) {
        this.io.setPriority(priority);
    }

    @Override
    public TaskManager getTaskManager() {
        return this.io.getTaskManager();
    }

    @Override
    public int read() throws IOException {
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.eof) {
                return -1;
            }
            this.waitBufferSync();
            return this.read();
        }
        int c = this.buffer[s.pos++] & 0xFF;
        if (s.pos == s.len) {
            this.fillNextBuffer();
        }
        return c;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.eof) {
                return 0;
            }
            this.waitBufferSync();
            return this.read(buffer, offset, len);
        }
        int l = len;
        if (l > s.len - s.pos) {
            l = s.len - s.pos;
        }
        System.arraycopy(this.buffer, s.pos, buffer, offset, l);
        AtomicState atomicState = s;
        atomicState.pos = atomicState.pos + l;
        if (s.pos == s.len) {
            this.fillNextBuffer();
        }
        return l;
    }

    @Override
    public int readFully(byte[] buffer) throws IOException {
        return IOUtil.readFully((IO.Readable)this, ByteBuffer.wrap(buffer));
    }

    @Override
    public int skip(int skip) throws IOException {
        return (int)this.skipSync(skip);
    }

    @Override
    public AsyncSupplier<ByteBuffer, IOException> readNextBufferAsync(Consumer<Pair<ByteBuffer, IOException>> ondone) {
        AtomicState s = this.state;
        if (s.pos == s.len && s.eof) {
            return IOUtil.success(null, ondone);
        }
        Task task = Task.cpu("Read next buffer", this.getPriority(), new Executable.FromSupplierThrows(this::readNextBuffer), ondone);
        task.startOn(this.reading, true);
        return this.operation(task).getOutput();
    }

    @Override
    public ByteBuffer readNextBuffer() throws IOException {
        AtomicState s;
        while (true) {
            if (this.reading.hasError()) {
                throw this.reading.getError();
            }
            if (this.reading.isCancelled()) {
                throw IO.errorCancelled(this.reading.getCancelEvent());
            }
            s = this.state;
            if (s.pos != s.len) break;
            if (s.eof) {
                return null;
            }
            this.waitBufferSync();
        }
        ByteBuffer buf = ByteBuffer.wrap((byte[])ByteArrayCache.getInstance().get(s.len - s.pos, true));
        buf.put(this.buffer, s.pos, s.len - s.pos);
        s.pos = s.len;
        this.fillNextBuffer();
        buf.flip();
        return buf;
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        if (!this.reading.isDone()) {
            this.reading.cancel(new CancelException("IO closed"));
        }
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.buffer = null;
        this.io = null;
        ondone.unblock();
    }

    private static class AtomicState {
        private int len;
        private int pos;
        private boolean eof;

        private AtomicState() {
        }
    }
}

