/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.data;

import java.nio.ByteBuffer;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.io.data.DataArray;
import net.lecousin.framework.io.data.DataBuffer;
import net.lecousin.framework.memory.ByteArrayCache;

public class ByteArray
extends DataArray<byte[]>
implements Bytes.Readable {
    public static ByteArray fromByteBuffer(ByteBuffer b) {
        if (b.hasArray()) {
            ByteArray ba = b.isReadOnly() ? new ByteArray(b.array(), b.arrayOffset(), b.arrayOffset() + b.position() + b.remaining()) : new Writable(b.array(), b.arrayOffset(), b.arrayOffset() + b.position() + b.remaining(), true);
            ba.currentOffset = b.arrayOffset() + b.position();
            return ba;
        }
        Writable ba = new Writable((byte[])ByteArrayCache.getInstance().get(b.remaining(), true), true);
        ba.length = b.remaining();
        b.get((byte[])ba.array, 0, ba.length);
        b.position(b.position() - ba.length);
        return ba;
    }

    public static ByteArray readOnlyFromByteBuffer(ByteBuffer b) {
        if (b.hasArray()) {
            ByteArray ba = new ByteArray(b.array(), b.arrayOffset(), b.arrayOffset() + b.position() + b.remaining());
            ba.currentOffset = b.arrayOffset() + b.position();
            return ba;
        }
        ByteArray ba = new ByteArray((byte[])ByteArrayCache.getInstance().get(b.remaining(), true));
        ba.length = b.remaining();
        b.get((byte[])ba.array, 0, ba.length);
        b.position(b.position() - ba.length);
        return ba;
    }

    public ByteArray(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public ByteArray(byte[] buffer) {
        super(buffer, 0, buffer.length);
    }

    public ByteArray(ByteArray copy) {
        super(copy);
    }

    public ByteArray duplicate() {
        return new ByteArray(this);
    }

    @Override
    public byte get() {
        return ((byte[])this.array)[this.currentOffset++];
    }

    @Override
    public void get(byte[] buffer, int offset, int length) {
        System.arraycopy(this.array, this.currentOffset, buffer, offset, length);
        this.currentOffset += length;
    }

    @Override
    public byte getForward(int offset) {
        return ((byte[])this.array)[this.currentOffset + offset];
    }

    public void setPosition(ByteBuffer originalBuffer) {
        originalBuffer.position(originalBuffer.limit() - this.remaining());
    }

    @Override
    public ByteArray subBuffer(int startPosition, int length) {
        return new ByteArray((byte[])this.array, this.arrayOffset + startPosition, length);
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap((byte[])this.array, this.currentOffset, this.length - (this.currentOffset - this.arrayOffset)).asReadOnlyBuffer();
    }

    @Override
    public void free() {
    }

    public static class Writable
    extends ByteArray
    implements DataBuffer.Writable,
    Bytes.Writable {
        private boolean free;

        public static Writable fromByteBuffer(ByteBuffer b) {
            if (b.hasArray()) {
                Writable ba;
                if (b.isReadOnly()) {
                    ba = new Writable((byte[])ByteArrayCache.getInstance().get(b.remaining(), true), 0, b.remaining(), true);
                    b.get((byte[])ba.getArray(), 0, b.remaining());
                } else {
                    ba = new Writable(b.array(), b.arrayOffset(), b.arrayOffset() + b.position() + b.remaining(), true);
                }
                ba.currentOffset = b.arrayOffset() + b.position();
                return ba;
            }
            Writable ba = new Writable((byte[])ByteArrayCache.getInstance().get(b.remaining(), true), true);
            ba.length = b.remaining();
            b.get((byte[])ba.array, 0, ba.length);
            b.position(b.position() - ba.length);
            return ba;
        }

        public Writable(byte[] buffer, int offset, int length, boolean free) {
            super(buffer, offset, length);
            this.free = free;
        }

        public Writable(byte[] buffer, boolean free) {
            super(buffer, 0, buffer.length);
            this.free = free;
        }

        public Writable(ByteArray copy) {
            super(copy);
            this.free = false;
        }

        @Override
        public Writable duplicate() {
            return new Writable(this);
        }

        @Override
        public void put(byte b) {
            ((byte[])this.array)[this.currentOffset++] = b;
        }

        @Override
        public void put(byte[] buffer, int offset, int length) {
            System.arraycopy(buffer, offset, this.array, this.currentOffset, length);
            this.currentOffset += length;
        }

        @Override
        public Writable subBuffer(int startPosition, int length) {
            return new Writable((byte[])this.array, this.arrayOffset + startPosition, length, false);
        }

        @Override
        public ByteBuffer toByteBuffer() {
            return ByteBuffer.wrap((byte[])this.array, this.currentOffset, this.length - (this.currentOffset - this.arrayOffset));
        }

        @Override
        public void free() {
            if (!this.free) {
                return;
            }
            ByteArrayCache.getInstance().free(this.array);
            this.array = null;
        }
    }
}

