/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.data;

import java.nio.ByteBuffer;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.memory.ByteArrayCache;

public class ByteBufferAsBytes
implements Bytes.Readable {
    protected ByteBuffer buffer;
    protected boolean free;

    public static ByteBufferAsBytes create(ByteBuffer buffer, boolean freeArray) {
        if (buffer.isReadOnly()) {
            return new ByteBufferAsBytes(buffer, freeArray);
        }
        return new Writable(buffer, freeArray);
    }

    private ByteBufferAsBytes(ByteBuffer buffer, boolean freeArray) {
        this.buffer = buffer;
        this.free = freeArray;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.buffer;
    }

    @Override
    public int length() {
        return this.buffer.limit();
    }

    @Override
    public int position() {
        return this.buffer.position();
    }

    @Override
    public void setPosition(int position) {
        this.buffer.position(position);
    }

    @Override
    public int remaining() {
        return this.buffer.remaining();
    }

    @Override
    public ByteBufferAsBytes subBuffer(int startPosition, int length) {
        ByteBuffer dup = this.buffer.duplicate();
        dup.position(startPosition);
        dup.limit(startPosition + length);
        return new ByteBufferAsBytes(dup.slice(), false);
    }

    @Override
    public byte get() {
        return this.buffer.get();
    }

    @Override
    public void get(byte[] buffer, int offset, int length) {
        this.buffer.get(buffer, offset, length);
    }

    @Override
    public byte getForward(int offset) {
        return this.buffer.get(this.buffer.position() + offset);
    }

    @Override
    public void free() {
        if (this.free) {
            ByteArrayCache.getInstance().free(this.buffer);
        }
        this.buffer = null;
    }

    public static class Writable
    extends ByteBufferAsBytes
    implements Bytes.Writable {
        private Writable(ByteBuffer buffer, boolean freeArray) {
            super(buffer, freeArray);
        }

        @Override
        public void put(byte b) {
            this.buffer.put(b);
        }

        @Override
        public void put(byte[] buffer, int offset, int length) {
            this.buffer.put(buffer, offset, length);
        }

        @Override
        public Writable subBuffer(int startPosition, int length) {
            ByteBuffer dup = this.buffer.duplicate();
            dup.position(startPosition);
            dup.limit(startPosition + length);
            return new Writable(dup.slice(), false);
        }
    }
}

