/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.data;

import java.nio.CharBuffer;
import net.lecousin.framework.io.data.Chars;
import net.lecousin.framework.io.data.DataArray;
import net.lecousin.framework.io.data.DataBuffer;
import net.lecousin.framework.memory.CharArrayCache;
import net.lecousin.framework.text.IString;

public class CharArray
extends DataArray<char[]>
implements Chars.Readable {
    public static CharArray fromCharBuffer(CharBuffer b) {
        if (b.hasArray()) {
            CharArray ba = b.isReadOnly() ? new CharArray(b.array(), b.arrayOffset(), b.arrayOffset() + b.position() + b.remaining()) : new Writable(b.array(), b.arrayOffset(), b.arrayOffset() + b.position() + b.remaining(), true);
            ba.currentOffset = b.arrayOffset() + b.position();
            return ba;
        }
        Writable ba = new Writable((char[])CharArrayCache.getInstance().get(b.remaining(), true), true);
        ba.length = b.remaining();
        b.get((char[])ba.array, 0, ba.length);
        b.position(b.position() - ba.length);
        return ba;
    }

    public CharArray(char[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public CharArray(char[] buffer) {
        super(buffer, 0, buffer.length);
    }

    public CharArray(CharArray copy) {
        super(copy);
    }

    public CharArray duplicate() {
        return new CharArray(this);
    }

    @Override
    public char get() {
        return ((char[])this.array)[this.currentOffset++];
    }

    @Override
    public void get(char[] buffer, int offset, int length) {
        System.arraycopy(this.array, this.currentOffset, buffer, offset, length);
        this.currentOffset += length;
    }

    @Override
    public void get(IString string, int length) {
        string.append((char[])this.array, this.currentOffset, length);
        this.currentOffset += length;
    }

    @Override
    public char getForward(int offset) {
        return ((char[])this.array)[this.currentOffset + offset];
    }

    @Override
    public CharBuffer toCharBuffer() {
        return CharBuffer.wrap((char[])this.array, this.currentOffset, this.length - (this.currentOffset - this.arrayOffset)).asReadOnlyBuffer();
    }

    public void setPosition(CharBuffer originalBuffer) {
        originalBuffer.position(originalBuffer.limit() - this.remaining());
    }

    @Override
    public CharArray subBuffer(int startPosition, int length) {
        return new CharArray((char[])this.array, this.arrayOffset + startPosition, length);
    }

    @Override
    public void free() {
    }

    public static class Writable
    extends CharArray
    implements DataBuffer.Writable,
    Chars.Writable {
        private boolean free;

        public Writable(char[] buffer, int offset, int length, boolean free) {
            super(buffer, offset, length);
            this.free = free;
        }

        public Writable(char[] buffer, boolean free) {
            super(buffer, 0, buffer.length);
            this.free = free;
        }

        public Writable(CharArray copy) {
            super(copy);
            this.free = false;
        }

        @Override
        public Writable duplicate() {
            return new Writable(this);
        }

        @Override
        public void put(char b) {
            ((char[])this.array)[this.currentOffset++] = b;
        }

        @Override
        public void put(char[] buffer, int offset, int length) {
            System.arraycopy(buffer, offset, this.array, this.currentOffset, length);
            this.currentOffset += length;
        }

        @Override
        public CharBuffer toCharBuffer() {
            return CharBuffer.wrap((char[])this.array, this.currentOffset, this.length - (this.currentOffset - this.arrayOffset));
        }

        @Override
        public Writable subBuffer(int startPosition, int length) {
            return new Writable((char[])this.array, this.arrayOffset + startPosition, length, false);
        }

        @Override
        public void free() {
            if (!this.free) {
                return;
            }
            CharArrayCache.getInstance().free(this.array);
            this.array = null;
        }
    }
}

