/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.data;

import java.nio.ByteBuffer;
import java.util.List;
import net.lecousin.framework.io.data.AbstractComposite;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.io.data.Bytes;

public abstract class CompositeBytes<T extends Bytes>
extends AbstractComposite<T>
implements Bytes {
    public CompositeBytes() {
    }

    @SafeVarargs
    public CompositeBytes(T ... bytes) {
        super(bytes);
    }

    public CompositeBytes(List<T> bytes) {
        super(bytes);
    }

    public static class Writable
    extends CompositeBytes<Bytes.Writable>
    implements Bytes.Writable {
        public Writable() {
        }

        public Writable(Bytes.Writable ... bytes) {
            super((Bytes[])bytes);
        }

        public Writable(List<Bytes.Writable> bytes) {
            super(bytes);
        }

        @Override
        public void put(byte b) {
            Bytes.Writable bytes = (Bytes.Writable)this.list.get(this.index);
            bytes.put(b);
            ++this.position;
            if (!bytes.hasRemaining()) {
                ++this.index;
            }
        }

        @Override
        public void put(byte[] buffer, int offset, int length) {
            while (length > 0) {
                Bytes.Writable bytes = (Bytes.Writable)this.list.get(this.index);
                int r = bytes.remaining();
                if (length < r) {
                    bytes.put(buffer, offset, length);
                    this.position += length;
                    return;
                }
                bytes.put(buffer, offset, r);
                this.position += r;
                offset += r;
                length -= r;
                ++this.index;
            }
        }

        @Override
        public ByteBuffer toByteBuffer() {
            byte[] buf = new byte[this.length];
            int off = 0;
            for (Bytes.Writable bytes : this.list) {
                int p = bytes.position();
                bytes.setPosition(0);
                int l = bytes.remaining();
                if (!(bytes instanceof Bytes.Readable)) {
                    throw new UnsupportedOperationException("Cannot convert a write-only Bytes to ByteBuffer");
                }
                ((Bytes.Readable)((Object)bytes)).get(buf, off, l);
                bytes.setPosition(p);
                off += l;
            }
            ByteBuffer bb = ByteBuffer.wrap(buf);
            bb.position(this.position);
            return bb;
        }

        @Override
        public Bytes.Writable subBuffer(int startPosition, int length) {
            int i = 0;
            int p = startPosition;
            do {
                Bytes.Writable bytes;
                int r;
                if (p < (r = (bytes = (Bytes.Writable)this.list.get(i)).length())) {
                    Writable result = new Writable();
                    int l = Math.min(length, r - p);
                    result.add(bytes.subBuffer(p, l));
                    length -= l;
                    while (length > 0 && ++i < this.list.size()) {
                        bytes = (Bytes.Writable)this.list.get(i);
                        l = Math.min(length, bytes.length());
                        result.add(bytes.subBuffer(0, l));
                        length -= l;
                    }
                    return result;
                }
                p -= r;
            } while (++i < this.list.size());
            return new ByteArray.Writable(new byte[0], false);
        }
    }

    public static class Readable
    extends CompositeBytes<Bytes.Readable>
    implements Bytes.Readable {
        public Readable() {
        }

        public Readable(Bytes.Readable ... bytes) {
            super((Bytes[])bytes);
        }

        public Readable(List<Bytes.Readable> bytes) {
            super(bytes);
        }

        @Override
        public byte get() {
            Bytes.Readable bytes = (Bytes.Readable)this.list.get(this.index);
            byte b = bytes.get();
            ++this.position;
            if (!bytes.hasRemaining()) {
                ++this.index;
            }
            return b;
        }

        @Override
        public void get(byte[] buffer, int offset, int length) {
            while (length > 0) {
                Bytes.Readable bytes = (Bytes.Readable)this.list.get(this.index);
                int r = bytes.remaining();
                if (length < r) {
                    bytes.get(buffer, offset, length);
                    this.position += length;
                    return;
                }
                bytes.get(buffer, offset, r);
                this.position += r;
                offset += r;
                length -= r;
                ++this.index;
            }
        }

        @Override
        public byte getForward(int offset) {
            int i = this.index;
            int o = offset;
            Bytes.Readable bytes;
            int r;
            while (o >= (r = (bytes = (Bytes.Readable)this.list.get(i)).remaining())) {
                o -= r;
                ++i;
            }
            return bytes.getForward(o);
        }

        @Override
        public ByteBuffer toByteBuffer() {
            byte[] buf = new byte[this.length];
            int off = 0;
            for (Bytes.Readable bytes : this.list) {
                int p = bytes.position();
                bytes.setPosition(0);
                int l = bytes.remaining();
                bytes.get(buf, off, l);
                bytes.setPosition(p);
                off += l;
            }
            return ByteBuffer.wrap(buf);
        }

        @Override
        public Bytes.Readable subBuffer(int startPosition, int length) {
            int i = 0;
            int p = startPosition;
            do {
                Bytes.Readable bytes;
                int r;
                if (p < (r = (bytes = (Bytes.Readable)this.list.get(i)).length())) {
                    Readable result = new Readable();
                    int l = Math.min(length, r - p);
                    result.add(bytes.subBuffer(p, l));
                    length -= l;
                    while (length > 0 && ++i < this.list.size()) {
                        bytes = (Bytes.Readable)this.list.get(i);
                        l = Math.min(length, bytes.length());
                        result.add(bytes.subBuffer(0, l));
                        length -= l;
                    }
                    return result;
                }
                p -= r;
            } while (++i < this.list.size());
            return new ByteArray(new byte[0]);
        }
    }
}

