/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.data;

import net.lecousin.framework.io.data.DataBuffer;

public abstract class DataArray<T>
implements DataBuffer.Readable {
    protected T array;
    protected int arrayOffset;
    protected int currentOffset;
    protected int length;

    protected DataArray(T buffer, int offset, int length) {
        this.array = buffer;
        this.arrayOffset = offset;
        this.currentOffset = offset;
        this.length = length;
    }

    protected DataArray(DataArray<T> copy) {
        this(copy.array, copy.arrayOffset, copy.length);
        this.currentOffset = copy.currentOffset;
    }

    protected DataArray() {
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int remaining() {
        return this.length - (this.currentOffset - this.arrayOffset);
    }

    @Override
    public boolean hasRemaining() {
        return this.currentOffset - this.arrayOffset < this.length;
    }

    @Override
    public int position() {
        return this.currentOffset - this.arrayOffset;
    }

    @Override
    public void setPosition(int position) {
        this.currentOffset = this.arrayOffset + position;
    }

    @Override
    public void moveForward(int offset) {
        this.currentOffset += offset;
    }

    @Override
    public void goToEnd() {
        this.currentOffset = this.arrayOffset + this.length;
    }

    public void flip() {
        this.length = this.currentOffset - this.arrayOffset;
        this.currentOffset = this.arrayOffset;
    }

    public void slice() {
        this.length -= this.currentOffset - this.arrayOffset;
        this.arrayOffset = this.currentOffset;
    }

    public T getArray() {
        return this.array;
    }

    public int getCurrentArrayOffset() {
        return this.currentOffset;
    }
}

