/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.data;

import net.lecousin.framework.io.data.BitsBuffer;

public interface SingleByteBitsBuffer
extends BitsBuffer {

    public static interface Writable
    extends SingleByteBitsBuffer,
    BitsBuffer.Writable {
        public byte getByte();

        public static class LittleEndian
        implements Writable,
        BitsBuffer.LittleEndian {
            private byte b = 0;
            private int bit = 0;

            @Override
            public byte getByte() {
                return this.b;
            }

            @Override
            public boolean hasRemaining() {
                return this.bit < 8;
            }

            @Override
            public int remaining() {
                return 8 - this.bit;
            }

            @Override
            public void alignToNextByte(boolean fillBit) {
                if (this.bit == 0 || this.bit == 8) {
                    return;
                }
                if (fillBit) {
                    do {
                        this.b = (byte)(this.b | 1 << this.bit++);
                    } while (this.bit < 8);
                } else {
                    this.bit = 8;
                }
            }

            @Override
            public void put(boolean bit) {
                if (bit) {
                    this.b = (byte)(this.b | 1 << this.bit);
                }
                ++this.bit;
            }
        }

        public static class BigEndian
        implements Writable,
        BitsBuffer.BigEndian {
            private byte b = 0;
            private int bit = 7;

            @Override
            public byte getByte() {
                return this.b;
            }

            @Override
            public boolean hasRemaining() {
                return this.bit >= 0;
            }

            @Override
            public int remaining() {
                return this.bit + 1;
            }

            @Override
            public void alignToNextByte(boolean fillBit) {
                if (this.bit == -1 || this.bit == 7) {
                    return;
                }
                if (fillBit) {
                    do {
                        this.b = (byte)(this.b | 1 << this.bit--);
                    } while (this.bit >= 0);
                } else {
                    this.bit = -1;
                }
            }

            @Override
            public void put(boolean bit) {
                if (bit) {
                    this.b = (byte)(this.b | 1 << this.bit);
                }
                --this.bit;
            }
        }
    }

    public static interface Readable
    extends SingleByteBitsBuffer,
    BitsBuffer.Readable {

        public static class LittleEndian
        implements Readable,
        BitsBuffer.LittleEndian {
            private byte b;
            private int mask = 1;

            public LittleEndian(byte b) {
                this.b = b;
            }

            @Override
            public boolean get() {
                boolean bit = (this.b & this.mask) != 0;
                this.mask <<= 1;
                return bit;
            }

            @Override
            public boolean hasRemaining() {
                return this.mask != 256;
            }

            @Override
            public int remaining() {
                switch (this.mask) {
                    case 128: {
                        return 1;
                    }
                    case 64: {
                        return 2;
                    }
                    case 32: {
                        return 3;
                    }
                    case 16: {
                        return 4;
                    }
                    case 8: {
                        return 5;
                    }
                    case 4: {
                        return 6;
                    }
                    case 2: {
                        return 7;
                    }
                    case 1: {
                        return 8;
                    }
                }
                return 0;
            }

            @Override
            public void alignToNextByte() {
                this.mask = 256;
            }
        }

        public static class BigEndian
        implements Readable,
        BitsBuffer.BigEndian {
            private byte b;
            private int mask = 128;

            public BigEndian(byte b) {
                this.b = b;
            }

            @Override
            public boolean get() {
                boolean bit = (this.b & this.mask) != 0;
                this.mask >>= 1;
                return bit;
            }

            @Override
            public boolean hasRemaining() {
                return this.mask != 0;
            }

            @Override
            public int remaining() {
                switch (this.mask) {
                    case 128: {
                        return 8;
                    }
                    case 64: {
                        return 7;
                    }
                    case 32: {
                        return 6;
                    }
                    case 16: {
                        return 5;
                    }
                    case 8: {
                        return 4;
                    }
                    case 4: {
                        return 3;
                    }
                    case 2: {
                        return 2;
                    }
                    case 1: {
                        return 1;
                    }
                }
                return 0;
            }

            @Override
            public void alignToNextByte() {
                this.mask = 0;
            }
        }
    }
}

