/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.provider;

import java.io.File;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.provider.IOProvider;

public class FileIOProvider
implements IOProvider.ReadWrite.Seekable.KnownSize.Resizable {
    private File file;

    public FileIOProvider(File file) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Cannot provide IO on a directory");
        }
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public <T extends IO.Readable.Seekable & IO.KnownSize> T provideIOReadableSeekableKnownSize(Task.Priority priority) {
        return (T)new FileIO.ReadOnly(this.file, priority);
    }

    @Override
    public <T extends IO.Writable.Seekable & IO.Resizable> T provideIOWritableSeekableResizable(Task.Priority priority) {
        return (T)new FileIO.WriteOnly(this.file, priority);
    }

    @Override
    public <T extends IO.Readable.Seekable & IO.Writable.Seekable> T provideIOReadWriteSeekableResizable(Task.Priority priority) {
        return (T)new FileIO.ReadWrite(this.file, priority);
    }

    @Override
    public String getDescription() {
        return this.file.getAbsolutePath();
    }
}

