/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.util.ConcurrentCloseable;

public class BufferedWritableCharacterStream
extends ConcurrentCloseable<IOException>
implements ICharacterStream.Writable.Buffered {
    private IO.Writable output;
    private CharsetEncoder encoder;
    private char[] buffer;
    private char[] buffer2;
    private CharBuffer cb;
    private CharBuffer cb2;
    private ByteBuffer encodedBuffer;
    private int pos = 0;
    private Async<IOException> flushing = null;

    public BufferedWritableCharacterStream(IO.Writable output, Charset charset, int bufferSize) {
        this(output, charset.newEncoder(), bufferSize);
    }

    public BufferedWritableCharacterStream(IO.Writable output, CharsetEncoder encoder, int bufferSize) {
        this.output = output;
        this.encoder = encoder;
        this.buffer = new char[bufferSize];
        this.buffer2 = new char[bufferSize];
        this.cb = CharBuffer.wrap(this.buffer);
        this.cb2 = CharBuffer.wrap(this.buffer2);
        this.encodedBuffer = ByteBuffer.allocate(bufferSize * 2);
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        return this.output.closeAsync();
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.output = null;
        this.encoder = null;
        this.buffer = null;
        this.buffer2 = null;
        this.cb = null;
        this.cb2 = null;
        this.encodedBuffer = null;
        ondone.unblock();
    }

    @Override
    public Task.Priority getPriority() {
        return this.output.getPriority();
    }

    @Override
    public void setPriority(Task.Priority priority) {
        this.output.setPriority(priority);
    }

    @Override
    public String getDescription() {
        return this.output.getSourceDescription();
    }

    @Override
    public Charset getEncoding() {
        return this.encoder.charset();
    }

    private void encodeAndWrite() {
        Task.cpu("Encoding characters", this.output.getPriority(), task -> {
            this.encodedBuffer.clear();
            CoderResult result = this.encoder.encode(this.cb2, this.encodedBuffer, false);
            if (result.isError()) {
                this.flushing.error(new IOException("Encoding error"));
                return null;
            }
            this.encodedBuffer.flip();
            AsyncSupplier<Integer, IOException> writing = this.output.writeAsync(this.encodedBuffer);
            writing.onDone(() -> {
                if (!writing.isSuccessful()) {
                    this.flushing.error((IOException)writing.getError());
                } else if (result.isOverflow()) {
                    this.encodeAndWrite();
                } else {
                    this.cb2.clear();
                    this.flushing.unblock();
                }
            });
            return null;
        }).start();
        this.operation(this.flushing);
    }

    private IAsync<IOException> finalFlush(Async<IOException> sp, boolean flushOnly) {
        CoderResult result;
        this.encodedBuffer.clear();
        if (!flushOnly) {
            this.cb2.limit(this.pos);
            try {
                result = this.encoder.encode(this.cb2, this.encodedBuffer, true);
            }
            catch (Exception e) {
                return new Async<IOException>(new IOException("Error finalizing encoding", e));
            }
            if (!result.isOverflow()) {
                flushOnly = true;
                result = this.encoder.flush(this.encodedBuffer);
            }
        } else {
            result = this.encoder.flush(this.encodedBuffer);
        }
        this.encodedBuffer.flip();
        AsyncSupplier<Integer, IOException> writing = this.encodedBuffer.hasRemaining() ? this.output.writeAsync(this.encodedBuffer) : new AsyncSupplier<Integer, Object>(0, null);
        if (!result.isOverflow()) {
            if (sp == null) {
                return writing;
            }
            writing.onDone(sp);
            return this.operation(sp);
        }
        if (sp == null) {
            sp = new Async();
        }
        Async<IOException> spp = sp;
        boolean fo = flushOnly;
        writing.onDone(() -> {
            if (!writing.isSuccessful()) {
                spp.error((IOException)writing.getError());
            } else {
                this.finalFlush(spp, fo);
            }
        });
        return this.operation(sp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        while (true) {
            Async<IOException> sp;
            IO.Writable writable = this.output;
            synchronized (writable) {
                if (this.flushing != null && this.flushing.isDone()) {
                    if (this.flushing.hasError()) {
                        throw this.flushing.getError();
                    }
                    this.flushing = null;
                }
                if (this.flushing == null) {
                    char[] tmp1 = this.buffer2;
                    this.buffer2 = this.buffer;
                    this.buffer = tmp1;
                    CharBuffer tmp2 = this.cb2;
                    this.cb2 = this.cb;
                    this.cb = tmp2;
                    this.cb.clear();
                    this.flushing = new Async();
                    this.cb2.limit(this.pos);
                    this.encodeAndWrite();
                    this.pos = 0;
                    return;
                }
                sp = this.flushing;
            }
            sp.block(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Async<IOException> flushBufferAsync() {
        Async<IOException> sp;
        IO.Writable writable = this.output;
        synchronized (writable) {
            if (this.flushing != null && this.flushing.isDone()) {
                if (this.flushing.hasError()) {
                    return new Async<IOException>(this.flushing.getError());
                }
                this.flushing = null;
            }
            if (this.flushing == null) {
                char[] tmp1 = this.buffer2;
                this.buffer2 = this.buffer;
                this.buffer = tmp1;
                CharBuffer tmp2 = this.cb2;
                this.cb2 = this.cb;
                this.cb = tmp2;
                this.cb.clear();
                this.flushing = new Async();
                this.cb2.limit(this.pos);
                this.encodeAndWrite();
                this.pos = 0;
                return new Async<boolean>(true);
            }
            sp = this.flushing;
        }
        Async<IOException> result = new Async<IOException>();
        sp.onDone(() -> this.flushBufferAsync().onDone(result), result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAsync<IOException> flush() {
        Async<IOException> sp;
        IO.Writable writable = this.output;
        synchronized (writable) {
            if (this.flushing == null || this.flushing.isDone()) {
                if (this.pos == 0) {
                    return this.finalFlush(null, false);
                }
                try {
                    this.flushBuffer();
                }
                catch (IOException e) {
                    return new Async<IOException>(e);
                }
            }
            sp = this.flushing;
        }
        Async<IOException> sp2 = new Async<IOException>();
        sp.onDone(() -> {
            if (sp.hasError()) {
                sp2.error((IOException)sp.getError());
            } else {
                this.flush().onDone(sp2);
            }
        });
        return sp2;
    }

    @Override
    public void writeSync(char c) throws IOException {
        this.buffer[this.pos++] = c;
        if (this.pos == this.buffer.length) {
            this.flushBuffer();
        }
    }

    @Override
    public void writeSync(char[] c, int off, int len) throws IOException {
        while (len > 0) {
            int l = len > this.buffer.length - this.pos ? this.buffer.length - this.pos : len;
            System.arraycopy(c, off, this.buffer, this.pos, l);
            this.pos += l;
            if (this.pos == this.buffer.length) {
                this.flushBuffer();
            }
            off += l;
            len -= l;
        }
    }

    @Override
    public IAsync<IOException> writeAsync(char c) {
        this.buffer[this.pos++] = c;
        if (this.pos == this.buffer.length) {
            return this.flushBufferAsync();
        }
        return new Async<boolean>(true);
    }

    @Override
    public IAsync<IOException> writeAsync(char[] c, int off, int len) {
        Async<IOException> result = new Async<IOException>();
        this.writeAsync(c, off, len, result);
        return this.operation(result);
    }

    private void writeAsync(char[] c, int off, int len, Async<IOException> result) {
        int l = len > this.buffer.length - this.pos ? this.buffer.length - this.pos : len;
        System.arraycopy(c, off, this.buffer, this.pos, l);
        this.pos += l;
        if (l == len) {
            if (this.pos == this.buffer.length) {
                this.flushBufferAsync().onDone(result);
            } else {
                result.unblock();
            }
            return;
        }
        this.flushBufferAsync().thenStart("BufferedWritableCharacterStream.writeAsync", this.output.getPriority(), () -> this.writeAsync(c, off + l, len - l, result), result);
    }
}

