/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.data.Bytes;

public interface DataUtil {

    public static interface Write64 {

        public static interface LE {
            public static void write(byte[] buffer, int offset, long value) {
                buffer[offset++] = (byte)(value & 0xFFL);
                buffer[offset++] = (byte)(value >> 8 & 0xFFL);
                buffer[offset++] = (byte)(value >> 16 & 0xFFL);
                buffer[offset++] = (byte)(value >> 24 & 0xFFL);
                buffer[offset++] = (byte)(value >> 32 & 0xFFL);
                buffer[offset++] = (byte)(value >> 40 & 0xFFL);
                buffer[offset++] = (byte)(value >> 48 & 0xFFL);
                buffer[offset] = (byte)(value >> 56 & 0xFFL);
            }

            public static void write(ByteBuffer buf, long value) {
                buf.put((byte)(value & 0xFFL));
                buf.put((byte)(value >> 8 & 0xFFL));
                buf.put((byte)(value >> 16 & 0xFFL));
                buf.put((byte)(value >> 24 & 0xFFL));
                buf.put((byte)(value >> 32 & 0xFFL));
                buf.put((byte)(value >> 40 & 0xFFL));
                buf.put((byte)(value >> 48 & 0xFFL));
                buf.put((byte)(value >> 56 & 0xFFL));
            }

            public static void write(Bytes.Writable buf, long value) {
                buf.put((byte)(value & 0xFFL));
                buf.put((byte)(value >> 8 & 0xFFL));
                buf.put((byte)(value >> 16 & 0xFFL));
                buf.put((byte)(value >> 24 & 0xFFL));
                buf.put((byte)(value >> 32 & 0xFFL));
                buf.put((byte)(value >> 40 & 0xFFL));
                buf.put((byte)(value >> 48 & 0xFFL));
                buf.put((byte)(value >> 56 & 0xFFL));
            }

            public static void write(IO.WritableByteStream io, long value) throws IOException {
                io.write((byte)(value & 0xFFL));
                io.write((byte)(value >> 8 & 0xFFL));
                io.write((byte)(value >> 16 & 0xFFL));
                io.write((byte)(value >> 24 & 0xFFL));
                io.write((byte)(value >> 32 & 0xFFL));
                io.write((byte)(value >> 40 & 0xFFL));
                io.write((byte)(value >> 48 & 0xFFL));
                io.write((byte)(value >> 56 & 0xFFL));
            }

            public static void write(OutputStream io, long value) throws IOException {
                io.write((int)(value & 0xFFL));
                io.write((int)(value >> 8 & 0xFFL));
                io.write((int)(value >> 16 & 0xFFL));
                io.write((int)(value >> 24 & 0xFFL));
                io.write((int)(value >> 32 & 0xFFL));
                io.write((int)(value >> 40 & 0xFFL));
                io.write((int)(value >> 48 & 0xFFL));
                io.write((int)(value >> 56 & 0xFFL));
            }
        }

        public static interface BE {
            public static void write(byte[] buffer, int offset, long value) {
                buffer[offset++] = (byte)(value >> 56 & 0xFFL);
                buffer[offset++] = (byte)(value >> 48 & 0xFFL);
                buffer[offset++] = (byte)(value >> 40 & 0xFFL);
                buffer[offset++] = (byte)(value >> 32 & 0xFFL);
                buffer[offset++] = (byte)(value >> 24 & 0xFFL);
                buffer[offset++] = (byte)(value >> 16 & 0xFFL);
                buffer[offset++] = (byte)(value >> 8 & 0xFFL);
                buffer[offset] = (byte)(value & 0xFFL);
            }

            public static void write(ByteBuffer buf, long value) {
                buf.put((byte)(value >> 56 & 0xFFL));
                buf.put((byte)(value >> 48 & 0xFFL));
                buf.put((byte)(value >> 40 & 0xFFL));
                buf.put((byte)(value >> 32 & 0xFFL));
                buf.put((byte)(value >> 24 & 0xFFL));
                buf.put((byte)(value >> 16 & 0xFFL));
                buf.put((byte)(value >> 8 & 0xFFL));
                buf.put((byte)(value & 0xFFL));
            }

            public static void write(Bytes.Writable buf, long value) {
                buf.put((byte)(value >> 56 & 0xFFL));
                buf.put((byte)(value >> 48 & 0xFFL));
                buf.put((byte)(value >> 40 & 0xFFL));
                buf.put((byte)(value >> 32 & 0xFFL));
                buf.put((byte)(value >> 24 & 0xFFL));
                buf.put((byte)(value >> 16 & 0xFFL));
                buf.put((byte)(value >> 8 & 0xFFL));
                buf.put((byte)(value & 0xFFL));
            }

            public static void write(IO.WritableByteStream io, long value) throws IOException {
                io.write((byte)(value >> 56 & 0xFFL));
                io.write((byte)(value >> 48 & 0xFFL));
                io.write((byte)(value >> 40 & 0xFFL));
                io.write((byte)(value >> 32 & 0xFFL));
                io.write((byte)(value >> 24 & 0xFFL));
                io.write((byte)(value >> 16 & 0xFFL));
                io.write((byte)(value >> 8 & 0xFFL));
                io.write((byte)(value & 0xFFL));
            }

            public static void write(OutputStream io, long value) throws IOException {
                io.write((int)(value >> 56 & 0xFFL));
                io.write((int)(value >> 48 & 0xFFL));
                io.write((int)(value >> 40 & 0xFFL));
                io.write((int)(value >> 32 & 0xFFL));
                io.write((int)(value >> 24 & 0xFFL));
                io.write((int)(value >> 16 & 0xFFL));
                io.write((int)(value >> 8 & 0xFFL));
                io.write((int)(value & 0xFFL));
            }
        }
    }

    public static interface Read64 {

        public static interface LE {
            public static long read(byte[] buffer, int offset) {
                long value = buffer[offset] & 0xFF;
                value |= (long)((buffer[offset + 1] & 0xFF) << 8);
                value |= (long)((buffer[offset + 2] & 0xFF) << 16);
                value |= (long)(buffer[offset + 3] & 0xFF) << 24;
                value |= (long)(buffer[offset + 4] & 0xFF) << 32;
                value |= (long)(buffer[offset + 5] & 0xFF) << 40;
                value |= (long)(buffer[offset + 6] & 0xFF) << 48;
                return value |= (long)(buffer[offset + 7] & 0xFF) << 56;
            }

            public static long read(ByteBuffer buf) {
                long value = buf.get() & 0xFF;
                value |= (long)((buf.get() & 0xFF) << 8);
                value |= (long)((buf.get() & 0xFF) << 16);
                value |= (long)(buf.get() & 0xFF) << 24;
                value |= (long)(buf.get() & 0xFF) << 32;
                value |= (long)(buf.get() & 0xFF) << 40;
                value |= (long)(buf.get() & 0xFF) << 48;
                return value |= (long)(buf.get() & 0xFF) << 56;
            }

            public static long read(Bytes.Readable buf) {
                long value = buf.get() & 0xFF;
                value |= (long)((buf.get() & 0xFF) << 8);
                value |= (long)((buf.get() & 0xFF) << 16);
                value |= (long)(buf.get() & 0xFF) << 24;
                value |= (long)(buf.get() & 0xFF) << 32;
                value |= (long)(buf.get() & 0xFF) << 40;
                value |= (long)(buf.get() & 0xFF) << 48;
                return value |= (long)(buf.get() & 0xFF) << 56;
            }

            public static long read(IO.ReadableByteStream io) throws IOException {
                long value = io.read();
                if (value < 0L) {
                    throw new EOFException();
                }
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)(i << 8);
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)(i << 16);
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)i << 24;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)i << 32;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)i << 40;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)i << 48;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value |= (long)i << 56;
            }

            public static long read(InputStream io) throws IOException {
                long value = io.read();
                if (value < 0L) {
                    throw new EOFException();
                }
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)(i << 8);
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)(i << 16);
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)i << 24;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)i << 32;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)i << 40;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)i << 48;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value |= (long)i << 56;
            }
        }

        public static interface BE {
            public static long read(byte[] buffer, int offset) {
                long value = (long)(buffer[offset] & 0xFF) << 56;
                value |= (long)(buffer[offset + 1] & 0xFF) << 48;
                value |= (long)(buffer[offset + 2] & 0xFF) << 40;
                value |= (long)(buffer[offset + 3] & 0xFF) << 32;
                value |= (long)(buffer[offset + 4] & 0xFF) << 24;
                value |= (long)((buffer[offset + 5] & 0xFF) << 16);
                value |= (long)((buffer[offset + 6] & 0xFF) << 8);
                return value |= (long)(buffer[offset + 7] & 0xFF);
            }

            public static long read(ByteBuffer buf) {
                long value = (long)(buf.get() & 0xFF) << 56;
                value |= (long)(buf.get() & 0xFF) << 48;
                value |= (long)(buf.get() & 0xFF) << 40;
                value |= (long)(buf.get() & 0xFF) << 32;
                value |= (long)(buf.get() & 0xFF) << 24;
                value |= (long)((buf.get() & 0xFF) << 16);
                value |= (long)((buf.get() & 0xFF) << 8);
                return value |= (long)(buf.get() & 0xFF);
            }

            public static long read(Bytes.Readable buf) {
                long value = (long)(buf.get() & 0xFF) << 56;
                value |= (long)(buf.get() & 0xFF) << 48;
                value |= (long)(buf.get() & 0xFF) << 40;
                value |= (long)(buf.get() & 0xFF) << 32;
                value |= (long)(buf.get() & 0xFF) << 24;
                value |= (long)((buf.get() & 0xFF) << 16);
                value |= (long)((buf.get() & 0xFF) << 8);
                return value |= (long)(buf.get() & 0xFF);
            }

            public static long read(IO.ReadableByteStream io) throws IOException {
                long value = io.read();
                if (value < 0L) {
                    throw new EOFException();
                }
                value <<= 56;
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)i << 48;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)i << 40;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)i << 32;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)i << 24;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)(i << 16);
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)(i << 8);
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value |= (long)i;
            }

            public static long read(InputStream io) throws IOException {
                long value = io.read();
                if (value < 0L) {
                    throw new EOFException();
                }
                value <<= 56;
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)i << 48;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)i << 40;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)i << 32;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)i << 24;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)(i << 16);
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)(i << 8);
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value |= (long)i;
            }
        }
    }

    public static interface Write32U {

        public static interface LE {
            public static void write(byte[] buffer, int offset, long value) {
                buffer[offset++] = (byte)(value & 0xFFL);
                buffer[offset++] = (byte)(value >> 8 & 0xFFL);
                buffer[offset++] = (byte)(value >> 16 & 0xFFL);
                buffer[offset] = (byte)(value >> 24 & 0xFFL);
            }

            public static void write(ByteBuffer buf, long value) {
                buf.put((byte)(value & 0xFFL));
                buf.put((byte)(value >> 8 & 0xFFL));
                buf.put((byte)(value >> 16 & 0xFFL));
                buf.put((byte)(value >> 24 & 0xFFL));
            }

            public static void write(Bytes.Writable buf, long value) {
                buf.put((byte)(value & 0xFFL));
                buf.put((byte)(value >> 8 & 0xFFL));
                buf.put((byte)(value >> 16 & 0xFFL));
                buf.put((byte)(value >> 24 & 0xFFL));
            }

            public static void write(IO.WritableByteStream io, long value) throws IOException {
                io.write((byte)(value & 0xFFL));
                io.write((byte)(value >> 8 & 0xFFL));
                io.write((byte)(value >> 16 & 0xFFL));
                io.write((byte)(value >> 24 & 0xFFL));
            }

            public static void write(OutputStream io, long value) throws IOException {
                io.write((int)(value & 0xFFL));
                io.write((int)(value >> 8 & 0xFFL));
                io.write((int)(value >> 16 & 0xFFL));
                io.write((int)(value >> 24 & 0xFFL));
            }
        }

        public static interface BE {
            public static void write(byte[] buffer, int offset, long value) {
                buffer[offset++] = (byte)(value >> 24 & 0xFFL);
                buffer[offset++] = (byte)(value >> 16 & 0xFFL);
                buffer[offset++] = (byte)(value >> 8 & 0xFFL);
                buffer[offset] = (byte)(value & 0xFFL);
            }

            public static void write(ByteBuffer buf, long value) {
                buf.put((byte)(value >> 24 & 0xFFL));
                buf.put((byte)(value >> 16 & 0xFFL));
                buf.put((byte)(value >> 8 & 0xFFL));
                buf.put((byte)(value & 0xFFL));
            }

            public static void write(Bytes.Writable buf, long value) {
                buf.put((byte)(value >> 24 & 0xFFL));
                buf.put((byte)(value >> 16 & 0xFFL));
                buf.put((byte)(value >> 8 & 0xFFL));
                buf.put((byte)(value & 0xFFL));
            }

            public static void write(IO.WritableByteStream io, long value) throws IOException {
                io.write((byte)(value >> 24 & 0xFFL));
                io.write((byte)(value >> 16 & 0xFFL));
                io.write((byte)(value >> 8 & 0xFFL));
                io.write((byte)(value & 0xFFL));
            }

            public static void write(OutputStream io, long value) throws IOException {
                io.write((int)(value >> 24 & 0xFFL));
                io.write((int)(value >> 16 & 0xFFL));
                io.write((int)(value >> 8 & 0xFFL));
                io.write((int)(value & 0xFFL));
            }
        }
    }

    public static interface Read32U {

        public static interface LE {
            public static long read(byte[] buffer, int offset) {
                long value = buffer[offset] & 0xFF;
                value |= (long)((buffer[offset + 1] & 0xFF) << 8);
                value |= (long)((buffer[offset + 2] & 0xFF) << 16);
                return value |= (long)(buffer[offset + 3] & 0xFF) << 24;
            }

            public static long read(ByteBuffer buf) {
                long value = buf.get() & 0xFF;
                value |= (long)((buf.get() & 0xFF) << 8);
                value |= (long)((buf.get() & 0xFF) << 16);
                return value |= (long)(buf.get() & 0xFF) << 24;
            }

            public static long read(Bytes.Readable buf) {
                long value = buf.get() & 0xFF;
                value |= (long)((buf.get() & 0xFF) << 8);
                value |= (long)((buf.get() & 0xFF) << 16);
                return value |= (long)(buf.get() & 0xFF) << 24;
            }

            public static long read(IO.ReadableByteStream io) throws IOException {
                long value = io.read();
                if (value < 0L) {
                    throw new EOFException();
                }
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)(i << 8);
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)(i << 16);
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value |= (long)i << 24;
            }

            public static long read(InputStream io) throws IOException {
                long value = io.read();
                if (value < 0L) {
                    throw new EOFException();
                }
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)(i << 8);
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)(i << 16);
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value |= (long)i << 24;
            }
        }

        public static interface BE {
            public static long read(byte[] buffer, int offset) {
                long value = buffer[offset + 3] & 0xFF;
                value |= (long)((buffer[offset + 2] & 0xFF) << 8);
                value |= (long)((buffer[offset + 1] & 0xFF) << 16);
                return value |= (long)(buffer[offset] & 0xFF) << 24;
            }

            public static long read(ByteBuffer buf) {
                long value = (long)(buf.get() & 0xFF) << 24;
                value |= (long)((buf.get() & 0xFF) << 16);
                value |= (long)((buf.get() & 0xFF) << 8);
                return value |= (long)(buf.get() & 0xFF);
            }

            public static long read(Bytes.Readable buf) {
                long value = (long)(buf.get() & 0xFF) << 24;
                value |= (long)((buf.get() & 0xFF) << 16);
                value |= (long)((buf.get() & 0xFF) << 8);
                return value |= (long)(buf.get() & 0xFF);
            }

            public static long read(IO.ReadableByteStream io) throws IOException {
                long value = io.read();
                if (value < 0L) {
                    throw new EOFException();
                }
                value <<= 24;
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)(i << 16);
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)(i << 8);
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value |= (long)i;
            }

            public static long read(InputStream io) throws IOException {
                long value = io.read();
                if (value < 0L) {
                    throw new EOFException();
                }
                value <<= 24;
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)(i << 16);
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= (long)(i << 8);
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value |= (long)i;
            }
        }
    }

    public static interface Write32 {

        public static interface LE {
            public static void write(byte[] buffer, int offset, int value) {
                buffer[offset++] = (byte)(value & 0xFF);
                buffer[offset++] = (byte)(value >> 8 & 0xFF);
                buffer[offset++] = (byte)(value >> 16 & 0xFF);
                buffer[offset] = (byte)(value >> 24 & 0xFF);
            }

            public static void write(ByteBuffer buf, int value) {
                buf.put((byte)(value & 0xFF));
                buf.put((byte)(value >> 8 & 0xFF));
                buf.put((byte)(value >> 16 & 0xFF));
                buf.put((byte)(value >> 24 & 0xFF));
            }

            public static void write(Bytes.Writable buf, int value) {
                buf.put((byte)(value & 0xFF));
                buf.put((byte)(value >> 8 & 0xFF));
                buf.put((byte)(value >> 16 & 0xFF));
                buf.put((byte)(value >> 24 & 0xFF));
            }

            public static void write(IO.WritableByteStream io, int value) throws IOException {
                io.write((byte)(value & 0xFF));
                io.write((byte)(value >> 8 & 0xFF));
                io.write((byte)(value >> 16 & 0xFF));
                io.write((byte)(value >> 24 & 0xFF));
            }

            public static void write(OutputStream io, int value) throws IOException {
                io.write(value & 0xFF);
                io.write(value >> 8 & 0xFF);
                io.write(value >> 16 & 0xFF);
                io.write(value >> 24 & 0xFF);
            }
        }

        public static interface BE {
            public static void write(byte[] buffer, int offset, int value) {
                buffer[offset++] = (byte)(value >> 24 & 0xFF);
                buffer[offset++] = (byte)(value >> 16 & 0xFF);
                buffer[offset++] = (byte)(value >> 8 & 0xFF);
                buffer[offset] = (byte)(value & 0xFF);
            }

            public static void write(ByteBuffer buf, int value) {
                buf.put((byte)(value >> 24 & 0xFF));
                buf.put((byte)(value >> 16 & 0xFF));
                buf.put((byte)(value >> 8 & 0xFF));
                buf.put((byte)(value & 0xFF));
            }

            public static void write(Bytes.Writable buf, int value) {
                buf.put((byte)(value >> 24 & 0xFF));
                buf.put((byte)(value >> 16 & 0xFF));
                buf.put((byte)(value >> 8 & 0xFF));
                buf.put((byte)(value & 0xFF));
            }

            public static void write(IO.WritableByteStream io, int value) throws IOException {
                io.write((byte)(value >> 24 & 0xFF));
                io.write((byte)(value >> 16 & 0xFF));
                io.write((byte)(value >> 8 & 0xFF));
                io.write((byte)(value & 0xFF));
            }

            public static void write(OutputStream io, int value) throws IOException {
                io.write(value >> 24 & 0xFF);
                io.write(value >> 16 & 0xFF);
                io.write(value >> 8 & 0xFF);
                io.write(value & 0xFF);
            }
        }
    }

    public static interface Read32 {

        public static interface LE {
            public static int read(byte[] buffer, int offset) {
                int value = buffer[offset] & 0xFF;
                value |= (buffer[offset + 1] & 0xFF) << 8;
                value |= (buffer[offset + 2] & 0xFF) << 16;
                return value |= (buffer[offset + 3] & 0xFF) << 24;
            }

            public static int read(ByteBuffer buf) {
                int value = buf.get() & 0xFF;
                value |= (buf.get() & 0xFF) << 8;
                value |= (buf.get() & 0xFF) << 16;
                return value |= (buf.get() & 0xFF) << 24;
            }

            public static int read(Bytes.Readable buf) {
                int value = buf.get() & 0xFF;
                value |= (buf.get() & 0xFF) << 8;
                value |= (buf.get() & 0xFF) << 16;
                return value |= (buf.get() & 0xFF) << 24;
            }

            public static int read(IO.ReadableByteStream io) throws IOException {
                int value = io.read();
                if (value < 0) {
                    throw new EOFException();
                }
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= i << 8;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= i << 16;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value |= i << 24;
            }

            public static int read(InputStream io) throws IOException {
                int value = io.read();
                if (value < 0) {
                    throw new EOFException();
                }
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= i << 8;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= i << 16;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value |= i << 24;
            }
        }

        public static interface BE {
            public static int read(byte[] buffer, int offset) {
                int value = (buffer[offset] & 0xFF) << 24;
                value |= (buffer[offset + 1] & 0xFF) << 16;
                value |= (buffer[offset + 2] & 0xFF) << 8;
                return value |= buffer[offset + 3] & 0xFF;
            }

            public static int read(ByteBuffer buf) {
                int value = (buf.get() & 0xFF) << 24;
                value |= (buf.get() & 0xFF) << 16;
                value |= (buf.get() & 0xFF) << 8;
                return value |= buf.get() & 0xFF;
            }

            public static int read(Bytes.Readable buf) {
                int value = (buf.get() & 0xFF) << 24;
                value |= (buf.get() & 0xFF) << 16;
                value |= (buf.get() & 0xFF) << 8;
                return value |= buf.get() & 0xFF;
            }

            public static int read(IO.ReadableByteStream io) throws IOException {
                int value = io.read();
                if (value < 0) {
                    throw new EOFException();
                }
                value <<= 24;
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= i << 16;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= i << 8;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value |= i;
            }

            public static int read(InputStream io) throws IOException {
                int value = io.read();
                if (value < 0) {
                    throw new EOFException();
                }
                value <<= 24;
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= i << 16;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= i << 8;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value |= i;
            }
        }
    }

    public static interface Write24U {

        public static interface LE {
            public static void write(byte[] buffer, int offset, int value) {
                buffer[offset++] = (byte)(value & 0xFF);
                buffer[offset++] = (byte)(value >> 8 & 0xFF);
                buffer[offset] = (byte)(value >> 16 & 0xFF);
            }

            public static void write(ByteBuffer buf, int value) {
                buf.put((byte)(value & 0xFF));
                buf.put((byte)(value >> 8 & 0xFF));
                buf.put((byte)(value >> 16 & 0xFF));
            }

            public static void write(Bytes.Writable buf, int value) {
                buf.put((byte)(value & 0xFF));
                buf.put((byte)(value >> 8 & 0xFF));
                buf.put((byte)(value >> 16 & 0xFF));
            }

            public static void write(IO.WritableByteStream io, int value) throws IOException {
                io.write((byte)(value & 0xFF));
                io.write((byte)(value >> 8 & 0xFF));
                io.write((byte)(value >> 16 & 0xFF));
            }

            public static void write(OutputStream io, int value) throws IOException {
                io.write(value & 0xFF);
                io.write(value >> 8 & 0xFF);
                io.write(value >> 16 & 0xFF);
            }
        }

        public static interface BE {
            public static void write(byte[] buffer, int offset, int value) {
                buffer[offset++] = (byte)(value >> 16 & 0xFF);
                buffer[offset++] = (byte)(value >> 8 & 0xFF);
                buffer[offset] = (byte)(value & 0xFF);
            }

            public static void write(ByteBuffer buf, int value) {
                buf.put((byte)(value >> 16 & 0xFF));
                buf.put((byte)(value >> 8 & 0xFF));
                buf.put((byte)(value & 0xFF));
            }

            public static void write(Bytes.Writable buf, int value) {
                buf.put((byte)(value >> 16 & 0xFF));
                buf.put((byte)(value >> 8 & 0xFF));
                buf.put((byte)(value & 0xFF));
            }

            public static void write(IO.WritableByteStream io, int value) throws IOException {
                io.write((byte)(value >> 16 & 0xFF));
                io.write((byte)(value >> 8 & 0xFF));
                io.write((byte)(value & 0xFF));
            }

            public static void write(OutputStream io, int value) throws IOException {
                io.write(value >> 16 & 0xFF);
                io.write(value >> 8 & 0xFF);
                io.write(value & 0xFF);
            }
        }
    }

    public static interface Read24U {

        public static interface LE {
            public static int read(byte[] buffer, int offset) {
                int value = buffer[offset] & 0xFF;
                value |= (buffer[offset + 1] & 0xFF) << 8;
                return value |= (buffer[offset + 2] & 0xFF) << 16;
            }

            public static int read(ByteBuffer buf) {
                int value = buf.get() & 0xFF;
                value |= (buf.get() & 0xFF) << 8;
                return value |= (buf.get() & 0xFF) << 16;
            }

            public static int read(Bytes.Readable buf) {
                int value = buf.get() & 0xFF;
                value |= (buf.get() & 0xFF) << 8;
                return value |= (buf.get() & 0xFF) << 16;
            }

            public static int read(IO.ReadableByteStream io) throws IOException {
                int value = io.read();
                if (value < 0) {
                    throw new EOFException();
                }
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= i << 8;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value |= i << 16;
            }

            public static int read(InputStream io) throws IOException {
                int value = io.read();
                if (value < 0) {
                    throw new EOFException();
                }
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= i << 8;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value |= i << 16;
            }
        }

        public static interface BE {
            public static int read(byte[] buffer, int offset) {
                int value = buffer[offset + 2] & 0xFF;
                value |= (buffer[offset + 1] & 0xFF) << 8;
                return value |= (buffer[offset] & 0xFF) << 16;
            }

            public static int read(ByteBuffer buf) {
                int value = (buf.get() & 0xFF) << 16;
                value |= (buf.get() & 0xFF) << 8;
                return value |= buf.get() & 0xFF;
            }

            public static int read(Bytes.Readable buf) {
                int value = (buf.get() & 0xFF) << 16;
                value |= (buf.get() & 0xFF) << 8;
                return value |= buf.get() & 0xFF;
            }

            public static int read(IO.ReadableByteStream io) throws IOException {
                int value = io.read();
                if (value < 0) {
                    throw new EOFException();
                }
                value <<= 16;
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= i << 8;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value |= i;
            }

            public static int read(InputStream io) throws IOException {
                int value = io.read();
                if (value < 0) {
                    throw new EOFException();
                }
                value <<= 16;
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                value |= i << 8;
                i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value |= i;
            }
        }
    }

    public static interface Write16U {

        public static interface LE {
            public static void write(byte[] buffer, int offset, int value) {
                buffer[offset++] = (byte)(value & 0xFF);
                buffer[offset] = (byte)(value >> 8 & 0xFF);
            }

            public static void write(ByteBuffer buf, int value) {
                buf.put((byte)(value & 0xFF));
                buf.put((byte)(value >> 8 & 0xFF));
            }

            public static void write(Bytes.Writable buf, int value) {
                buf.put((byte)(value & 0xFF));
                buf.put((byte)(value >> 8 & 0xFF));
            }

            public static void write(IO.WritableByteStream io, int value) throws IOException {
                io.write((byte)(value & 0xFF));
                io.write((byte)(value >> 8 & 0xFF));
            }

            public static void write(OutputStream io, int value) throws IOException {
                io.write(value & 0xFF);
                io.write(value >> 8 & 0xFF);
            }
        }

        public static interface BE {
            public static void write(byte[] buffer, int offset, int value) {
                buffer[offset++] = (byte)(value >> 8 & 0xFF);
                buffer[offset] = (byte)(value & 0xFF);
            }

            public static void write(ByteBuffer buf, int value) {
                buf.put((byte)(value >> 8 & 0xFF));
                buf.put((byte)(value & 0xFF));
            }

            public static void write(Bytes.Writable buf, int value) {
                buf.put((byte)(value >> 8 & 0xFF));
                buf.put((byte)(value & 0xFF));
            }

            public static void write(IO.WritableByteStream io, int value) throws IOException {
                io.write((byte)(value >> 8 & 0xFF));
                io.write((byte)(value & 0xFF));
            }

            public static void write(OutputStream io, int value) throws IOException {
                io.write(value >> 8 & 0xFF);
                io.write(value & 0xFF);
            }
        }
    }

    public static interface Read16U {

        public static interface LE {
            public static int read(byte[] buffer, int offset) {
                return buffer[offset] & 0xFF | (buffer[offset + 1] & 0xFF) << 8;
            }

            public static int read(ByteBuffer buf) {
                return buf.get() & 0xFF | (buf.get() & 0xFF) << 8;
            }

            public static int read(Bytes.Readable buf) {
                return buf.get() & 0xFF | (buf.get() & 0xFF) << 8;
            }

            public static int read(IO.ReadableByteStream io) throws IOException {
                int value = io.read();
                if (value < 0) {
                    throw new EOFException();
                }
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value | i << 8;
            }

            public static int read(InputStream io) throws IOException {
                int value = io.read();
                if (value < 0) {
                    throw new EOFException();
                }
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value | i << 8;
            }
        }

        public static interface BE {
            public static int read(byte[] buffer, int offset) {
                return (buffer[offset] & 0xFF) << 8 | buffer[offset + 1] & 0xFF;
            }

            public static int read(ByteBuffer buf) {
                int value = (buf.get() & 0xFF) << 8;
                return value |= buf.get() & 0xFF;
            }

            public static int read(Bytes.Readable buf) {
                int value = (buf.get() & 0xFF) << 8;
                return value |= buf.get() & 0xFF;
            }

            public static int read(IO.ReadableByteStream io) throws IOException {
                int value = io.read();
                if (value < 0) {
                    throw new EOFException();
                }
                value <<= 8;
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value | i;
            }

            public static int read(InputStream io) throws IOException {
                int value = io.read();
                if (value < 0) {
                    throw new EOFException();
                }
                value <<= 8;
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return value | i;
            }
        }
    }

    public static interface Write16 {

        public static interface LE {
            public static void write(byte[] buffer, int offset, short value) {
                buffer[offset++] = (byte)(value & 0xFF);
                buffer[offset] = (byte)(value >> 8 & 0xFF);
            }

            public static void write(ByteBuffer buf, short value) {
                buf.put((byte)(value & 0xFF));
                buf.put((byte)(value >> 8 & 0xFF));
            }

            public static void write(Bytes.Writable buf, short value) {
                buf.put((byte)(value & 0xFF));
                buf.put((byte)(value >> 8 & 0xFF));
            }

            public static void write(IO.WritableByteStream io, short value) throws IOException {
                io.write((byte)(value & 0xFF));
                io.write((byte)(value >> 8 & 0xFF));
            }

            public static void write(OutputStream io, short value) throws IOException {
                io.write(value & 0xFF);
                io.write(value >> 8 & 0xFF);
            }
        }

        public static interface BE {
            public static void write(byte[] buffer, int offset, short value) {
                buffer[offset++] = (byte)(value >> 8 & 0xFF);
                buffer[offset] = (byte)(value & 0xFF);
            }

            public static void write(ByteBuffer buf, short value) {
                buf.put((byte)(value >> 8 & 0xFF));
                buf.put((byte)(value & 0xFF));
            }

            public static void write(Bytes.Writable buf, short value) {
                buf.put((byte)(value >> 8 & 0xFF));
                buf.put((byte)(value & 0xFF));
            }

            public static void write(IO.WritableByteStream io, short value) throws IOException {
                io.write((byte)(value >> 8 & 0xFF));
                io.write((byte)(value & 0xFF));
            }

            public static void write(OutputStream io, short value) throws IOException {
                io.write(value >> 8 & 0xFF);
                io.write(value & 0xFF);
            }
        }
    }

    public static interface Read16 {

        public static interface LE {
            public static short read(byte[] buffer, int offset) {
                return (short)(buffer[offset] & 0xFF | (buffer[offset + 1] & 0xFF) << 8);
            }

            public static short read(ByteBuffer buf) {
                return (short)(buf.get() & 0xFF | (buf.get() & 0xFF) << 8);
            }

            public static short read(Bytes.Readable buf) {
                return (short)(buf.get() & 0xFF | (buf.get() & 0xFF) << 8);
            }

            public static short read(IO.ReadableByteStream io) throws IOException {
                int value = io.read();
                if (value < 0) {
                    throw new EOFException();
                }
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return (short)(value | i << 8);
            }

            public static short read(InputStream io) throws IOException {
                int value = io.read();
                if (value < 0) {
                    throw new EOFException();
                }
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return (short)(value | i << 8);
            }
        }

        public static interface BE {
            public static short read(byte[] buffer, int offset) {
                return (short)((buffer[offset] & 0xFF) << 8 | buffer[offset + 1] & 0xFF);
            }

            public static short read(ByteBuffer buf) {
                short value = (short)((buf.get() & 0xFF) << 8);
                value = (short)(value | buf.get() & 0xFF);
                return value;
            }

            public static short read(Bytes.Readable buf) {
                short value = (short)((buf.get() & 0xFF) << 8);
                value = (short)(value | buf.get() & 0xFF);
                return value;
            }

            public static short read(IO.ReadableByteStream io) throws IOException {
                int value = io.read();
                if (value < 0) {
                    throw new EOFException();
                }
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return (short)(i | value << 8);
            }

            public static short read(InputStream io) throws IOException {
                int value = io.read();
                if (value < 0) {
                    throw new EOFException();
                }
                int i = io.read();
                if (i < 0) {
                    throw new EOFException();
                }
                return (short)(i | value << 8);
            }
        }
    }
}

