/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.log;

import java.util.HashMap;
import java.util.Map;
import net.lecousin.framework.log.LogPattern;
import net.lecousin.framework.log.LoggerFactory;
import net.lecousin.framework.log.appenders.Appender;

public class Logger {
    private LoggerFactory factory;
    private String name;
    private Appender appender;
    private int level;
    private Logger parent;
    private Map<String, Logger> children = new HashMap<String, Logger>(10);

    Logger(LoggerFactory factory, Logger parent, String name, Appender appender, Level level) {
        this.factory = factory;
        this.name = name;
        this.appender = appender;
        this.level = level != null ? level.ordinal() : -1;
        this.parent = parent;
    }

    public void setLevel(Level level) {
        this.level = level != null ? level.ordinal() : -1;
    }

    void setAppender(Appender appender) {
        this.appender = appender;
    }

    private int getLevel() {
        if (this.level != -1) {
            return this.level;
        }
        if (this.appender != null) {
            return this.appender.level();
        }
        return this.parent.getLevel();
    }

    private Appender getAppender() {
        if (this.appender != null) {
            return this.appender;
        }
        return this.parent.getAppender();
    }

    Logger createChild(String parentPrefix, String subName, Appender appender, Level level) {
        int i = subName.indexOf(46, 1);
        char sep = '.';
        if (i < 0) {
            i = subName.indexOf(36, 1);
            sep = '$';
        }
        if (i > 0) {
            String childName = subName.substring(0, i);
            Logger child = this.children.get(childName);
            if (child == null) {
                child = new Logger(this.factory, this, parentPrefix + childName, null, null);
                this.children.put(childName, child);
            }
            return child.createChild(parentPrefix + childName + sep, subName.substring(i + 1), appender, level);
        }
        Logger child = new Logger(this.factory, this, parentPrefix + subName, appender, level);
        this.children.put(subName, child);
        return child;
    }

    private void logMessage(Level level, String message, Throwable t) {
        StackTraceElement[] stack;
        LogPattern.Log log = new LogPattern.Log();
        log.timestamp = System.currentTimeMillis();
        log.loggerName = this.name;
        log.level = level;
        log.message = message;
        log.trace = t;
        log.app = this.factory.application;
        Appender appendr = this.getAppender();
        if (appendr.needsThreadName()) {
            log.threadName = Thread.currentThread().getName();
        }
        if (appendr.needsLocation() && (stack = new Exception().getStackTrace()) != null) {
            for (int i = 0; i < stack.length; ++i) {
                if (Logger.class.getName().equals(stack[i].getClassName())) continue;
                log.location = stack[i];
                break;
            }
        }
        this.factory.thread.log(appendr, log);
    }

    public void log(Level level, String message) {
        if (level.ordinal() < this.getLevel()) {
            return;
        }
        this.logMessage(level, message, null);
    }

    public void log(Level level, String message, Throwable t) {
        if (level.ordinal() < this.getLevel()) {
            return;
        }
        this.logMessage(level, message, t);
    }

    public boolean trace() {
        return this.getLevel() <= Level.TRACE.ordinal();
    }

    public void trace(String message) {
        if (this.getLevel() > Level.TRACE.ordinal()) {
            return;
        }
        this.logMessage(Level.TRACE, message, null);
    }

    public void trace(String message, Throwable t) {
        if (this.getLevel() > Level.TRACE.ordinal()) {
            return;
        }
        this.logMessage(Level.TRACE, message, t);
    }

    public boolean debug() {
        return this.getLevel() <= Level.DEBUG.ordinal();
    }

    public void debug(String message) {
        if (this.getLevel() > Level.DEBUG.ordinal()) {
            return;
        }
        this.logMessage(Level.DEBUG, message, null);
    }

    public void debug(String message, Throwable t) {
        if (this.getLevel() > Level.DEBUG.ordinal()) {
            return;
        }
        this.logMessage(Level.DEBUG, message, t);
    }

    public boolean info() {
        return this.getLevel() <= Level.INFO.ordinal();
    }

    public void info(String message) {
        if (this.getLevel() > Level.INFO.ordinal()) {
            return;
        }
        this.logMessage(Level.INFO, message, null);
    }

    public void info(String message, Throwable t) {
        if (this.getLevel() > Level.INFO.ordinal()) {
            return;
        }
        this.logMessage(Level.INFO, message, t);
    }

    public boolean warn() {
        return this.getLevel() <= Level.WARN.ordinal();
    }

    public void warn(String message) {
        if (this.getLevel() > Level.WARN.ordinal()) {
            return;
        }
        this.logMessage(Level.WARN, message, null);
    }

    public void warn(String message, Throwable t) {
        if (this.getLevel() > Level.WARN.ordinal()) {
            return;
        }
        this.logMessage(Level.WARN, message, t);
    }

    public boolean error() {
        return this.getLevel() <= Level.ERROR.ordinal();
    }

    public void error(String message) {
        if (this.getLevel() > Level.ERROR.ordinal()) {
            return;
        }
        this.logMessage(Level.ERROR, message, null);
    }

    public void error(String message, Throwable t) {
        if (this.getLevel() > Level.ERROR.ordinal()) {
            return;
        }
        this.logMessage(Level.ERROR, message, t);
    }

    public boolean fatal() {
        return this.getLevel() <= Level.FATAL.ordinal();
    }

    public void fatal(String message) {
        if (this.getLevel() > Level.FATAL.ordinal()) {
            return;
        }
        this.logMessage(Level.FATAL, message, null);
    }

    public void fatal(String message, Throwable t) {
        if (this.getLevel() > Level.FATAL.ordinal()) {
            return;
        }
        this.logMessage(Level.FATAL, message, t);
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL,
        OFF;

    }
}

