/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.math;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.lecousin.framework.math.RangeBigInteger;
import net.lecousin.framework.text.StringParser;

public class FragmentedRangeBigInteger
extends LinkedList<RangeBigInteger> {
    private static final long serialVersionUID = -2633315842445860994L;

    public FragmentedRangeBigInteger() {
    }

    public FragmentedRangeBigInteger(RangeBigInteger r) {
        this.add(r);
    }

    @StringParser.Parse
    public FragmentedRangeBigInteger(String string) throws ParseException {
        String[] ranges;
        if (string == null || string.isEmpty()) {
            return;
        }
        char c = string.charAt(0);
        if (c == '{') {
            int end = string.indexOf(125);
            if (end < 0) {
                throw new ParseException("Missing }", 0);
            }
            string = string.substring(1, end);
        }
        for (String range : ranges = string.split(",")) {
            if ((range = range.trim()).isEmpty()) continue;
            this.addRange(new RangeBigInteger(range));
        }
    }

    public static FragmentedRangeBigInteger intersect(FragmentedRangeBigInteger list1, FragmentedRangeBigInteger list2) {
        FragmentedRangeBigInteger result = new FragmentedRangeBigInteger();
        if (list1.isEmpty() || list2.isEmpty()) {
            return result;
        }
        block0: for (RangeBigInteger r1 : list1) {
            for (RangeBigInteger r2 : list2) {
                if (r2.max.compareTo(r1.min) < 0) continue;
                if (r2.min.compareTo(r1.max) > 0) continue block0;
                BigInteger min = r1.min.max(r2.min);
                BigInteger max = r1.max.min(r2.max);
                result.addRange(min, max);
            }
        }
        return result;
    }

    public FragmentedRangeBigInteger copy() {
        FragmentedRangeBigInteger c = new FragmentedRangeBigInteger();
        for (RangeBigInteger r : this) {
            c.add(new RangeBigInteger(r));
        }
        return c;
    }

    public void addRange(RangeBigInteger r) {
        this.addRange(r.min, r.max);
    }

    public void addRange(BigInteger start, BigInteger end) {
        if (this.isEmpty()) {
            this.add(new RangeBigInteger(start, end));
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            RangeBigInteger r = (RangeBigInteger)this.get(i);
            if (end.compareTo(r.min) < 0) {
                if (end.equals(r.min.subtract(BigInteger.ONE))) {
                    r.min = start;
                } else {
                    this.add(i, new RangeBigInteger(start, end));
                }
                return;
            }
            if (start.equals(r.max.add(BigInteger.ONE))) {
                r.max = end;
                int j = i + 1;
                while (j < this.size()) {
                    RangeBigInteger r2 = (RangeBigInteger)this.get(j);
                    int c = end.compareTo(r2.min.subtract(BigInteger.ONE));
                    if (c < 0) break;
                    if (c == 0) {
                        r.max = r2.max;
                        this.remove(j);
                        break;
                    }
                    if (end.compareTo(r2.max) >= 0) {
                        this.remove(j);
                        continue;
                    }
                    r.max = r2.max;
                    this.remove(j);
                    break;
                }
                return;
            }
            if (start.compareTo(r.max) > 0) continue;
            if (start.compareTo(r.min) < 0) {
                r.min = start;
            }
            if (end.compareTo(r.max) <= 0) {
                return;
            }
            r.max = end;
            int j = i + 1;
            while (j < this.size()) {
                RangeBigInteger r2 = (RangeBigInteger)this.get(j);
                if (end.compareTo(r2.max) >= 0) {
                    this.remove(j);
                    continue;
                }
                if (end.compareTo(r2.min.subtract(BigInteger.ONE)) < 0) break;
                r.max = r2.max;
                this.remove(j);
                break;
            }
            return;
        }
        this.add(new RangeBigInteger(start, end));
    }

    public void addRanges(Collection<RangeBigInteger> ranges) {
        for (RangeBigInteger r : ranges) {
            this.addRange(r);
        }
    }

    public void addValue(BigInteger value) {
        if (this.isEmpty()) {
            this.add(new RangeBigInteger(value, value));
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            RangeBigInteger r = (RangeBigInteger)this.get(i);
            if (value.compareTo(r.min) < 0) {
                if (value.compareTo(r.min.subtract(BigInteger.ONE)) == 0) {
                    r.min = value;
                } else {
                    this.add(i, new RangeBigInteger(value, value));
                }
                return;
            }
            if (value.compareTo(r.max.add(BigInteger.ONE)) == 0) {
                r.max = value;
                if (i < this.size() - 1) {
                    RangeBigInteger r2 = (RangeBigInteger)this.get(i + 1);
                    if (r2.min.compareTo(value.add(BigInteger.ONE)) == 0) {
                        r.max = r2.max;
                        this.remove(i + 1);
                    }
                }
                return;
            }
            if (value.compareTo(r.max) > 0) continue;
            return;
        }
        this.add(new RangeBigInteger(value, value));
    }

    public boolean containsValue(long val) {
        BigInteger b = BigInteger.valueOf(val);
        return this.containsValue(b);
    }

    public boolean containsValue(BigInteger val) {
        for (RangeBigInteger r : this) {
            int c = r.min.compareTo(val);
            if (c <= 0 && val.compareTo(r.max) <= 0) {
                return true;
            }
            if (c <= 0) continue;
            return false;
        }
        return false;
    }

    public boolean containsRange(BigInteger min, BigInteger max) {
        for (RangeBigInteger r : this) {
            int i = min.compareTo(r.min);
            if (i >= 0 && max.compareTo(r.max) <= 0) {
                return true;
            }
            if (i >= 0) continue;
            return false;
        }
        return false;
    }

    public boolean containsOneValueIn(RangeBigInteger range) {
        for (RangeBigInteger r : this) {
            if (r.max.compareTo(range.min) < 0) continue;
            if (r.min.compareTo(range.max) > 0) break;
            return true;
        }
        return false;
    }

    public boolean containsOneValueIn(Collection<RangeBigInteger> ranges) {
        for (RangeBigInteger r : ranges) {
            if (!this.containsOneValueIn(r)) continue;
            return true;
        }
        return false;
    }

    public BigInteger getMin() {
        if (this.isEmpty()) {
            return BigInteger.ZERO;
        }
        return ((RangeBigInteger)this.getFirst()).min;
    }

    public BigInteger getMax() {
        if (this.isEmpty()) {
            return BigInteger.ZERO;
        }
        return ((RangeBigInteger)this.getLast()).max;
    }

    public RangeBigInteger removeBestRangeForSize(BigInteger size) {
        RangeBigInteger best = null;
        BigInteger bestSize = null;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            RangeBigInteger r = (RangeBigInteger)it.next();
            BigInteger l = r.getLength();
            int c = size.compareTo(l);
            if (c == 0) {
                it.remove();
                return r;
            }
            if (c > 0 || bestSize != null && bestSize.compareTo(l) <= 0) continue;
            best = r;
            bestSize = l;
        }
        if (best == null) {
            return null;
        }
        RangeBigInteger res = new RangeBigInteger(best.min, best.min.add(size).subtract(BigInteger.ONE));
        best.min = best.min.add(size);
        return res;
    }

    public RangeBigInteger removeBiggestRange() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.size() == 1) {
            return (RangeBigInteger)this.remove(0);
        }
        int biggestIndex = 0;
        RangeBigInteger r = (RangeBigInteger)this.get(0);
        BigInteger biggestSize = r.getLength();
        for (int i = 1; i < this.size(); ++i) {
            r = (RangeBigInteger)this.get(i);
            BigInteger l = r.getLength();
            if (l.compareTo(biggestSize) <= 0) continue;
            biggestSize = l;
            biggestIndex = i;
        }
        return (RangeBigInteger)this.remove(biggestIndex);
    }

    public BigInteger removeFirstValue() {
        if (this.isEmpty()) {
            return null;
        }
        RangeBigInteger r = (RangeBigInteger)this.getFirst();
        BigInteger value = r.min;
        if (r.min.equals(r.max)) {
            this.removeFirst();
        } else {
            r.min = r.min.add(BigInteger.ONE);
        }
        return value;
    }

    public void removeRange(BigInteger start, BigInteger end) {
        for (int i = 0; i < this.size(); ++i) {
            RangeBigInteger r = (RangeBigInteger)this.get(i);
            if (r.min.compareTo(end) > 0) {
                return;
            }
            if (r.max.compareTo(start) < 0) continue;
            if (r.min.compareTo(start) < 0) {
                if (r.max.equals(end)) {
                    r.max = start.subtract(BigInteger.ONE);
                    return;
                }
                if (r.max.compareTo(end) < 0) {
                    BigInteger j = r.max;
                    r.max = start.subtract(BigInteger.ONE);
                    start = j.add(BigInteger.ONE);
                    continue;
                }
                RangeBigInteger nr = new RangeBigInteger(end.add(BigInteger.ONE), r.max);
                r.max = start.subtract(BigInteger.ONE);
                this.add(i + 1, nr);
                return;
            }
            if (r.min.equals(start)) {
                if (r.max.equals(end)) {
                    this.remove(i);
                    return;
                }
                if (r.max.compareTo(end) < 0) {
                    this.remove(i);
                    start = r.max.add(BigInteger.ONE);
                    --i;
                    continue;
                }
                r.min = end.add(BigInteger.ONE);
                return;
            }
            if (r.max.equals(end)) {
                this.remove(i);
                return;
            }
            if (r.max.compareTo(end) < 0) {
                this.remove(i);
                start = r.max.add(BigInteger.ONE);
                --i;
                continue;
            }
            r.min = end.add(BigInteger.ONE);
            return;
        }
    }

    public void removeValue(BigInteger value) {
        this.removeRange(value, value);
    }

    public BigInteger getTotalSize() {
        BigInteger total = BigInteger.ZERO;
        for (RangeBigInteger r : this) {
            total = total.add(r.getLength());
        }
        return total;
    }

    public void addCopy(Collection<RangeBigInteger> col) {
        for (RangeBigInteger r : col) {
            this.addRange(r.min, r.max);
        }
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("{");
        boolean first = true;
        for (RangeBigInteger r : this) {
            if (first) {
                first = false;
            } else {
                s.append(",");
            }
            s.append("[").append(r.min).append("-").append(r.max).append("]");
        }
        s.append("}");
        return s.toString();
    }

    public static class Parser
    implements StringParser<FragmentedRangeBigInteger> {
        @Override
        public FragmentedRangeBigInteger parse(String string) throws ParseException {
            return new FragmentedRangeBigInteger(string);
        }
    }
}

