/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.math;

import net.lecousin.framework.math.IntegerUnit;

public interface TimeUnit
extends IntegerUnit {

    public static class Converter
    implements IntegerUnit.Converter {
        @Override
        public boolean supportConversion(Class<? extends IntegerUnit> from, Class<? extends IntegerUnit> to) {
            if (!(from.equals(Millisecond.class) || from.equals(Second.class) || from.equals(Minute.class) || from.equals(Hour.class) || from.equals(Day.class))) {
                return false;
            }
            return to.equals(Millisecond.class) || to.equals(Second.class) || to.equals(Minute.class) || to.equals(Hour.class) || to.equals(Day.class);
        }

        @Override
        public long convert(long value, Class<? extends IntegerUnit> from, Class<? extends IntegerUnit> to) throws IntegerUnit.UnitConversionException {
            return this.convertFromMilliseconds(this.convertToMilliseconds(value, from), to);
        }

        public long convertToMilliseconds(long value, Class<? extends IntegerUnit> unit) throws IntegerUnit.UnitConversionException {
            if (unit.equals(Millisecond.class)) {
                return value;
            }
            if (unit.equals(Second.class)) {
                return value * 1000L;
            }
            if (unit.equals(Minute.class)) {
                return value * 60L * 1000L;
            }
            if (unit.equals(Hour.class)) {
                return value * 60L * 60L * 1000L;
            }
            if (unit.equals(Day.class)) {
                return value * 24L * 60L * 60L * 1000L;
            }
            throw new IntegerUnit.UnitConversionException(unit, Millisecond.class, value);
        }

        public long convertFromMilliseconds(long value, Class<? extends IntegerUnit> unit) throws IntegerUnit.UnitConversionException {
            if (unit.equals(Millisecond.class)) {
                return value;
            }
            if (unit.equals(Second.class)) {
                return value / 1000L;
            }
            if (unit.equals(Minute.class)) {
                return value / 60000L;
            }
            if (unit.equals(Hour.class)) {
                return value / 3600000L;
            }
            if (unit.equals(Day.class)) {
                return value / 86400000L;
            }
            throw new IntegerUnit.UnitConversionException(Millisecond.class, unit, value);
        }
    }

    public static final class Day
    implements TimeUnit {
        private Day() {
        }
    }

    public static final class Hour
    implements TimeUnit {
        private Hour() {
        }
    }

    public static final class Minute
    implements TimeUnit {
        private Minute() {
        }
    }

    public static final class Second
    implements TimeUnit {
        private Second() {
        }
    }

    public static final class Millisecond
    implements TimeUnit {
        private Millisecond() {
        }
    }
}

